/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.avis.logging.Log;
import org.avis.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlacklistFilter
extends IoFilterAdapter
implements IoFilter {
    private Filter<InetAddress> blacklist;

    public BlacklistFilter(Filter<InetAddress> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        InetAddress address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        if (this.blacklist.matches(address)) {
            Log.diagnostic("Refusing non-TLS connection from host " + address + " due to it matching the hosts requiring authentication", this);
            session.close();
        } else {
            nextFilter.sessionOpened(session);
        }
    }
}

