/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.util.HashMap;
import java.util.Map;
import org.avis.config.Options;
import org.avis.io.LegacyConnectionOptions;
import org.avis.router.ConnectionOptionSet;
import org.avis.util.IllegalConfigOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnectionOptionSet
extends ConnectionOptionSet {
    public static final ClientConnectionOptionSet CLIENT_CONNECTION_OPTION_SET = new ClientConnectionOptionSet();

    public Map<String, Object> accepted(Options connectionOptions, Map<String, Object> requestedOptions) {
        HashMap<String, Object> accepted = new HashMap<String, Object>();
        for (String requestedOption : requestedOptions.keySet()) {
            String option = LegacyConnectionOptions.legacyToNew(requestedOption);
            if (!this.isDefined(option)) continue;
            Object value = connectionOptions.peek(option);
            if (value == null) {
                value = this.defaults.get(option);
            }
            if (requestedOption.equals("router.coalesce-delay")) {
                if (value.equals(0)) {
                    value = 1;
                } else if (value.equals(1)) {
                    value = 0;
                }
            }
            accepted.put(requestedOption, value);
        }
        return accepted;
    }

    @Override
    protected void validateAndSet(Options options, String option, Object value) throws IllegalConfigOptionException {
        if (option.equals("router.coalesce-delay")) {
            if (value.equals(0)) {
                value = 1;
            } else if (value.equals(1)) {
                value = 0;
            }
        }
        if (this.validate(option = LegacyConnectionOptions.legacyToNew(option), value) == null) {
            this.set(options, option, value);
        }
    }
}

