/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.avis.config.Options;
import org.avis.router.ClientConnectionOptions;
import org.avis.router.InvalidSubscriptionException;
import org.avis.router.Subscription;
import org.avis.router.SubscriptionMatch;
import org.avis.security.Keys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Connection {
    public ClientConnectionOptions options;
    public Keys subscriptionKeys;
    public Keys notificationKeys;
    public Long2ObjectOpenHashMap<Subscription> subscriptions = new Long2ObjectOpenHashMap();
    private ReentrantReadWriteLock lock;

    public Connection(Options defaultOptions, Map<String, Object> requestedOptions, Keys subscriptionKeys, Keys notificationKeys) {
        this.subscriptionKeys = subscriptionKeys;
        this.notificationKeys = notificationKeys;
        this.options = new ClientConnectionOptions(defaultOptions, requestedOptions);
        this.lock = new ReentrantReadWriteLock(true);
    }

    public void close() {
        this.options = null;
    }

    public boolean isOpen() {
        return this.options != null;
    }

    public void lockWrite() {
        this.lock.writeLock().lock();
    }

    public void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    public void lockRead() {
        this.lock.readLock().lock();
    }

    public void unlockRead() {
        this.lock.readLock().unlock();
    }

    public void addSubscription(Subscription sub) {
        this.subscriptions.put(sub.id, sub);
    }

    public Subscription removeSubscription(long subscriptionId) {
        return this.subscriptions.remove(subscriptionId);
    }

    public boolean subscriptionsFull() {
        return this.subscriptions.size() >= this.options.getInt("Subscription.Max-Count");
    }

    public boolean subscriptionTooLong(String expr) {
        return expr.length() > this.options.getInt("Subscription.Max-Length");
    }

    public boolean connectionKeysFull(Keys ntfnKeys, Keys subKeys) {
        int maxKeys = this.options.getInt("Connection.Max-Keys");
        return ntfnKeys.size() > maxKeys || subKeys.size() > maxKeys;
    }

    public boolean subscriptionKeysFull(Keys keys) {
        return keys.size() > this.options.getInt("Subscription.Max-Keys");
    }

    public SubscriptionMatch matchSubscriptions(Map<String, Object> attributes, Keys globalKeys, Keys messageKeys, boolean deliverInsecure) {
        SubscriptionMatch matches = new SubscriptionMatch();
        for (Subscription subscription : this.subscriptions.values()) {
            boolean secureMatch;
            boolean bl = secureMatch = this.subscriptionKeys.match(globalKeys) || this.subscriptionKeys.match(messageKeys) || subscription.keys.match(globalKeys) || subscription.keys.match(messageKeys);
            if (!secureMatch && (!deliverInsecure || !subscription.acceptInsecure) || !subscription.matches(attributes)) continue;
            if (secureMatch) {
                matches.secure.add(subscription.id);
                continue;
            }
            matches.insecure.add(subscription.id);
        }
        return matches;
    }

    public Subscription subscriptionFor(long id) throws InvalidSubscriptionException {
        Subscription subscription = this.subscriptions.get(id);
        if (subscription != null) {
            return subscription;
        }
        throw new InvalidSubscriptionException("No subscription with ID " + id);
    }
}

