/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.avis.common.ElvinURI;
import org.avis.common.InvalidURIException;
import org.avis.config.Options;
import org.avis.router.RouterOptionSet;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterOptions
extends Options {
    public RouterOptions() {
        this(new RouterOptionSet());
    }

    public RouterOptions(RouterOptionSet optionSet) {
        super(optionSet);
    }

    public RouterOptions(int port) {
        this();
        this.set("Port", port);
    }

    public RouterOptions(Properties properties) {
        this();
        this.setAll(properties);
    }

    public Set<ElvinURI> listenURIs() {
        HashSet<ElvinURI> uris = new HashSet<ElvinURI>();
        ElvinURI defaultUri = new ElvinURI("0.0.0.0", this.getInt("Port"));
        for (String listenItem : Text.split(this.getString("Listen"), "\\s+")) {
            try {
                ElvinURI uri = new ElvinURI(listenItem, defaultUri);
                if (!((Object)uri.protocol).equals(ElvinURI.defaultProtocol()) && !((Object)uri.protocol).equals(ElvinURI.secureProtocol())) {
                    throw new IllegalConfigOptionException("Listen", "Avis only supports protocols: " + ElvinURI.defaultProtocol() + " and " + ElvinURI.secureProtocol() + ": " + listenItem);
                }
                uris.add(uri);
            }
            catch (InvalidURIException ex) {
                throw new IllegalConfigOptionException("Listen", ex.getMessage());
            }
        }
        return uris;
    }
}

