/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import java.util.ArrayList;
import java.util.Collection;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentNode
extends Node {
    protected ArrayList<Node> children;

    public ParentNode() {
        this.children = new ArrayList(2);
    }

    public ParentNode(Node node1) {
        this();
        this.addChild(node1);
    }

    public ParentNode(Node node1, Node node2) throws IllegalChildException {
        this();
        this.addChild(node1);
        this.addChild(node2);
    }

    public ParentNode(Node ... children) {
        this.children = new ArrayList(children.length);
        for (Node child : children) {
            this.addChild(child);
        }
    }

    public ParentNode(Collection<? extends Node> children) {
        this.children = new ArrayList(children.size());
        for (Node node : children) {
            this.addChild(node);
        }
    }

    protected abstract String validateChild(Node var1);

    public void addChild(Node child) throws IllegalChildException {
        String error = this.validateChild(child);
        if (error != null) {
            throw new IllegalChildException(error, this, child);
        }
        this.children.add(child);
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Collection<Node> children() {
        return this.children;
    }
}

