/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast.nodes;

import java.util.Collection;
import java.util.Map;
import org.avis.subscription.ast.BoolParentNode;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class And
extends BoolParentNode {
    public And(Node node1) {
        super(node1);
    }

    public And(Node node1, Node node2) {
        super(node1, node2);
    }

    public And(Node ... children) {
        super(children);
    }

    public And(Collection<? extends Node> children) {
        super(children);
    }

    @Override
    public String expr() {
        return "&&";
    }

    @Override
    public Node inlineConstants() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Node child = (Node)this.children.get(i);
            Node newChild = child.inlineConstants();
            Boolean result = (Boolean)newChild.evaluate(EMPTY_NOTIFICATION);
            if (result == FALSE) {
                return Const.CONST_FALSE;
            }
            if (result == TRUE) {
                this.children.remove(i);
                continue;
            }
            if (child == newChild) continue;
            this.children.set(i, newChild);
        }
        if (this.children.isEmpty()) {
            return Const.CONST_TRUE;
        }
        if (this.children.size() == 1) {
            return (Node)this.children.get(0);
        }
        return this;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        Boolean value = TRUE;
        for (int i = 0; i < this.children.size(); ++i) {
            Object result = ((Node)this.children.get(i)).evaluate(attrs);
            if (result == FALSE) {
                return result;
            }
            if (result != BOTTOM) continue;
            value = BOTTOM;
        }
        return value;
    }
}

