/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast.nodes;

import java.util.Map;
import org.avis.subscription.ast.Node;
import org.avis.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Const
extends Node {
    public static final Const CONST_FALSE = new Const(FALSE);
    public static final Const CONST_TRUE = new Const(TRUE);
    public static final Const CONST_BOTTOM = new Const(BOTTOM);
    public static final Const CONST_ZERO = new Const(0);
    private Object value;

    public static Const bool(Boolean value) {
        if (value == TRUE) {
            return CONST_TRUE;
        }
        if (value == FALSE) {
            return CONST_FALSE;
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public static Const string(String string) {
        return new Const(string);
    }

    public static Const int32(int value) {
        if (value == 0) {
            return CONST_ZERO;
        }
        return new Const(value);
    }

    public static Node int64(long value) {
        return new Const(value);
    }

    public static Node real64(double value) {
        return new Const(value);
    }

    public Const(Object value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        return obj.getClass() == Const.class && Util.valuesEqual(((Const)obj).value, this.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public Object value() {
        return this.value;
    }

    @Override
    public Class<?> evalType() {
        if (this.value == BOTTOM) {
            return Boolean.class;
        }
        return this.value.getClass();
    }

    @Override
    public Node inlineConstants() {
        return this;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        return this.value;
    }

    @Override
    public String expr() {
        if (this.value instanceof String) {
            return "'" + this.value + "'";
        }
        if (this.value instanceof Number) {
            return this.numExpr();
        }
        return this.value.toString();
    }

    @Override
    public String presentation() {
        if (this.value instanceof String) {
            return "Str: \"" + this.value + '\"';
        }
        if (this.value instanceof Number) {
            return this.numPresentation();
        }
        return "Const: " + this.value;
    }

    private String numPresentation() {
        StringBuilder str = new StringBuilder("Num: ");
        str.append(this.value);
        if (this.value instanceof Long) {
            str.append('L');
        } else if (this.value instanceof Double) {
            str.append(" (double)");
        }
        return str.toString();
    }

    private String numExpr() {
        StringBuilder str = new StringBuilder();
        str.append(this.value);
        if (this.value instanceof Long) {
            str.append('L');
        }
        return str.toString();
    }
}

