/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast.nodes;

import java.util.Collection;
import java.util.Map;
import org.avis.subscription.ast.BoolParentNode;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Or
extends BoolParentNode {
    public Or() {
    }

    public Or(Node node1) {
        super(node1);
    }

    public Or(Node node1, Node node2) {
        super(node1, node2);
    }

    public Or(Collection<? extends Node> children) {
        super(children);
    }

    public Or(Node ... children) {
        super(children);
    }

    @Override
    public String expr() {
        return "||";
    }

    @Override
    public Node inlineConstants() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Node child = (Node)this.children.get(i);
            Node newChild = child.inlineConstants();
            Boolean result = (Boolean)newChild.evaluate(EMPTY_NOTIFICATION);
            if (result == TRUE) {
                return Const.CONST_TRUE;
            }
            if (result == FALSE) {
                this.children.remove(i);
                continue;
            }
            if (child == newChild) continue;
            this.children.set(i, newChild);
        }
        if (this.children.isEmpty()) {
            return Const.CONST_FALSE;
        }
        if (this.children.size() == 1) {
            return (Node)this.children.get(0);
        }
        return this;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        Boolean value = FALSE;
        for (int i = 0; i < this.children.size(); ++i) {
            Boolean result = (Boolean)((Node)this.children.get(i)).evaluate(attrs);
            if (result == TRUE) {
                return TRUE;
            }
            if (result != BOTTOM) continue;
            value = BOTTOM;
        }
        return value;
    }
}

