/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<E> {
    private List<E> listeners;
    private Method listenerMethod;

    public ListenerList(Class<E> listenerType, String method, Class<?> eventType) throws IllegalArgumentException {
        this.listenerMethod = ListenerList.lookupMethod(listenerType, method, eventType);
        this.listeners = Collections.emptyList();
    }

    public ListenerList(Class<E> listenerType, String method, Class<?> ... paramTypes) throws IllegalArgumentException {
        this.listenerMethod = ListenerList.lookupMethod(listenerType, method, paramTypes);
        this.listeners = Collections.emptyList();
    }

    public List<E> asList() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void add(E listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        ArrayList<E> newListeners = new ArrayList<E>(this.listeners.size() + 4);
        newListeners.addAll(this.listeners);
        newListeners.add(listener);
        this.listeners = newListeners;
    }

    public void remove(E listener) {
        ArrayList<E> newListeners = new ArrayList<E>(this.listeners);
        newListeners.remove(listener);
        this.listeners = newListeners;
    }

    public void fire(Object event) {
        if (!this.listeners.isEmpty()) {
            this.fire(new Object[]{event});
        }
    }

    public void fire(Object ... args) {
        List<E> fireList = this.listeners;
        for (int i = fireList.size() - 1; i >= 0; --i) {
            E listener = fireList.get(i);
            try {
                this.listenerMethod.invoke(listener, args);
                continue;
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Error in listener method", ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    private static Method lookupMethod(Class<?> targetClass, String methodName, Class<?> ... paramTypes) {
        try {
            Method method = targetClass.getMethod(methodName, paramTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("No method named " + methodName);
        }
    }
}

