/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.avis.util.Filter;
import org.avis.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardFilter
implements Filter<String> {
    private List<Pattern> patterns;

    public WildcardFilter(String wildcardPattern) {
        this(Collections.singleton(wildcardPattern));
    }

    public WildcardFilter(String ... wildcardPatterns) {
        this(Arrays.asList(wildcardPatterns));
    }

    public WildcardFilter(Collection<String> wildcardPatterns) {
        this.patterns = new ArrayList<Pattern>(wildcardPatterns.size());
        for (String wildcardExpr : wildcardPatterns) {
            this.patterns.add(Wildcard.toPattern(wildcardExpr, 2));
        }
    }

    public boolean isNull() {
        return this.patterns.isEmpty();
    }

    @Override
    public boolean matches(String string) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }
}

