/*
 * Decompiled with CFR 0.152.
 */
package dsto.dfc.tools;

import dsto.dfc.tools.RegexpResourceMatcher;
import dsto.dfc.tools.ResourceMatcher;
import dsto.dfc.tools.WildcardResourceMatcher;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarX {
    private static final String[] SYSTEM_PACKAGES = new String[]{"java.", "javax.accessibility", "javax.naming", "javax.rmi", "javax.net", "javax.sound", "javax.swing", "javax.transaction", "sun.", "org.omg", "com.sun.corba", "com.sun.image", "com.sun.java", "com.sun.javadoc", "com.sun.jdi", "com.sun.jndi", "com.sun.media", "com.sun.naming", "com.sun.net.ssl", "com.sun.org.omg", "com.sun.rmi.rmid", "com.sun.rsajca", "com.sun.rsasign", "com.sun.tools", "javax.media.j3d", "javax.vecmath", "com.sun.j3d.utils", "com.sun.j3d.audioengines", "com.sun.j3d.utils", "com.sun.j3d.loaders.lw3d", "com.sun.j3d.loaders.objectfile", "com.sun.j3d.loaders.Loader", "com.sun.j3d.loaders.Scene", "com.sun.j3d.loaders.LoaderBase", "com.sun.j3d.loaders.SceneBase", "com.sun.j3d.loaders.IncorrectFormatException", "com.sun.j3d.loaders.ParsingErrorException"};
    private final String[] SYSTEM_CLASSPATH = JarX.getSystemClassPath();
    private boolean useJarFormat = true;
    private File manifestFile = null;
    private Manifest manifest = null;
    private String mainClassName = null;
    private File archiveFile;
    private ZipOutputStream archiveStream;
    private ArrayList excludes = new ArrayList();
    private ArrayList roots = new ArrayList();
    private ArrayList rootMatchers = new ArrayList();
    private HashSet resources = new HashSet();
    private HashMap openZips = new HashMap();
    private String[] classPath = this.SYSTEM_CLASSPATH;
    private boolean autoFindResources = false;
    private final IntList classInfo = new IntList();
    private final IntList stringTbl = new IntList();
    private final Vector methInfo = new Vector();

    public JarX(File archiveFile) {
        this(archiveFile, true);
    }

    public JarX(File archiveFile, boolean useJarFormat) {
        this.archiveFile = archiveFile;
        this.useJarFormat = useJarFormat;
        this.setupDefaultExcludes();
    }

    public static String[] getSystemClassPath() {
        String path = System.getProperty("java.class.path");
        String pathsep = System.getProperty("path.separator");
        StringTokenizer tok = new StringTokenizer(path, pathsep);
        String[] classPath = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            classPath[i] = tok.nextToken();
            ++i;
        }
        return classPath;
    }

    public static String classToResourceName(String className) {
        return String.valueOf(className.replace('.', '/')) + ".class";
    }

    public void setUseJarFormat(boolean useJarFormat) {
        this.useJarFormat = useJarFormat;
    }

    public void setManifestFile(File newManifestFile) {
        this.manifestFile = newManifestFile;
        this.useJarFormat = true;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
        this.useJarFormat = true;
        String resourceName = JarX.classToResourceName(mainClassName);
        if (!this.roots.contains(resourceName)) {
            this.roots.add(resourceName);
        }
    }

    public void setClassPath(String[] newClassPath) {
        this.classPath = newClassPath;
    }

    public void clearExcludes() {
        this.excludes.clear();
    }

    public void addExcludes(String[] newExcludes) {
        this.addExcludes(Arrays.asList(newExcludes));
    }

    public void addExcludes(List newExcludes) {
        int i = 0;
        while (i < newExcludes.size()) {
            this.excludes.add(new WildcardResourceMatcher((String)newExcludes.get(i)));
            ++i;
        }
    }

    public void addExcludeRegexps(String[] newExcludes) throws IllegalArgumentException {
        this.addExcludeRegexps(Arrays.asList(newExcludes));
    }

    public void addExcludeRegexps(List newExcludes) throws IllegalArgumentException {
        int i = 0;
        while (i < newExcludes.size()) {
            this.excludes.add(new RegexpResourceMatcher((String)newExcludes.get(i)));
            ++i;
        }
    }

    public void addExcludeMatchers(ResourceMatcher[] newExcludes) {
        this.excludes.addAll(Arrays.asList(newExcludes));
    }

    public void addExcludeMatchers(List newExcludes) {
        this.excludes.addAll(newExcludes);
    }

    public void addRoots(String[] newRoots) {
        this.addRoots(Arrays.asList(newRoots));
    }

    public void addRoots(List newRoots) {
        int i = 0;
        while (i < newRoots.size()) {
            String newRoot = (String)newRoots.get(i);
            if (newRoot.indexOf(42) != -1) {
                this.rootMatchers.add(new WildcardResourceMatcher(newRoot));
            } else {
                this.roots.add(newRoot);
            }
            ++i;
        }
    }

    public void addRootRegexps(String[] regexps) {
        this.addRootRegexps(Arrays.asList(regexps));
    }

    public void addRootRegexps(List regexps) {
        int i = 0;
        while (i < regexps.size()) {
            this.rootMatchers.add(new RegexpResourceMatcher((String)regexps.get(i)));
            ++i;
        }
    }

    public void addRootMatchers(ResourceMatcher[] newResourceMatchers) {
        this.rootMatchers.addAll(Arrays.asList(newResourceMatchers));
    }

    public void addRootMatchers(List newResourceMatchers) {
        this.rootMatchers.addAll(newResourceMatchers);
    }

    public void setAutoFindResources(boolean newValue) {
        this.autoFindResources = newValue;
    }

    public void run() throws IOException {
        FileOutputStream archiveOutput = new FileOutputStream(this.archiveFile);
        try {
            if (this.useJarFormat) {
                this.manifest = this.manifestFile != null ? new Manifest(new FileInputStream(this.manifestFile)) : new Manifest();
                Attributes mainAttrs = this.manifest.getMainAttributes();
                mainAttrs.putValue("Manifest-Version", "1.0");
                if (this.mainClassName != null) {
                    mainAttrs.putValue("Main-Class", this.mainClassName);
                }
                this.archiveStream = new JarOutputStream(archiveOutput);
            } else {
                this.archiveStream = new ZipOutputStream(archiveOutput);
            }
            if (this.rootMatchers.isEmpty()) {
                this.runDirect();
            } else {
                this.runFullScan();
            }
            if (this.useJarFormat) {
                ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
                this.archiveStream.putNextEntry(manifestEntry);
                this.manifest.write(new BufferedOutputStream(this.archiveStream));
                this.archiveStream.closeEntry();
            }
            this.archiveStream.close();
            this.closeOpenZips();
        }
        catch (IOException ex) {
            try {
                if (this.archiveStream != null) {
                    this.archiveStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.archiveFile.delete();
            this.closeOpenZips();
            throw ex;
        }
    }

    public void dispose() {
        try {
            this.archiveStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeOpenZips();
    }

    protected void setupDefaultExcludes() {
        this.excludes.add(new RegexpResourceMatcher("CVS/"));
    }

    protected boolean isResourceIncludedByName(String resourceName) {
        int i = 0;
        while (i < this.roots.size()) {
            if (this.roots.get(i).equals(resourceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isResourceIncludedByMatch(String resourceName) {
        int i = 0;
        while (i < this.rootMatchers.size()) {
            ResourceMatcher matcher = (ResourceMatcher)this.rootMatchers.get(i);
            if (matcher.matches(resourceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isResourceExcludedByMatch(String resourceName) {
        int i = 0;
        while (i < this.excludes.size()) {
            ResourceMatcher matcher = (ResourceMatcher)this.excludes.get(i);
            if (matcher.matches(resourceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isResourceStored(String resourceName) {
        return this.resources.contains(resourceName);
    }

    protected boolean shouldStoreResource(String resourceName) {
        return !this.isResourceStored(resourceName) && this.shouldIncludeResource(resourceName);
    }

    protected boolean shouldIncludeResource(String resourceName) {
        return !JarX.isSystemClass(resourceName) && (this.isResourceIncludedByName(resourceName) || this.isResourceIncludedByMatch(resourceName) && !this.isResourceExcludedByMatch(resourceName));
    }

    protected boolean shouldIncludeImportedResource(String resourceName) {
        return !JarX.isSystemClass(resourceName) && (this.isResourceIncludedByName(resourceName) || !this.isResourceExcludedByMatch(resourceName));
    }

    protected boolean isZipArchive(String path) {
        String lPath = path.toLowerCase();
        return lPath.endsWith(".zip") || lPath.endsWith(".jar");
    }

    protected void runDirect() {
        int i = 0;
        while (i < this.roots.size()) {
            String root = (String)this.roots.get(i);
            try {
                if (this.shouldStoreResource(root)) {
                    this.addResourceFromClasspath(root);
                }
            }
            catch (IOException ex) {
                JarX.warn("Error adding resource '" + root + "': " + ex);
            }
            ++i;
        }
    }

    protected void runFullScan() {
        int i = 0;
        while (i < this.classPath.length) {
            String path = this.classPath[i];
            if (this.isZipArchive(path)) {
                this.scanArchive(path);
            } else {
                this.scanDirectory(new File(path), "");
            }
            ++i;
        }
    }

    protected void scanArchive(String archivePath) {
        try {
            ZipFile zipFile = this.findOrOpenZip(archivePath);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || !this.shouldStoreResource(entry.getName())) continue;
                this.addResourceFromZip(entry.getName(), zipFile);
            }
        }
        catch (IOException ex) {
            JarX.warn("Invalid archive found in classpath: " + archivePath + " (" + ex.getMessage() + ")");
        }
    }

    protected void scanDirectory(File directory, String resourcePath) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String newResourcePath = resourcePath.length() == 0 ? file.getName() : String.valueOf(resourcePath) + '/' + file.getName();
                if (file.isDirectory()) {
                    this.scanDirectory(file, newResourcePath);
                } else if (this.shouldStoreResource(newResourcePath)) {
                    try {
                        this.addResourceFromFile(newResourcePath, file);
                    }
                    catch (IOException ex) {
                        JarX.warn("Failed to add file '" + file.getAbsolutePath() + "': " + ex.getMessage());
                    }
                }
                ++i;
            }
        } else {
            JarX.warn("Invalid directory found on classpath: " + directory.getAbsolutePath());
        }
    }

    protected void addResourceFromZip(String resourceName, ZipFile zipFile) throws IOException {
        byte[] resourceData = this.readResourceDataFromZip(resourceName, zipFile);
        this.addResource(resourceName, resourceData);
    }

    protected void addResourceFromFile(String resourceName, File file) throws IOException {
        byte[] resourceData = this.readResourceDataFromFile(resourceName, file);
        this.addResource(resourceName, resourceData);
    }

    protected void addResourceFromClasspath(String resourceName) throws IOException {
        int i = 0;
        while (i < this.classPath.length) {
            try {
                byte[] resourceData = this.readResourceData(this.classPath[i], resourceName);
                this.addResource(resourceName, resourceData);
                return;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        throw new IOException("Resource '" + resourceName + "' not found in classpath");
    }

    protected void addResource(String resourceName, byte[] resourceData) throws IOException {
        this.storeResource(resourceName, resourceData);
        if (resourceName.endsWith(".class")) {
            String[] classResources = this.findClassResources(resourceName, resourceData);
            int i = 0;
            while (i < classResources.length) {
                String classResource = classResources[i];
                if (!this.isResourceStored(classResource) && this.shouldIncludeImportedResource(classResource)) {
                    try {
                        this.addResourceFromClasspath(classResource);
                    }
                    catch (IOException ex) {
                        JarX.warn("Failed to add resource " + classResource + " used by " + resourceName + " (" + ex.getMessage() + ")");
                    }
                }
                ++i;
            }
        }
    }

    protected byte[] readResourceData(String path, String resourceName) throws IOException {
        byte[] resourceData = null;
        if (this.isZipArchive(path)) {
            ZipFile zipFile = this.findOrOpenZip(path);
            resourceData = this.readResourceDataFromZip(resourceName, zipFile);
        } else {
            String fullName = path;
            if (!path.endsWith(File.separator)) {
                fullName = String.valueOf(fullName) + File.separatorChar;
            }
            fullName = String.valueOf(fullName) + resourceName.replace('/', File.separatorChar);
            resourceData = this.readResourceDataFromFile(resourceName, new File(fullName));
        }
        return resourceData;
    }

    protected byte[] readResourceDataFromFile(String resourceName, File resourceFile) throws IOException {
        if (resourceFile.exists() && resourceFile.isFile()) {
            FileInputStream resourceFileStream = new FileInputStream(resourceFile);
            long length = resourceFile.length();
            byte[] resourceData = new byte[(int)length];
            DataInputStream ds = new DataInputStream(resourceFileStream);
            ds.readFully(resourceData);
            ds.close();
            return resourceData;
        }
        throw new IOException("Resource file '" + resourceFile.getCanonicalPath() + "' not found");
    }

    protected byte[] readResourceDataFromZip(String resourceName, ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry(resourceName);
        if (entry == null) {
            throw new IOException("Resource '" + resourceName + "' not found in '" + zipFile + "'");
        }
        InputStream resourceStream = zipFile.getInputStream(entry);
        DataInputStream ds = new DataInputStream(resourceStream);
        int len = (int)entry.getSize();
        byte[] resourceData = new byte[len];
        ds.readFully(resourceData);
        ds.close();
        return resourceData;
    }

    protected void storeResource(String resourceName, byte[] resourceData) throws IOException {
        if (this.isResourceStored(resourceName)) {
            throw new Error("Resource '" + resourceName + "' is already stored");
        }
        this.resources.add(resourceName);
        ZipEntry entry = new ZipEntry(resourceName);
        entry.setSize(resourceData.length);
        this.archiveStream.putNextEntry(entry);
        this.archiveStream.write(resourceData, 0, resourceData.length);
        this.archiveStream.closeEntry();
        if (this.useJarFormat && this.manifest.getAttributes(resourceName) == null) {
            Attributes attrs = new Attributes();
            this.manifest.getEntries().put(resourceName, attrs);
        }
    }

    protected ZipFile findOrOpenZip(String zipFileName) throws IOException {
        ZipFile zipFile = (ZipFile)this.openZips.get(zipFileName);
        if (zipFile == null) {
            zipFile = new ZipFile(zipFileName);
            this.openZips.put(zipFileName, zipFile);
        }
        return zipFile;
    }

    protected void closeOpenZips() {
        Iterator i = this.openZips.values().iterator();
        while (i.hasNext()) {
            ZipFile zipFile = (ZipFile)i.next();
            try {
                zipFile.close();
            }
            catch (IOException ex) {
                JarX.error("Error while closing ZIP file '" + zipFile.getName() + "': " + ex);
            }
        }
        this.openZips.clear();
    }

    protected static void error(String message) {
        System.err.println("JarX: Error: " + message);
    }

    protected static void warn(String message) {
        System.err.println("JarX: Warning: " + message);
    }

    protected static void log(String message) {
        System.err.println("JarX: " + message);
    }

    protected String[] findClassResources(String className, byte[] classData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(classData);
        DataInputStream in = new DataInputStream(bais);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Invalid magic number in " + className);
        }
        in.readShort();
        short major = in.readShort();
        if (major < 45) {
            throw new IOException("Invalid version number in " + className + " major == " + major);
        }
        int count = in.readShort();
        this.classInfo.removeAll();
        this.stringTbl.removeAll();
        this.methInfo.removeAllElements();
        HandleTable cp = new HandleTable(count);
        int i = 1;
        block12: while (i < count) {
            byte tag = in.readByte();
            switch (tag) {
                case 7: {
                    short nameIndex = in.readShort();
                    this.classInfo.add(nameIndex);
                    cp.put(i, nameIndex);
                    break;
                }
                case 10: {
                    short clazz = in.readShort();
                    short nt = in.readShort();
                    this.methInfo.addElement(new Pair(clazz, nt));
                    break;
                }
                case 9: 
                case 11: {
                    in.skipBytes(4);
                    break;
                }
                case 8: {
                    short strIndex = in.readShort();
                    this.stringTbl.add(strIndex);
                    break;
                }
                case 3: 
                case 4: {
                    in.skipBytes(4);
                    break;
                }
                case 5: 
                case 6: {
                    in.skipBytes(8);
                    ++i;
                    break;
                }
                case 12: {
                    short name = in.readShort();
                    short sig = in.readShort();
                    cp.put(i, name, sig);
                    break;
                }
                case 1: {
                    String s = in.readUTF();
                    cp.put(i, s);
                    break;
                }
                default: {
                    JarX.warn("Unknown constant tag (" + tag + "@" + i + " of " + count + ") in " + className);
                    break block12;
                }
            }
            ++i;
        }
        in.close();
        Vector<String> v = new Vector<String>();
        int[] ia = this.classInfo.elements();
        int i2 = 0;
        while (i2 < ia.length) {
            block29: {
                String s;
                block30: {
                    int idx = ia[i2];
                    s = cp.getString(idx);
                    if (s == null) break block29;
                    if (!s.startsWith("[")) break block30;
                    while (s.startsWith("[")) {
                        s = s.substring(1);
                    }
                    if (!s.startsWith("L")) break block29;
                    s = s.substring(1, s.length() - 1);
                }
                v.addElement(String.valueOf(s) + ".class");
            }
            ++i2;
        }
        if (this.autoFindResources) {
            boolean resourceUsed = false;
            Object[] p = new Pair[this.methInfo.size()];
            this.methInfo.copyInto(p);
            int i3 = 0;
            while (i3 < p.length) {
                try {
                    String clazz = cp.getString(cp.getInt(((Pair)p[i3]).a));
                    if ("java/lang/Class".equals(clazz)) {
                        Pair nt = cp.getPair(((Pair)p[i3]).b);
                        String name = cp.getString(nt.a);
                        if (name.startsWith("getResource")) {
                            resourceUsed = true;
                            break;
                        }
                    }
                }
                catch (IndexOutOfBoundsException clazz) {
                    // empty catch block
                }
                ++i3;
            }
            if (resourceUsed) {
                int pos = className.lastIndexOf(47);
                String res = className.substring(0, pos + 1);
                ia = this.stringTbl.elements();
                int i4 = 0;
                while (i4 < ia.length) {
                    String s = String.valueOf(res) + cp.getString(ia[i4]);
                    v.addElement(s);
                    ++i4;
                }
            }
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        return a;
    }

    protected static boolean isSystemClass(String className) {
        className = className.replace('/', '.');
        int i = 0;
        while (i < SYSTEM_PACKAGES.length) {
            if (className.startsWith(SYSTEM_PACKAGES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static final class IntList {
        private int[] a = new int[8];
        private int size = 0;

        IntList() {
        }

        public final int size() {
            return this.size;
        }

        public void add(int i) {
            if (this.size >= this.a.length) {
                int[] na = new int[this.a.length * 2];
                System.arraycopy(this.a, 0, na, 0, this.size);
                this.a = na;
            }
            this.a[this.size++] = i;
        }

        public void removeAll() {
            this.size = 0;
        }

        public int[] elements() {
            int[] na = new int[this.size];
            System.arraycopy(this.a, 0, na, 0, this.size);
            return na;
        }
    }

    private static final class Pair {
        final int a;
        final int b;

        public Pair(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class HandleTable {
        private Object[] tbl;

        public HandleTable(int n) {
            this.tbl = new Object[n];
        }

        public void put(int i, Object name) {
            this.tbl[i] = name;
        }

        public void put(int i, int val) {
            this.put(i, new Integer(val));
        }

        public void put(int i, int a, int b) {
            this.put(i, new Pair(a, b));
        }

        public String getString(int i) {
            if (i >= this.tbl.length) {
                return null;
            }
            return (String)this.tbl[i];
        }

        public int getInt(int i) {
            return (Integer)this.tbl[i];
        }

        public Pair getPair(int i) {
            return (Pair)this.tbl[i];
        }
    }
}

