/*
 * Decompiled with CFR 0.152.
 */
package dsto.dfc.tools;

import dsto.dfc.tools.ResourceMatcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class WildcardResourceMatcher
implements ResourceMatcher {
    private String expression;
    private Pattern pattern;

    public WildcardResourceMatcher(String expression) throws IllegalArgumentException {
        try {
            if (expression.indexOf(42) != -1) {
                this.pattern = Pattern.compile(WildcardResourceMatcher.makeRegex(expression));
            }
            this.expression = expression;
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Invalid regular expression: " + ex.getMessage());
        }
    }

    public boolean matches(String resourceName) {
        if (this.pattern != null) {
            return this.pattern.matcher(resourceName).matches();
        }
        return this.expression.equals(resourceName);
    }

    private static String makeRegex(String wildcardExpr) {
        StringBuffer regex = new StringBuffer();
        int i = 0;
        while (i < wildcardExpr.length()) {
            char c = wildcardExpr.charAt(i);
            if (c == '*') {
                regex.append(".*");
            } else if (c == '.') {
                regex.append("\\.");
            } else {
                regex.append(c);
            }
            ++i;
        }
        return regex.toString();
    }
}

