<?php
/**
 * This file implements the system diagnostics support functions.
 *
 * b2evolution - {@link http://b2evolution.net/}
 * Released under GNU GPL License - {@link http://b2evolution.net/about/license.html}
 *
 * @copyright (c)2003-2009 by Francois PLANQUE - {@link http://fplanque.net/}
 *
 * {@internal Open Source relicensing agreement:
 * }}
 *
 * @package admin
 *
 * {@internal Below is a list of authors who have contributed to design/coding of this file: }}
 * @author fplanque: Francois PLANQUE.
 *
 * @version $Id: _system.funcs.php,v 1.6 2009/05/15 19:11:37 fplanque Exp $
 */


/**
 * Check that the media dir is ready for operation, i-e writable by PHP.
 *
 * @return array {status,msg}
 */
function system_check_media_dir()
{
	global $media_path;

	if( ! is_dir( $media_path ) )
	{
		$mediadir_msg = T_( 'Media directory doesn\'t exist.' );
		$mediadir_status = 'error';
	}
	elseif( ! is_readable( $media_path ) )
	{
		$mediadir_msg = T_( 'Media directory is not readable.' );
		$mediadir_status = 'error';
	}
	elseif( ! is_writable( $media_path ) )
	{
		$mediadir_msg = T_( 'Media directory is not writable.' );
		$mediadir_status = 'error';
	}
	else
	{
		$mediadir_msg = T_( 'Ok' );
		$mediadir_status = 'ok';
	}

	return array( $mediadir_status, $mediadir_msg );
}


/**
 * @return boolean true if install directory has been removed
 */
function system_check_install_removed()
{
	global $basepath, $install_subdir;
	return ! is_dir( $basepath.$install_subdir );
}


/**
 * @return boolean true if DB supports UTF8
 */
function system_check_db_utf8()
{
	global $DB;

	$save_show_errors = $DB->show_errors;
	$save_halt_on_error = $DB->halt_on_error;
	$last_error = $DB->last_error;
	$error = $DB->error;
	// Blatantly ignore any error generated by SET NAMES...
	$DB->show_errors = false;
	$DB->halt_on_error = false;
	if( $DB->query( 'SET NAMES utf8' ) === false )
	{
		$ok = false;
	}
	else
	{
		$ok = true;
	}
	$DB->show_errors = $save_show_errors;
	$DB->halt_on_error = $save_halt_on_error;
	$DB->last_error = $last_error;
	$DB->error = $error;

	return $ok;
}


/**
 * @return array {id,name,name+id}
 */
function system_check_process_user()
{
	$process_uid = NULL;
	$process_user = NULL;
	if( function_exists('posix_geteuid') )
	{
		$process_uid = posix_geteuid();

		if( function_exists('posix_getpwuid')
			&& ($process_user = posix_getpwuid($process_uid)) )
		{
			$process_user = $process_user['name'];
		}

		$running_as = sprintf( '%s (uid %s)',
			($process_user ? $process_user : '?'), (!is_null($process_uid) ? $process_uid : '?') );
	}
	else
	{
		$running_as = '('.T_('Unknown').')';
	}

	return array( $process_uid, $process_user, $running_as );
}



/**
 * @return array {id,name,name+id}
 */
function system_check_process_group()
{
	$process_gid = null;
	$process_group = null;
	if( function_exists('posix_getegid') )
	{
		$process_gid = posix_getegid();

		if( function_exists('posix_getgrgid')
			&& ($process_group = posix_getgrgid($process_gid)) )
		{
			$process_group = $process_group['name'];
		}

		$running_as = sprintf( '%s (gid %s)',
			($process_group ? $process_group : '?'), (!is_null($process_gid) ? $process_gid : '?') );
	}
	else
	{
		$running_as = '('.T_('Unknown').')';
	}

	return array( $process_gid, $process_group, $running_as );
}


/**
 * @return integer
 */
function system_check_upload_max_filesize()
{
	$upload_max_filesize = ini_get('upload_max_filesize');
	if( strpos( $upload_max_filesize, 'M' ) )
	{
		$upload_max_filesize = intval($upload_max_filesize) * 1024;
	}

	return $upload_max_filesize;
}

/**
 * @return integer
 */
function system_check_post_max_size()
{
	$post_max_size = ini_get('post_max_size');
	if( strpos( $post_max_size, 'M' ) )
	{
		$post_max_size = intval($post_max_size) * 1024;
	}
	return $post_max_size;
}

/**
 * @return integer
 */
function system_check_memory_limit()
{
	$memory_limit = ini_get('memory_limit');

	if( strpos( $memory_limit, 'M' ) )
	{
		$memory_limit = intval($memory_limit) * 1024;
	}
	return $memory_limit;
}


/**
 * @return string
 */
function system_check_gd_version()
{
	if( ! function_exists( 'gd_info' ) )
	{
		return NULL;
	}

	$gd_info = gd_info();
	$gd_version = $gd_info['GD Version'];

	return $gd_version;
}


?>
