<?php
/**
 * This is the init file for the core module.
 *
 * This file is part of the evoCore framework - {@link http://evocore.net/}
 * See also {@link http://sourceforge.net/projects/evocms/}.
 *
 * @copyright (c)2003-2010 by Francois PLANQUE - {@link http://fplanque.net/}
 *
 * {@internal License choice
 * - If you have received this file as part of a package, please find the license.txt file in
 *   the same folder or the closest folder above for complete license terms.
 * - If you have received this file individually (e-g: from http://evocms.cvs.sourceforge.net/)
 *   then you must choose one of the following licenses before using the file:
 *   - GNU General Public License 2 (GPL) - http://www.opensource.org/licenses/gpl-license.php
 *   - Mozilla Public License 1.1 (MPL) - http://www.opensource.org/licenses/mozilla1.1.php
 * }}
 *
 * {@internal Open Source relicensing agreement:
 * }}
 *
 * @package evocore
 *
 * {@internal Below is a list of authors who have contributed to design/coding of this file: }}
 * @author fplanque: Francois PLANQUE.
 *
 * @version $Id: __core.init.php,v 1.63.2.2 2010/06/13 22:30:17 sam2kb Exp $
 */
if( !defined('EVO_CONFIG_LOADED') ) die( 'Please, do not access this page directly.' );

/**
 * This is supposed to be overriden by sth more useful when a more useful module is loaded
 * Typically should be 'dashboard'
 */
$default_ctrl = 'settings';

/**
 * Aliases for table names:
 *
 * (You should not need to change them.
 *  If you want to have multiple b2evo installations in a single database you should
 *  change {@link $tableprefix} in _basic_config.php)
 */
$db_config['aliases'] = array(
		'T_antispam'              => $tableprefix.'antispam',
		'T_cron__log'             => $tableprefix.'cron__log',
		'T_cron__task'            => $tableprefix.'cron__task',
		'T_country'               => $tableprefix.'country',
		'T_currency'              => $tableprefix.'currency',
		'T_groups'                => $tableprefix.'groups',
		'T_groups__groupsettings' => $tableprefix.'groups__groupsettings',
		'T_global__cache'         => $tableprefix.'global__cache',
		'T_locales'               => $tableprefix.'locales',
		'T_plugins'               => $tableprefix.'plugins',
		'T_pluginevents'          => $tableprefix.'pluginevents',
		'T_pluginsettings'        => $tableprefix.'pluginsettings',
		'T_pluginusersettings'    => $tableprefix.'pluginusersettings',
		'T_settings'              => $tableprefix.'settings',
		'T_users'                 => $tableprefix.'users',
		'T_users__fielddefs'      => $tableprefix.'users__fielddefs',
		'T_users__fields'         => $tableprefix.'users__fields',
		'T_users__usersettings'   => $tableprefix.'users__usersettings',
		'T_slug'                  => $tableprefix.'slug',
	);


/**
 * Controller mappings.
 *
 * For each controller name, we associate a controller file to be found in /inc/ .
 * The advantage of this indirection is that it is easy to reorganize the controllers into
 * subdirectories by modules. It is also easy to deactivate some controllers if you don't
 * want to provide this functionality on a given installation.
 *
 * Note: while the controller mappings might more or less follow the menu structure, we do not merge
 * the two tables since we could, at any time, decide to make a skin with a different menu structure.
 * The controllers however would most likely remain the same.
 *
 * @global array
 */
$ctrl_mappings = array(
		'antispam'     => 'antispam/antispam_list.ctrl.php',
		'crontab'      => 'cron/cronjobs.ctrl.php',
		'countries'    => 'regional/countries.ctrl.php',
		'currencies'   => 'regional/currencies.ctrl.php',
		'features'     => 'settings/features.ctrl.php',
		'locales'      => 'locales/locales.ctrl.php',
		'plugins'      => 'plugins/plugins.ctrl.php',
		'settings'     => 'settings/settings.ctrl.php',
		'set_antispam' => 'antispam/antispam_settings.ctrl.php',
		'stats'        => 'sessions/stats.ctrl.php',
		'system'       => 'tools/system.ctrl.php',
		'user'         => 'users/user.ctrl.php',
		'users'        => 'users/users.ctrl.php',
		'userfields'   => 'users/userfields.ctrl.php',
		'usersettings' => 'users/settings.ctrl.php',
		'registration' => 'users/registration.ctrl.php',
		'groups'       => 'users/groups.ctrl.php',
		'upload'       => 'files/upload.ctrl.php',
		'slugs'        => 'slugs/slugs.ctrl.php',
	);


/**
 * Get the CountryCache
 *
 * @return CountryCache
 */
function & get_CountryCache()
{
	global $CountryCache;

	if( ! isset( $CountryCache ) )
	{	// Cache doesn't exist yet:
		$CountryCache = new DataObjectCache( 'Country', true, 'T_country', 'ctry_', 'ctry_ID', 'ctry_code', 'ctry_name', 'Unknown');
	}

	return $CountryCache;
}

/**
 * Get the CurrencyCache
 *
 * @return CurrencyCache
 */
function & get_CurrencyCache()
{
	global $CurrencyCache;

	if( ! isset( $CurrencyCache ) )
	{	// Cache doesn't exist yet:
		$CurrencyCache = new DataObjectCache( 'Currency', true, 'T_currency', 'curr_', 'curr_ID', 'curr_code', 'curr_code');
	}

	return $CurrencyCache;
}


/**
 * Get the GroupCache
 *
 * @return GroupCache
 */
function & get_GroupCache()
{
	global $Plugins;
	global $GroupCache;

	if( ! isset( $GroupCache ) )
	{	// Cache doesn't exist yet:
		$Plugins->get_object_from_cacheplugin_or_create( 'GroupCache', 'new DataObjectCache( \'Group\', true, \'T_groups\', \'grp_\', \'grp_ID\', \'grp_name\', \'\', T_(\'No group\') )' );
	}

	return $GroupCache;
}


/**
 * Get the Plugins_admin
 *
 * @return Plugins_admin
 */
function & get_Plugins_admin()
{
	global $Plugins_admin;

	if( ! isset( $Plugins_admin ) )
	{	// Cache doesn't exist yet:
		load_class( 'plugins/model/_plugins_admin.class.php', 'Plugins_admin' );
		$Plugins_admin = new Plugins_admin(); // COPY (FUNC)
	}

	return $Plugins_admin;
}


/**
 * Get the UserCache
 *
 * @return UserCache
 */
function & get_UserCache()
{
	global $UserCache;

	if( ! isset( $UserCache ) )
	{	// Cache doesn't exist yet:
		load_class( 'users/model/_usercache.class.php', 'UserCache' );
		$UserCache = new UserCache(); // COPY (FUNC)
	}

	return $UserCache;
}


/**
 * Get the UserFieldCache
 *
 * @return UserFieldCache
 */
function & get_UserFieldCache()
{
	global $UserFieldCache;

	if( ! isset( $UserFieldCache ) )
	{	// Cache doesn't exist yet:
		$UserFieldCache = new DataObjectCache( 'Userfield', false, 'T_users__fielddefs', 'ufdf_', 'ufdf_ID', 'ufdf_name', 'ufdf_name' ); // COPY (FUNC)
	}

	return $UserFieldCache;
}


/**
 * Get the SlugCache
 *
 * @return SlugCache
 */
function & get_SlugCache()
{
	global $SlugCache;

	if( ! isset( $SlugCache ) )
	{	// Cache doesn't exist yet:
		$SlugCache = new DataObjectCache( 'Slug', false, 'T_slug', 'slug_', 'slug_ID', 'slug_title', 'slug_title' );
	}

	return $SlugCache;
}


/**
 * _core_Module definition
 */
class _core_Module extends Module
{
	/**
	 * Do the initializations. Called from in _main.inc.php.
	 * This is typically where classes matching DB tables for this module are registered/loaded.
	 *
	 * Note: this should only load/register things that are going to be needed application wide,
	 * for example: for constructing menus.
	 * Anything that is needed only in a specific controller should be loaded only there.
	 * Anything that is needed only in a specific view should be loaded only there.
	 */
	function init()
	{
		load_class( '_core/model/dataobjects/_dataobjectcache.class.php', 'DataObjectCache' );
		load_class( 'generic/model/_genericelement.class.php', 'GenericElement' );
		load_class( 'generic/model/_genericcache.class.php', 'GenericCache' );
		load_funcs( 'users/model/_user.funcs.php' );
		load_funcs( '_core/_template.funcs.php' );
		load_funcs( '_core/ui/forms/_form.funcs.php');
		load_class( '_core/ui/forms/_form.class.php', 'Form' );
		load_class( '_core/model/db/_sql.class.php', 'SQL' );
		load_class( '_core/ui/results/_results.class.php', 'Results' );
		load_class( '_core/model/_blockcache.class.php', 'BlockCache' );
		load_class( 'slugs/model/_slug.class.php', 'Slug' );
	}

	/**
	 * Build teh evobar menu
	 */
	function build_evobar_menu()
	{
		/**
		 * @var Menu
		 */
		global $topleft_Menu, $topright_Menu;
		global $current_User;
		global $home_url, $admin_url, $dispatcher, $debug, $seo_page_type, $robots_index;
		global $Blog, $blog;

		global $Settings;

		$entries = array(
			'b2evo' => array(
					'text' => '<strong>b2evolution</strong>',
					'href' => $home_url,
				),
			'dashboard' => array(
					'text' => T_('Dashboard'),
					'href' => $admin_url,
					'title' => T_('Go to admin dashboard'),
				),
			'see' => array(
					'text' => T_('See'),
					'href' => $home_url,
					'title' => T_('See the home page'),
				),
			'write' => array(
					'text' => T_('Write'),
					'title' => T_('No blog is currently selected'),
					'disabled' => true,
				),
			'manage' => array(
					'text' => T_('Manage'),
					'title' => T_('No blog is currently selected'),
					'disabled' => true,
				),
			'customize' => array(
					'text' => T_('Customize'),
					'title' => T_('No blog is currently selected'),
					'disabled' => true,
				),
			'tools' => array(
					'text' => T_('Tools'),
					'disabled' => true,
				),
		);

		if( !empty($Blog) )
		{	// A blog is currently selected:
			$entries['dashboard']['href'] = $admin_url.'?blog='.$Blog->ID;
			$entries['see']['href'] = $Blog->get( 'url' );


			$entries['see']['title'] = T_('See the public view of this blog');


			if( $current_User->check_perm( 'blog_post_statuses', 'edit', false, $Blog->ID ) )
			{	// We have permission to add a post with at least one status:
				$entries['write']['href'] = $admin_url.'?ctrl=items&amp;action=new&amp;blog='.$Blog->ID;
				$entries['write']['disabled'] = false;
				$entries['write']['title'] = T_('Write a new post into this blog');
			}
			else
			{
				$entries['write']['title'] = T_('You don\'t have permission to post into this blog');
			}


 			$items_url = $admin_url.'?ctrl=items&amp;blog='.$Blog->ID.'&amp;filter=restore';
			$entries['manage']['href'] = $items_url;
			$entries['manage']['disabled'] = false;
			$entries['manage']['title'] = T_('Manage the contents of this blog');
			$entries['manage']['entries'] = array(
					'posts' => array(
							'text' => T_('Posts').'&hellip;',
							'href' => $items_url.'&amp;tab=list',
						),
					'pages' => array(
							'text' => T_('Pages').'&hellip;',
							'href' => $items_url.'&amp;tab=pages',
						),
					'intros' => array(
							'text' => T_('Intro posts').'&hellip;',
							'href' => $items_url.'&amp;tab=intros',
						),
					'podcasts' => array(
							'text' => T_('Podcast episodes').'&hellip;',
							'href' => $items_url.'&amp;tab=podcasts',
						),
					'links' => array(
							'text' => T_('Sidebar links').'&hellip;',
							'href' => $items_url.'&amp;tab=links',
						),
				);
			if( $Blog->get_setting( 'use_workflow' ) )
			{	// We want to use workflow properties for this blog:
				$entries['manage']['entries']['tracker'] = array(
						'text' => T_('Tracker').'&hellip;',
						'href' => $items_url.'&amp;tab=tracker',
					);
			}
			$entries['manage']['entries']['full'] = array(
					'text' => T_('All Items').'&hellip;',
					'href' => $items_url.'&amp;tab=full',
				);
		}

		// Check if user has permission for published, draft or depreceted comments (any of these)
		$perm_comments = (! empty($Blog)) && $current_User->check_perm( 'blog_comments', 'edit', false, $Blog->ID );
		// Either permission for a specific blog or the global permission:
		$perm_files    = $current_User->check_perm( 'files', 'view', false, (! empty($Blog)) ? $Blog->ID : NULL );
		$perm_chapters = (! empty($Blog)) && $current_User->check_perm( 'blog_cats', 'edit', false, $Blog->ID );

		if( $perm_comments || $perm_files || $perm_chapters )
		{
			$entries['manage']['disabled'] = false;

			if( ! empty($entries['manage']['entries']) )
			{	// There are already entries aboce, insert a separator:
				$entries['manage']['entries'][] = array(
					'separator' => true,
				);
			}

			if( $perm_comments )
			{	// Comments:
				$entries['manage']['entries']['comments'] = array(
						'text' => T_('Comments').'&hellip;',
						'href' => $admin_url.'?ctrl=comments&amp;blog='.$Blog->ID.'&amp;filter=restore',
					);
			}

			if( $perm_files )
			{	// FM enabled and permission to view files:
				$entries['manage']['entries']['files'] = array(
						'text' => T_('Files').'&hellip;',
						'href' => $admin_url.'?ctrl=files&amp;blog='.$blog,
					);
			}

			if( $perm_chapters )
			{	// Chapters:
				$entries['manage']['entries']['chapters'] = array(
						'text' => T_('Categories').'&hellip;',
						'href' => $admin_url.'?ctrl=chapters&amp;blog='.$Blog->ID,
					);
			}
		}



		if( $current_User->check_perm( 'options', 'view' ) )
		{	// Permission to access system info
			$entries['b2evo']['entries']['system'] = array(
					'text' => T_('About this system').'&hellip;',
					'href' => $admin_url.'?ctrl=system',
				);
			$entries['b2evo']['entries'][] = array(
					'separator' => true,
				);
		}

		// CUSTOMIZE:
		if( !empty($Blog) && $current_User->check_perm( 'blog_properties', 'edit', false, $Blog->ID ) )
		{	// We have permission to edit blog properties:
			$blog_param = '&amp;blog='.$Blog->ID;

			$entries['customize']['href'] = $admin_url.'?ctrl=widgets'.$blog_param;
			$entries['customize']['disabled'] = false;
			$entries['customize']['title'] = T_('Customize this blog');

			$entries['customize']['entries'] = array(
				'general' => array(
						'text' => T_('Blog properties').'&hellip;',
						'href' => $admin_url.'?ctrl=coll_settings'.$blog_param,
					),
				'features' => array(
						'text' => T_('Blog features').'&hellip;',
						'href' => $admin_url.'?ctrl=coll_settings&amp;tab=features'.$blog_param,
					),
				'skin' => array(
						'text' => T_('Blog skin').'&hellip;',
						'href' => $admin_url.'?ctrl=coll_settings&amp;tab=skin'.$blog_param,
					),
				'widgets' => array(
						'text' => T_('Blog widgets').'&hellip;',
						'href' => $admin_url.'?ctrl=widgets'.$blog_param,
					),
				'urls' => array(
						'text' => T_('Blog URLs').'&hellip;',
						'href' => $admin_url.'?ctrl=coll_settings&amp;tab=urls'.$blog_param,
					),
			);
		}


		// TOOLS:
		$perm_spam = $current_User->check_perm( 'spamblacklist', 'view', false );
		$perm_options = $current_User->check_perm( 'options', 'view' );
		$perm_slugs = $current_User->check_perm( 'slugs', 'view' );
		if( $perm_spam || $perm_options || $perm_slugs )
		{	// Permission to view settings:
			if( $perm_spam )
			{
				$entries['tools']['entries']['antispam'] = array(
						'text' => T_('Antispam blacklist').'&hellip;',
						'href' => $admin_url.'?ctrl=antispam',
					);
			}

			if( $perm_options )
			{
				$entries['tools']['entries']['crontab'] = array(
						'text' => T_('Scheduler').'&hellip;',
						'href' => $admin_url.'?ctrl=crontab',
					);
			}

			if( $perm_slugs )
			{
				$entries['tools']['entries']['slugs'] = array(
						'text' => T_('Slugs').'&hellip;',
						'href' => $admin_url.'?ctrl=slugs' );
			}
		}

		if( $debug )
		{
			$debug_text = 'DEBUG: ';
			if( !empty($seo_page_type) )
			{	// Set in skin_init()
				$debug_text = $seo_page_type.': ';
			}
			if( $robots_index === false )
			{
				$debug_text .= 'NO INDEX';
			}
			else
			{
				$debug_text .= 'do index';
			}

			$entries['tools']['entries']['noindex_sep'] = array(
					'separator' => true,
				);
			$entries['tools']['entries']['noindex'] = array(
					'text' => $debug_text,
					'disabled' => true,
				);
		}

		$topleft_Menu->add_menu_entries( NULL, $entries );




		// ---------------------------------------------------------------------------

		/*
		 * RIGHT MENU
		 */
		global $localtimenow, $is_admin_page;

		$allow_avatars = $Settings->get('allow_avatars');

		$entries = array(
			'userprefs' => array(
					'text' => ($allow_avatars ? $current_User->get_avatar_imgtag( 'crop-15x15', '', 'top' ).' ' : '' ).'<strong>'.$current_User->login.'</strong>',
					'href' => get_user_profile_url(),
					'entries' => array(
						'profile' => array(
								'text' => T_('Edit user profile').'&hellip;',
								'href' => get_user_profile_url(),
							),
						),
				),
			'time' => array(
					'text' => date( locale_shorttimefmt(), $localtimenow ),
					// fp> TODO href to Timezone settings if permission
					'disabled' => true,
					'class' => 'noborder',
				),
		);

		if( $subs_url = get_user_subs_url() )
		{
			$entries['userprefs']['entries']['subscriptions'] = array(
					'text' => T_('Email subscriptions').'&hellip;',
					'href' => $subs_url,
				);
		}

		// ADMIN SKINS:
		if( $is_admin_page )
		{
			$admin_skins = get_admin_skins();
			if( count( $admin_skins ) > 1 )
			{	// We have several admin skins available: display switcher:
				$entries['userprefs']['entries']['admskins_sep'] = array(
						'separator' => true,
					);
				$entries['userprefs']['entries']['admskins'] = array(
						'text' => T_('Admin skin'),
					);
				$redirect_to = rawurlencode(regenerate_url('', '', '', '&'));
				foreach( $admin_skins as $admin_skin )
				{
					$entries['userprefs']['entries']['admskins']['entries'][$admin_skin] = array(
							'text' => $admin_skin,
							'href' => $dispatcher.'?ctrl=users&amp;action=change_admin_skin&amp;new_admin_skin='.rawurlencode($admin_skin)
								.'&amp;redirect_to='.$redirect_to
						);
				}
			}
		}


		$entries['userprefs']['entries']['logout_sep'] = array(
				'separator' => true,
			);
		$entries['userprefs']['entries']['logout'] = array(
				'text' => T_('Logout'),
				'href' => get_user_logout_url(),
			);

		// AB switch:
		if( $current_User->check_perm( 'admin', 'any' ) )
		{	// User must have permission to access admin...
			if( $is_admin_page )
			{
				if( !empty( $Blog ) )
				{
					$entries['abswitch'] = array(
							'text' => T_('Blog').' '.get_icon('switch-to-blog'),
							'href' => $Blog->get( 'url' ),
						);
				}
				else
				{
					$entries['abswitch'] = array(
							'text' => T_('Home').' '.get_icon('switch-to-blog'),
							'href' => $home_url,
						);
				}
			}
			else
			{
				$entries['abswitch'] = array(
						'text' => T_('Admin').' '.get_icon('switch-to-admin'),
						'href' => $admin_url,
					);
			}
		}

		$topright_Menu->add_menu_entries( NULL, $entries );

		$topright_Menu->add_menu_entries( NULL, array(
			'logout' => array(
				'text' => T_('Logout').' '.get_icon('close'),
				'class' => 'rollover',
				'href' => get_user_logout_url(),
				)
		 ) );

	}


	/**
	 * Builds the 3rd half of the menu. This is the one with the configuration features
	 *
	 * At some point this might be displayed differently than the 1st half.
	 */
	function build_menu_3()
	{
		global $blog, $loc_transinfo, $ctrl, $dispatcher, $Settings;
		/**
		 * @var User
		 */
		global $current_User;
		global $Blog;
		/**
		 * @var AdminUI_general
		 */
		global $AdminUI;

		if( $current_User->check_perm( 'options', 'view' ) )
		{	// Permission to view settings:
			$AdminUI->add_menu_entries( NULL, array(
						'options' => array(
							'text' => T_('Global settings'),
							'href' => $dispatcher.'?ctrl=settings',
							'entries' => array(
								'general' => array(
									'text' => T_('General'),
									'href' => '?ctrl=settings' ),
								'features' => array(
									'text' => T_('Features'),
									'href' => '?ctrl=features' ),
								'antispam' => array(
									'text' => T_('Antispam'),
									'href' => '?ctrl=set_antispam'),
								'regional' => array(
									'text' => T_('Regional'),
									'href' => '?ctrl=locales'.( (isset($loc_transinfo) && $loc_transinfo) ? '&amp;loc_transinfo=1' : '' ) ),
								'countries' => array(
									'text' => T_('Countries'),
									'href' => '?ctrl=countries'),
								'currencies' => array(
									'text' => T_('Currencies'),
									'href' => '?ctrl=currencies'),
								'plugins' => array(
									'text' => T_('Plugins'),
									'href' => '?ctrl=plugins'),
							)
						),
					) );
		}

		if( $current_User->check_perm( 'users', 'view' ) )
		{	// Permission to view users:
			$users_entries = array(
						'text' => T_('Users'),
						'title' => T_('User management'),
						'href' => '?ctrl=users' );

			$user_ID = param( 'user_ID', 'integer', NULL );
		}
		else
		{
			$user_ID = $current_User->ID;
			// Only perm to view his own profile:
			$users_entries = array(
						'text' => T_('My profile'),
						'title' => T_('User profile'),
						'href' => '?ctrl=user&amp;user_tab=identity&amp;user_ID='.$user_ID );
		}

		if( $ctrl == 'user' )
		{	// Viewing a specific user:
			$users_sub_entries = array();

			$users_sub_entries['identity'] = array(
								'text' => T_('Identity'),
								'href' => '?ctrl=user&amp;user_tab=identity&amp;user_ID='.$user_ID	);

			if( !empty( $user_ID ) )
			{
				if( $Settings->get('allow_avatars') )
				{
					$users_sub_entries['avatar'] = array(
									'text' => T_('Avatar'),
									'href' => '?ctrl=user&amp;user_tab=avatar&amp;user_ID='.$user_ID );
				}

				if( $user_ID == $current_User->ID || $current_User->check_perm( 'users', 'edit' ) )
				{
					$users_sub_entries['password'] = array(
										'text' => T_('Password'),
										'href' => '?ctrl=user&amp;user_tab=password&amp;user_ID='.$user_ID );
				}

				$users_sub_entries['preferences'] = array(
									'text' => T_('Preferences'),
	 								'href' => '?ctrl=user&amp;user_tab=preferences&amp;user_ID='.$user_ID );
			}

			$users_entries['entries'] = $users_sub_entries;
		}
		else
		{	// Viewing all users:
			// fp> the following submenu needs even further breakdown.
			$users_entries['entries'] = array(
							'users' => array(
								'text' => T_('Users & Groups'),
								'href' => '?ctrl=users'	),
							'usersettings' => array(
								'text' => T_('User settings'),
 								'href' => '?ctrl=usersettings',
 								'entries' => array(
									'usersettings' => array(
										'text' => T_('User latitude'),
 										'href' => '?ctrl=usersettings' ),
									'registration' => array(
										'text' => T_('Registration'),
 										'href' => '?ctrl=registration' ),
									'userfields' => array(
										'text' => T_('User fields'),
										'href' => '?ctrl=userfields' ),
									),
								),
							);
		}

		$AdminUI->add_menu_entries( NULL, array( 'users' => $users_entries ) );

		$perm_options = $current_User->check_perm( 'options', 'view' );
		$perm_spam = $current_User->check_perm( 'spamblacklist', 'view' );
		$perm_slugs = $current_User->check_perm( 'slugs', 'view' );
		if( $perm_options || $perm_spam || $perm_slugs )
		{	// Permission to view tools, antispam or slugs.
			$tools_entries = array( 'tools' => array(
					'text' => T_('Tools'),
					'entries' => array(),
				) );

			if( $perm_options )
			{	// Permission to view settings:
				// FP> This assumes that we don't let regular users access the tools, including plugin tools.
				$tools_entries['tools']['href'] = '?ctrl=crontab';
				$tools_entries['tools']['entries']['cron'] = array(
									'text' => T_('Scheduler'),
									'href' => '?ctrl=crontab' );
				$tools_entries['tools']['entries']['system'] = array(
									'text' => T_('System'),
									'href' => '?ctrl=system' );
			}
			if( $perm_spam )
			{	// Permission to view antispam:
				if( !$perm_options )
				{
					$tools_entries['tools']['href'] = '?ctrl=antispam';
				}
				$tools_entries['tools']['entries']['antispam'] = array(
									'text' => T_('Antispam'),
									'href' => '?ctrl=antispam' );
			}
			if( $perm_slugs )
			{	// Permission to view slugs:
				if( !$perm_options && !$perm_spam )
				{
					$tools_entries['tools']['href'] = '?ctrl=slugs';
				}
				$tools_entries['tools']['entries']['slugs'] = array(
									'text' => T_('Slugs'),
									'href' => '?ctrl=slugs' );
			}
			$AdminUI->add_menu_entries( NULL, $tools_entries );
		}
	}
}

$_core_Module = new _core_Module();


/*
 * $Log: __core.init.php,v $
 */
?>