/*
 * Decompiled with CFR 0.152.
 */
package flex.management;

import flex.management.BaseControlMBean;
import flex.management.MBeanServerLocatorFactory;
import flex.management.ManagementException;
import flex.management.runtime.AdminConsoleDisplayRegistrar;
import flex.messaging.FlexContext;
import java.util.ArrayList;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;

public abstract class BaseControl
implements BaseControlMBean,
MBeanRegistration {
    public static final String DOMAIN_PREFIX = "flex.runtime";
    private static final int MALFORMED_OBJECTNAME = 10400;
    private static final int UNREG_EXCEPTION = 10401;
    private static final int UNREG_NOTFOUND = 10402;
    private static final int REG_EXCEPTION = 10403;
    private static final int REG_ALREADYEXISTS = 10404;
    private static final int REG_NOTCOMPLIANT = 10405;
    private static final int DISABLE_MANAGEMENT = 10426;
    protected Date startTimestamp;
    private BaseControl parent;
    private ObjectName objectName;
    private ObjectName registeredObjectName;
    private MBeanServer server;
    private boolean registered = false;
    private AdminConsoleDisplayRegistrar registrar;

    public abstract String getId();

    public abstract String getType();

    public final ObjectName getParent() {
        return this.parent != null ? this.parent.getObjectName() : null;
    }

    public String getApplicationId() {
        String id2 = null;
        ServletConfig config = FlexContext.getServletConfig();
        if (config != null) {
            id2 = config.getServletContext().getServletContextName();
        }
        return id2 != null ? id2 : "";
    }

    protected void setRegistrar(AdminConsoleDisplayRegistrar registrar) {
        this.registrar = registrar;
    }

    public AdminConsoleDisplayRegistrar getRegistrar() {
        if (this.parent == null && this.registrar == null) {
            return new AdminConsoleDisplayRegistrar(null);
        }
        return this.registrar != null ? this.registrar : this.parent.getRegistrar();
    }

    public BaseControl(BaseControl parent) {
        this.parent = parent;
    }

    public final BaseControl getParentControl() {
        return this.parent;
    }

    public final MBeanServer getMBeanServer() {
        return this.server;
    }

    public final void register() {
        if (!this.registered) {
            MBeanServer server = MBeanServerLocatorFactory.getMBeanServerLocator().getMBeanServer();
            ObjectName name = this.getObjectName();
            try {
                if (server.isRegistered(name)) {
                    server.unregisterMBean(name);
                }
                this.registeredObjectName = server.registerMBean(this, name).getObjectName();
                this.registered = true;
                this.onRegistrationComplete();
            }
            catch (ManagementException me2) {
                throw me2;
            }
            catch (MBeanRegistrationException mre) {
                ManagementException me3 = new ManagementException();
                me3.setMessage(10403, new Object[]{name.toString()});
                me3.setRootCause(mre);
                throw me3;
            }
            catch (InstanceAlreadyExistsException iaee) {
                if (!server.isRegistered(name)) {
                    ManagementException me4 = new ManagementException();
                    me4.setMessage(10426, new Object[]{name.toString()});
                    throw me4;
                }
                ManagementException me5 = new ManagementException();
                me5.setMessage(10404, new Object[]{name.toString()});
                throw me5;
            }
            catch (NotCompliantMBeanException ncme) {
                ManagementException me6 = new ManagementException();
                me6.setMessage(10405, new Object[]{name.toString()});
                throw me6;
            }
            catch (InstanceNotFoundException infe) {
                ManagementException me7 = new ManagementException();
                me7.setMessage(10402, new Object[]{name.toString()});
                throw me7;
            }
        }
    }

    protected void onRegistrationComplete() {
    }

    public final void unregister() {
        if (this.registered) {
            try {
                if (this.server.isRegistered(this.registeredObjectName)) {
                    this.server.unregisterMBean(this.registeredObjectName);
                }
                this.registeredObjectName = null;
                this.registered = false;
            }
            catch (ManagementException me2) {
                throw me2;
            }
            catch (MBeanRegistrationException mre) {
                ManagementException me3 = new ManagementException();
                me3.setMessage(10401, new Object[]{this.registeredObjectName.toString()});
                if (me3.getMessage().indexOf(Integer.toString(10401)) != -1) {
                    me3.setMessage("The MBean named, '" + this.registeredObjectName.toString() + "', could not be unregistered because its preDeregister() method threw an exception.");
                }
                me3.setRootCause(mre);
                throw me3;
            }
            catch (InstanceNotFoundException infe) {
                ManagementException me4 = new ManagementException();
                me4.setMessage(10402, new Object[]{this.registeredObjectName.toString()});
                if (me4.getMessage().indexOf(Integer.toString(10402)) != -1) {
                    me4.setMessage("The MBean named, '" + this.registeredObjectName.toString() + "', could not be unregistered because it is not currently registered.");
                }
                throw me4;
            }
        }
    }

    public final ObjectName getObjectName() {
        if (this.registered) {
            return this.registeredObjectName;
        }
        if (this.objectName == null) {
            int i10;
            StringBuffer buffer = new StringBuffer();
            buffer.append(DOMAIN_PREFIX);
            String appId = this.getApplicationId();
            if (appId != null && appId.length() > 0) {
                buffer.append('.');
                buffer.append(appId);
            }
            buffer.append(":type=");
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> ids = new ArrayList<String>();
            types.add(this.getType());
            ids.add(this.getId());
            for (BaseControl ancestor = this.parent; ancestor != null; ancestor = ancestor.getParentControl()) {
                types.add(ancestor.getType());
                ids.add(ancestor.getId());
            }
            for (i10 = types.size() - 1; i10 >= 0; --i10) {
                buffer.append((String)types.get(i10));
                if (i10 <= 0) continue;
                buffer.append('.');
            }
            buffer.append(',');
            for (i10 = ids.size() - 1; i10 >= 1; --i10) {
                buffer.append((String)types.get(i10));
                buffer.append('=');
                buffer.append((String)ids.get(i10));
                buffer.append(',');
            }
            buffer.append("id=");
            buffer.append(this.getId());
            String name = buffer.toString();
            try {
                this.objectName = new ObjectName(name);
            }
            catch (MalformedObjectNameException mone) {
                ManagementException me2 = new ManagementException();
                me2.setMessage(10400, new Object[]{name});
                throw me2;
            }
        }
        return this.objectName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name == null ? this.getObjectName() : name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void setStartTimestamp(Date value) {
        this.startTimestamp = value;
    }

    protected double differenceInMinutes(long startTime, long endTime) {
        double minutes = (double)(endTime - startTime) / 60000.0;
        if (minutes > 1.0) {
            return minutes;
        }
        return 1.0;
    }
}

