/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionListener;
import flex.messaging.MessageClient;
import flex.messaging.client.EndpointPushHandler;
import flex.messaging.client.FlexClient;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.UUIDUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPushNotifier
extends TimeoutAbstractObject
implements EndpointPushHandler,
FlexSessionListener {
    public final Object pushNeeded = new Object();
    private volatile boolean closed;
    private volatile boolean closing;
    private int idleTimeoutMinutes;
    private final Endpoint endpoint;
    private final FlexClient flexClient;
    private final FlexSession flexSession;
    private final Object lock = new Object();
    private String logCategory = "Endpoint.General";
    private List<AsyncMessage> messages;
    private final String notifierId = UUIDUtils.createUUID(false);

    public EndpointPushNotifier(Endpoint endpoint, FlexClient flexClient) {
        this.endpoint = endpoint;
        this.flexClient = flexClient;
        flexClient.registerEndpointPushHandler(this, endpoint.getId());
        this.flexSession = FlexContext.getFlexSession();
        if (this.flexSession != null) {
            this.flexSession.addSessionDestroyedListener(this);
        }
        this.updateLastUse();
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean disconnectChannel) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.closing) {
                return;
            }
            this.closing = true;
        }
        this.cancelTimeout();
        if (this.flexSession != null) {
            this.flexSession.removeSessionDestroyedListener(this);
        }
        this.flexClient.unregisterEndpointPushHandler(this, this.endpoint.getId());
        if (disconnectChannel) {
            ArrayList<CommandMessage> list = new ArrayList<CommandMessage>(1);
            CommandMessage disconnect = new CommandMessage(12);
            list.add(disconnect);
            this.pushMessages(list);
        }
        object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.closing = false;
        }
        object = this.pushNeeded;
        synchronized (object) {
            this.pushNeeded.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncMessage> drainMessages() {
        Object object = this.pushNeeded;
        synchronized (object) {
            List<AsyncMessage> messagesToPush = this.messages;
            this.messages = null;
            return messagesToPush;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    public String getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(String logCategory) {
        this.logCategory = logCategory;
    }

    public String getNotifierId() {
        return this.notifierId;
    }

    @Override
    public long getTimeoutPeriod() {
        return this.idleTimeoutMinutes * 60 * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessages(List messagesToPush) {
        if (!messagesToPush.isEmpty()) {
            Object object = this.pushNeeded;
            synchronized (object) {
                if (this.messages == null) {
                    this.messages = messagesToPush;
                } else {
                    this.messages.addAll(messagesToPush);
                }
                if (!this.closing) {
                    this.pushNeeded.notifyAll();
                }
            }
        }
    }

    @Override
    public void registerMessageClient(MessageClient messageClient) {
    }

    @Override
    public void sessionCreated(FlexSession flexSession) {
    }

    @Override
    public void sessionDestroyed(FlexSession flexSession) {
        if (Log.isInfo()) {
            Log.getLogger(this.logCategory).info("Endpoint with id '" + this.endpoint.getId() + "' is closing" + " a streaming connection for the FlexClient with id '" + this.flexClient.getId() + "'" + " since its associated session has been destroyed.");
        }
        this.close(true);
    }

    @Override
    public void timeout() {
        if (Log.isInfo()) {
            Log.getLogger(this.logCategory).info("Endpoint with id '" + this.endpoint.getId() + "' is timing out" + " a streaming connection for the FlexClient with id '" + this.flexClient.getId() + "'");
        }
        this.close(true);
    }

    @Override
    public void unregisterMessageClient(MessageClient messageClient) {
    }
}

