/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientConfiguration
implements ServicesConfiguration {
    protected final Map channelSettings = new HashMap();
    protected final List defaultChannels = new ArrayList(4);
    protected final List serviceSettings;
    protected LoggingSettings loggingSettings;
    protected Map configPaths;
    protected final Map clusterSettings = new HashMap();
    protected FlexClientSettings flexClientSettings;

    public ClientConfiguration() {
        this.serviceSettings = new ArrayList();
        this.configPaths = new HashMap();
    }

    public void addChannelSettings(String id2, ChannelSettings settings) {
        this.channelSettings.put(id2, settings);
    }

    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void addDefaultChannel(String id2) {
        this.defaultChannels.add(id2);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    public ServiceSettings getServiceSettings(String serviceType) {
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            if (!serviceSettings.getId().equals(serviceType)) continue;
            return serviceSettings;
        }
        return null;
    }

    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            for (ClusterSettings cs2 : this.clusterSettings.values()) {
                if (!cs2.isDefault()) continue;
                ConfigurationException cx2 = new ConfigurationException();
                cx2.setMessage(10214, new Object[]{settings.getClusterName(), cs2.getClusterName()});
                throw cx2;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx3 = new ConfigurationException();
            cx3.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx3;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    public ClusterSettings getClusterSettings(String clusterId) {
        for (ClusterSettings cs2 : this.clusterSettings.values()) {
            if (cs2.getClusterName() == clusterId) {
                return cs2;
            }
            if (cs2.getClusterName() == null || !cs2.getClusterName().equals(clusterId)) continue;
            return cs2;
        }
        return null;
    }

    public ClusterSettings getDefaultCluster() {
        for (ClusterSettings cs2 : this.clusterSettings.values()) {
            if (!cs2.isDefault()) continue;
            return cs2;
        }
        return null;
    }

    public void setLoggingSettings(LoggingSettings settings) {
        this.loggingSettings = settings;
    }

    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void addConfigPath(String path, long modified) {
        this.configPaths.put(path, new Long(modified));
    }

    public Map getConfigPaths() {
        return this.configPaths;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }
}

