/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AbstractConfigurationParser;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClientConfiguration;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LocalFileResolver;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.TokenReplacer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ClientConfigurationParser
extends AbstractConfigurationParser {
    protected void parseTopLevelConfig(Document doc2) {
        Node root = this.selectSingleNode(doc2, "/services-config");
        if (root != null) {
            this.allowedChildElements(root, SERVICES_CONFIG_CHILDREN);
            this.channelsSection(root);
            this.services(root);
            this.clusters(root);
            this.flexClient(root);
        }
    }

    private void channelsSection(Node root) {
        Node channelsNode = this.selectSingleNode(root, "channels");
        if (channelsNode != null) {
            this.allowedAttributesOrElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int i10 = 0; i10 < channels.getLength(); ++i10) {
                Node channel = channels.item(i10);
                this.channelDefinition(channel);
            }
        }
    }

    private void channelDefinition(Node channel) {
        this.requiredAttributesOrElements(channel, CHANNEL_DEFINITION_REQ_CHILDREN);
        this.allowedAttributesOrElements(channel, CHANNEL_DEFINITION_CHILDREN);
        String id2 = this.getAttributeOrChildElement(channel, "id").trim();
        if (ClientConfigurationParser.isValidID(id2)) {
            String enableSmallMessages;
            ConfigMap map;
            ConfigMap serialization;
            boolean serverOnly;
            if (this.config.getChannelSettings(id2) != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(11127, new Object[]{id2});
                throw e10;
            }
            ChannelSettings channelSettings = new ChannelSettings(id2);
            String clientType = this.getAttributeOrChildElement(channel, "class");
            clientType = clientType.length() > 0 ? clientType : null;
            String serverOnlyString = this.getAttributeOrChildElement(channel, "server-only");
            boolean bl2 = serverOnly = serverOnlyString.length() > 0 && Boolean.valueOf(serverOnlyString) != false;
            if (clientType == null && !serverOnly) {
                ConfigurationException ce2 = new ConfigurationException();
                ce2.setMessage(11139, new Object[]{id2});
                throw ce2;
            }
            if (clientType != null && serverOnly) {
                ConfigurationException ce3 = new ConfigurationException();
                ce3.setMessage(11140, new Object[]{id2});
                throw ce3;
            }
            if (serverOnly) {
                return;
            }
            channelSettings.setClientType(clientType);
            Node endpoint = this.selectSingleNode(channel, "endpoint");
            if (endpoint != null) {
                this.allowedAttributesOrElements(endpoint, ENDPOINT_CHILDREN);
                String uri = this.getAttributeOrChildElement(endpoint, "url");
                if (uri == null || "".equals(uri)) {
                    uri = this.getAttributeOrChildElement(endpoint, "uri");
                }
                channelSettings.setUri(uri);
                this.config.addChannelSettings(id2, channelSettings);
            }
            this.addProperty(channel, channelSettings, "polling-enabled");
            this.addProperty(channel, channelSettings, "polling-interval-millis");
            this.addProperty(channel, channelSettings, "piggybacking-enabled");
            this.addProperty(channel, channelSettings, "login-after-disconnect");
            this.addProperty(channel, channelSettings, "record-message-sizes");
            this.addProperty(channel, channelSettings, "record-message-times");
            this.addProperty(channel, channelSettings, "connect-timeout-seconds");
            this.addProperty(channel, channelSettings, "polling-interval-seconds");
            this.addProperty(channel, channelSettings, "client-load-balancing");
            this.addProperty(channel, channelSettings, "request-timeout-seconds");
            NodeList properties = this.selectNodeList(channel, "properties/serialization");
            if (properties.getLength() > 0 && (serialization = (map = this.properties(properties, this.getSourceFileOf(channel))).getPropertyAsMap("serialization", null)) != null && (enableSmallMessages = serialization.getProperty("enable-small-messages")) != null) {
                ConfigMap clientMap = new ConfigMap();
                clientMap.addProperty("enable-small-messages", enableSmallMessages);
                channelSettings.addProperty("serialization", clientMap);
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10110, new Object[]{"channel-definition", id2});
            String details = "An id must be non-empty and not contain any list delimiter characters, i.e. commas, semi-colons or colons.";
            ex2.setDetails(details);
            throw ex2;
        }
    }

    private void addProperty(Node channel, ChannelSettings channelSettings, String property) {
        NodeList properties = this.selectNodeList(channel, "properties/" + property);
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(channel));
            if ("client-load-balancing".equals(property)) {
                ConfigMap clientLoadBalancingMap = map.getPropertyAsMap("client-load-balancing", null);
                if (clientLoadBalancingMap == null) {
                    ConfigurationException ce2 = new ConfigurationException();
                    ce2.setMessage(11141, new Object[]{"client-load-balancing", channelSettings.getId()});
                    throw ce2;
                }
                List urls = clientLoadBalancingMap.getPropertyAsList("url", null);
                this.addClientLoadBalancingUrls(urls, channelSettings.getId());
            }
            channelSettings.addProperties(map);
        }
    }

    private void addClientLoadBalancingUrls(List urls, String endpointId) {
        if (urls == null || urls.isEmpty()) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(11141, new Object[]{"client-load-balancing", endpointId});
            throw ce2;
        }
        HashSet<String> clientLoadBalancingUrls = new HashSet<String>();
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            String url = (String)iterator.next();
            if (url == null || url.length() == 0) {
                ConfigurationException ce3 = new ConfigurationException();
                ce3.setMessage(11142, new Object[]{"client-load-balancing", endpointId});
                throw ce3;
            }
            if (TokenReplacer.containsTokens(url)) {
                ConfigurationException ce4 = new ConfigurationException();
                ce4.setMessage(11147, new Object[]{"client-load-balancing", endpointId});
                throw ce4;
            }
            if (clientLoadBalancingUrls.contains(url)) {
                iterator.remove();
                continue;
            }
            clientLoadBalancingUrls.add(url);
        }
    }

    private void services(Node root) {
        Node servicesNode = this.selectSingleNode(root, "services");
        if (servicesNode != null) {
            Node service;
            int i10;
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            Node defaultChannels = this.selectSingleNode(servicesNode, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan);
                }
            }
            NodeList services = this.selectNodeList(servicesNode, "service-include");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.serviceInclude(service);
            }
            services = this.selectNodeList(servicesNode, "service");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.service(service);
            }
        }
    }

    private void clusters(Node root) {
        Node clusteringNode = this.selectSingleNode(root, "clusters");
        if (clusteringNode != null) {
            this.allowedAttributesOrElements(clusteringNode, CLUSTERING_CHILDREN);
            NodeList clusters = this.selectNodeList(clusteringNode, "cluster");
            for (int i10 = 0; i10 < clusters.getLength(); ++i10) {
                String ulb2;
                Node cluster = clusters.item(i10);
                this.requiredAttributesOrElements(cluster, CLUSTER_DEFINITION_CHILDREN);
                String clusterName = this.getAttributeOrChildElement(cluster, "id");
                if (!ClientConfigurationParser.isValidID(clusterName)) continue;
                String propsFileName = this.getAttributeOrChildElement(cluster, "properties");
                ClusterSettings clusterSettings = new ClusterSettings();
                clusterSettings.setClusterName(clusterName);
                clusterSettings.setPropsFileName(propsFileName);
                String defaultValue = this.getAttributeOrChildElement(cluster, "default");
                if (defaultValue != null && defaultValue.length() > 0) {
                    if (defaultValue.equalsIgnoreCase("true")) {
                        clusterSettings.setDefault(true);
                    } else if (!defaultValue.equalsIgnoreCase("false")) {
                        ConfigurationException e10 = new ConfigurationException();
                        e10.setMessage(10215, new Object[]{clusterName, defaultValue});
                        throw e10;
                    }
                }
                if ((ulb2 = this.getAttributeOrChildElement(cluster, "url-load-balancing")) != null && ulb2.length() > 0) {
                    if (ulb2.equalsIgnoreCase("false")) {
                        clusterSettings.setURLLoadBalancing(false);
                    } else if (!ulb2.equalsIgnoreCase("true")) {
                        ConfigurationException e11 = new ConfigurationException();
                        e11.setMessage(10216, new Object[]{clusterName, ulb2});
                        throw e11;
                    }
                }
                ((ClientConfiguration)this.config).addClusterSettings(clusterSettings);
            }
        }
    }

    private void serviceInclude(Node serviceInclude) {
        this.requiredAttributesOrElements(serviceInclude, SERVICE_INCLUDE_CHILDREN);
        String src2 = this.getAttributeOrChildElement(serviceInclude, "file-path");
        if (src2.length() > 0) {
            Document doc2 = this.loadDocument(src2, this.fileResolver.getIncludedFile(src2));
            if (this.fileResolver instanceof LocalFileResolver) {
                LocalFileResolver local = (LocalFileResolver)this.fileResolver;
                ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src2), local.getIncludedLastModified(src2));
            }
            doc2.getDocumentElement().normalize();
            Node service = this.selectSingleNode(doc2, "/service");
            if (service != null) {
                this.service(service);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10112, new Object[]{"service"});
                throw ex2;
            }
        }
    }

    private void service(Node service) {
        this.requiredAttributesOrElements(service, SERVICE_REQ_CHILDREN);
        this.allowedAttributesOrElements(service, SERVICE_CHILDREN);
        String id2 = this.getAttributeOrChildElement(service, "id");
        if (ClientConfigurationParser.isValidID(id2)) {
            Node dest;
            int i10;
            ServiceSettings serviceSettings = this.config.getServiceSettings(id2);
            if (serviceSettings == null) {
                serviceSettings = new ServiceSettings(id2);
                NodeList properties = this.selectNodeList(service, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(service));
                    serviceSettings.addProperties(map);
                }
            } else {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10113, new Object[]{id2});
                throw e10;
            }
            this.config.addServiceSettings(serviceSettings);
            String className = this.getAttributeOrChildElement(service, "class");
            if (className.length() <= 0) {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10114, new Object[]{"service", id2});
                throw ex2;
            }
            serviceSettings.setClassName(className);
            Node defaultChannels = this.selectSingleNode(service, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan, serviceSettings);
                }
            } else if (this.config.getDefaultChannels().size() > 0) {
                for (String channelId : this.config.getDefaultChannels()) {
                    ChannelSettings channel = this.config.getChannelSettings(channelId);
                    serviceSettings.addDefaultChannel(channel);
                }
            }
            NodeList list = this.selectNodeList(service, "destination");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destination(dest, serviceSettings);
            }
            list = this.selectNodeList(service, "destination-include");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destinationInclude(dest, serviceSettings);
            }
        } else {
            ConfigurationException ex3 = new ConfigurationException();
            ex3.setMessage(10110, new Object[]{"service", id2});
            throw ex3;
        }
    }

    private void defaultChannel(Node chan) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{"MessageBroker"});
            throw ex2;
        }
        this.config.addDefaultChannel(channel.getId());
    }

    private void defaultChannel(Node chan, ServiceSettings serviceSettings) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{serviceSettings.getId()});
            throw ex2;
        }
        serviceSettings.addDefaultChannel(channel);
    }

    private void destinationInclude(Node destInclude, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(destInclude, DESTINATION_INCLUDE_CHILDREN);
        String src2 = this.getAttributeOrChildElement(destInclude, "file-path");
        if (src2.length() > 0) {
            Document doc2 = this.loadDocument(src2, this.fileResolver.getIncludedFile(src2));
            if (this.fileResolver instanceof LocalFileResolver) {
                LocalFileResolver local = (LocalFileResolver)this.fileResolver;
                ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src2), local.getIncludedLastModified(src2));
            }
            doc2.getDocumentElement().normalize();
            Node destinationsNode = this.selectSingleNode(doc2, "destinations");
            if (destinationsNode != null) {
                this.allowedChildElements(destinationsNode, DESTINATIONS_CHILDREN);
                NodeList destinations = this.selectNodeList(destinationsNode, "destination");
                for (int a10 = 0; a10 < destinations.getLength(); ++a10) {
                    Node dest = destinations.item(a10);
                    this.destination(dest, serviceSettings);
                }
                this.fileResolver.popIncludedFile();
            } else {
                Node dest = this.selectSingleNode(doc2, "/destination");
                if (dest != null) {
                    this.destination(dest, serviceSettings);
                    this.fileResolver.popIncludedFile();
                } else {
                    ConfigurationException ex2 = new ConfigurationException();
                    ex2.setMessage(10118, new Object[]{"destinations", "destination"});
                    throw ex2;
                }
            }
        }
    }

    private void destination(Node dest, ServiceSettings serviceSettings) {
        DestinationSettings destinationSettings;
        this.requiredAttributesOrElements(dest, DESTINATION_REQ_CHILDREN);
        this.allowedAttributes(dest, DESTINATION_ATTR);
        this.allowedChildElements(dest, DESTINATION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id2 = this.getAttributeOrChildElement(dest, "id");
        if (ClientConfigurationParser.isValidID(id2)) {
            destinationSettings = (DestinationSettings)serviceSettings.getDestinationSettings().get(id2);
            if (destinationSettings != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10122, new Object[]{id2, serviceId});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10119, new Object[]{"destination", id2, serviceId});
            throw ex2;
        }
        destinationSettings = new DestinationSettings(id2);
        serviceSettings.addDestinationSettings(destinationSettings);
        NodeList properties = this.selectNodeList(dest, "properties/*");
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(dest));
            destinationSettings.addProperties(map);
        }
        this.destinationChannels(dest, destinationSettings, serviceSettings);
    }

    private void destinationChannels(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String channelsList = this.evaluateExpression(dest, "@channels").toString().trim();
        if (channelsList.length() > 0) {
            StringTokenizer st2 = new StringTokenizer(channelsList, ",;:");
            while (st2.hasMoreTokens()) {
                String ref = st2.nextToken().trim();
                ChannelSettings channel = this.config.getChannelSettings(ref);
                if (channel != null) {
                    destinationSettings.addChannelSettings(channel);
                    continue;
                }
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10120, new Object[]{"channel", ref, destId});
                throw ex2;
            }
        } else {
            Node channelsNode = this.selectSingleNode(dest, "channels");
            if (channelsNode != null) {
                this.allowedChildElements(channelsNode, DESTINATION_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(channelsNode, "channel");
                if (channels.getLength() > 0) {
                    for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                        ChannelSettings channel;
                        Node chan = channels.item(c10);
                        this.requiredAttributesOrElements(chan, DESTINATION_CHANNEL_REQ_CHILDREN);
                        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
                        if (ref.length() > 0) {
                            channel = this.config.getChannelSettings(ref);
                            if (channel == null) {
                                ConfigurationException ex3 = new ConfigurationException();
                                ex3.setMessage(10120, new Object[]{"channel", ref, destId});
                                throw ex3;
                            }
                        } else {
                            ConfigurationException ex4 = new ConfigurationException();
                            ex4.setMessage(10121, new Object[]{"channel", ref, destId});
                            throw ex4;
                        }
                        destinationSettings.addChannelSettings(channel);
                    }
                }
            } else {
                List defaultChannels = serviceSettings.getDefaultChannels();
                for (ChannelSettings channel : defaultChannels) {
                    destinationSettings.addChannelSettings(channel);
                }
            }
        }
        if (destinationSettings.getChannelSettings().size() <= 0) {
            ConfigurationException ex5 = new ConfigurationException();
            ex5.setMessage(10123, new Object[]{destId});
            throw ex5;
        }
    }

    private void flexClient(Node root) {
        Node flexClient = this.selectSingleNode(root, "flex-client");
        if (flexClient != null) {
            FlexClientSettings flexClientSettings = new FlexClientSettings();
            String reliableReconnectDurationMillis = this.getAttributeOrChildElement(flexClient, "reliable-reconnect-duration-millis");
            if (reliableReconnectDurationMillis.length() > 0) {
                try {
                    int millis = Integer.parseInt(reliableReconnectDurationMillis);
                    if (millis < 0) {
                        ConfigurationException e10 = new ConfigurationException();
                        e10.setMessage(11137, new Object[]{reliableReconnectDurationMillis});
                        throw e10;
                    }
                    flexClientSettings.setReliableReconnectDurationMillis(millis);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e11 = new ConfigurationException();
                    e11.setMessage(11137, new Object[]{reliableReconnectDurationMillis});
                    throw e11;
                }
            } else {
                flexClientSettings.setReliableReconnectDurationMillis(0);
            }
            String heartbeatIntervalMillis = this.getAttributeOrChildElement(flexClient, "heartbeat-interval-millis");
            if (heartbeatIntervalMillis.length() > 0) {
                try {
                    int millis = Integer.parseInt(heartbeatIntervalMillis);
                    if (millis < 0) {
                        ConfigurationException e12 = new ConfigurationException();
                        e12.setMessage(11146, new Object[]{heartbeatIntervalMillis});
                        throw e12;
                    }
                    flexClientSettings.setHeartbeatIntervalMillis(millis);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e13 = new ConfigurationException();
                    e13.setMessage(11146, new Object[]{heartbeatIntervalMillis});
                    throw e13;
                }
            }
            ((ClientConfiguration)this.config).setFlexClientSettings(flexClientSettings);
        }
    }
}

