/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.AMFEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BasePollingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.LegacyFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;

public class AMFEndpoint
extends BasePollingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.AMF";

    public AMFEndpoint() {
        this(false);
    }

    public AMFEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = new SessionFilter();
        LegacyFilter envelopeFilter = new LegacyFilter(this);
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        batchFilter.setNext(sessionFilter);
        sessionFilter.setNext(envelopeFilter);
        envelopeFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    protected String getResponseContentType() {
        return "application/x-amf";
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected String getDeserializerClassName() {
        return "flex.messaging.io.amf.AmfMessageDeserializer";
    }

    protected String getSerializerClassName() {
        return "flex.messaging.io.amf.AmfMessageSerializer";
    }

    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new AMFEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }
}

