/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.UnknownTypeException;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class Amf3Input
extends AbstractAmfInput
implements Amf3Types {
    protected List objectTable;
    protected List stringTable = new ArrayList(64);
    protected List traitsTable;

    public Amf3Input(SerializationContext context) {
        super(context);
        this.objectTable = new ArrayList(64);
        this.traitsTable = new ArrayList(10);
    }

    public void reset() {
        super.reset();
        this.stringTable.clear();
        this.objectTable.clear();
        this.traitsTable.clear();
    }

    public Object saveObjectTable() {
        List table = this.objectTable;
        this.objectTable = new ArrayList(64);
        return table;
    }

    public void restoreObjectTable(Object table) {
        this.objectTable = (ArrayList)table;
    }

    public Object saveTraitsTable() {
        List table = this.traitsTable;
        this.traitsTable = new ArrayList(10);
        return table;
    }

    public void restoreTraitsTable(Object table) {
        this.traitsTable = (ArrayList)table;
    }

    public Object saveStringTable() {
        List table = this.stringTable;
        this.stringTable = new ArrayList(64);
        return table;
    }

    public void restoreStringTable(Object table) {
        this.stringTable = (ArrayList)table;
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        byte type = this.in.readByte();
        Object value = this.readObjectValue(type);
        return value;
    }

    protected Object readObjectValue(int type) throws ClassNotFoundException, IOException {
        Object value = null;
        switch (type) {
            case 6: {
                ClassUtil.validateCreation(String.class);
                value = this.readString();
                if (!this.isDebug) break;
                this.trace.writeString((String)value);
                break;
            }
            case 10: {
                value = this.readScriptObject();
                break;
            }
            case 9: {
                value = this.readArray();
                break;
            }
            case 2: {
                ClassUtil.validateCreation(Boolean.class);
                value = Boolean.FALSE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 3: {
                ClassUtil.validateCreation(Boolean.class);
                value = Boolean.TRUE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 4: {
                ClassUtil.validateCreation(Integer.class);
                int i10 = this.readUInt29();
                i10 = i10 << 3 >> 3;
                value = new Integer(i10);
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 5: {
                value = this.readDouble();
                break;
            }
            case 0: {
                if (!this.isDebug) break;
                this.trace.writeUndefined();
                break;
            }
            case 1: {
                if (!this.isDebug) break;
                this.trace.writeNull();
                break;
            }
            case 7: 
            case 11: {
                value = this.readXml();
                break;
            }
            case 8: {
                value = this.readDate();
                break;
            }
            case 12: {
                value = this.readByteArray();
                break;
            }
            default: {
                UnknownTypeException ex2 = new UnknownTypeException();
                ex2.setMessage(10301, new Object[]{new Integer(type)});
                throw ex2;
            }
        }
        return value;
    }

    public double readDouble() throws IOException {
        ClassUtil.validateCreation(Double.class);
        double d10 = super.readDouble();
        if (this.isDebug) {
            this.trace.write(d10);
        }
        return d10;
    }

    protected String readString() throws IOException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getStringReference(ref >> 1);
        }
        int len = ref >> 1;
        if (0 == len) {
            return "";
        }
        String str = this.readUTF(len);
        this.stringTable.add(str);
        return str;
    }

    protected Date readDate() throws IOException {
        ClassUtil.validateCreation(Date.class);
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (Date)this.getObjectReference(ref >> 1);
        }
        long time = (long)this.in.readDouble();
        Date d10 = new Date(time);
        this.objectTable.add(d10);
        if (this.isDebug) {
            this.trace.write(d10);
        }
        return d10;
    }

    protected Object readArray() throws ClassNotFoundException, IOException {
        String name;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        Object array = null;
        Object[] map = null;
        while ((name = this.readString()) != null && name.length() != 0) {
            if (map == null) {
                array = map = (Object[])ClassUtil.createDefaultInstance(HashMap.class, null, true);
                this.objectTable.add(array);
                if (this.isDebug) {
                    this.trace.startECMAArray(this.objectTable.size() - 1);
                }
            }
            if (this.isDebug) {
                this.trace.namedElement(name);
            }
            Object value = this.readObjectOneLevelDown(true);
            ClassUtil.validateAssignment((Object)map, name, value);
            map.put(name, value);
        }
        if (map == null) {
            boolean useListTemporarily = false;
            if (this.context.legacyCollection || len > 1024) {
                useListTemporarily = !this.context.legacyCollection;
                ClassUtil.validateCreation(ArrayList.class);
                int initialCapacity = len < 1024 ? len : 1024;
                array = new ArrayList(initialCapacity);
            } else {
                ClassUtil.validateCreation(Object[].class);
                array = new Object[len];
            }
            int objectId = this.rememberObject(array);
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            for (int i10 = 0; i10 < len; ++i10) {
                if (this.isDebug) {
                    this.trace.arrayElement(i10);
                }
                Object item = this.readObjectOneLevelDown(true);
                ClassUtil.validateAssignment(array, i10, item);
                if (array instanceof ArrayList) {
                    ((ArrayList)array).add(item);
                    continue;
                }
                Array.set(array, i10, item);
            }
            if (useListTemporarily) {
                array = ((ArrayList)array).toArray();
                this.objectTable.set(objectId, array);
            }
        } else {
            for (int i11 = 0; i11 < len; ++i11) {
                if (this.isDebug) {
                    this.trace.arrayElement(i11);
                }
                Object item = this.readObjectOneLevelDown(true);
                String key = Integer.toString(i11);
                ClassUtil.validateAssignment((Object)map, key, item);
                map.put(key, item);
            }
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        return array;
    }

    protected Object readScriptObject() throws ClassNotFoundException, IOException {
        Object newObj;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        TraitsInfo ti2 = this.readTraits(ref);
        String className = ti2.getClassName();
        boolean externalizable = ti2.isExternalizable();
        Object[] params = new Object[]{className, null};
        Object object = this.createObjectInstance(params);
        className = (String)params[0];
        PropertyProxy proxy = (PropertyProxy)params[1];
        int objectId = this.rememberObject(object);
        if (object instanceof Externalizable) {
            this.readExternalizable(className, object);
        } else {
            if (this.isDebug) {
                this.trace.startAMFObject(className, this.objectTable.size() - 1);
            }
            boolean isCollectionClass = Amf3Input.isCollectionClass(object);
            int len = ti2.getProperties().size();
            for (int i10 = 0; i10 < len; ++i10) {
                String propName = ti2.getProperty(i10);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                Object value = this.readObjectOneLevelDown(isCollectionClass);
                proxy.setValue(object, propName, value);
            }
            if (ti2.isDynamic()) {
                String name;
                while ((name = this.readString()) != null && name.length() != 0) {
                    if (this.isDebug) {
                        this.trace.namedElement(name);
                    }
                    Object value = this.readObjectOneLevelDown(isCollectionClass);
                    proxy.setValue(object, name, value);
                }
            }
        }
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
        if ((newObj = proxy.instanceComplete(object)) != object) {
            this.objectTable.set(objectId, newObj);
            object = newObj;
        }
        return object;
    }

    protected void readExternalizable(String className, Object object) throws ClassNotFoundException, IOException {
        if (object instanceof Externalizable) {
            ClassUtil.validateCreation(Externalizable.class);
            if (this.isDebug) {
                this.trace.startExternalizableObject(className, this.objectTable.size() - 1);
            }
        } else {
            SerializationException ex2 = new SerializationException();
            ex2.setMessage(10305, new Object[]{object.getClass().getName()});
            throw ex2;
        }
        ((Externalizable)object).readExternal(this);
    }

    protected byte[] readByteArray() throws IOException {
        ClassUtil.validateCreation(byte[].class);
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (byte[])this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        byte[] ba = new byte[len];
        this.objectTable.add(ba);
        this.in.readFully(ba, 0, len);
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, len);
        }
        return ba;
    }

    protected TraitsInfo readTraits(int ref) throws IOException {
        if ((ref & 3) == 1) {
            return this.getTraitReference(ref >> 2);
        }
        boolean externalizable = (ref & 4) == 4;
        boolean dynamic = (ref & 8) == 8;
        int count = ref >> 4;
        String className = this.readString();
        TraitsInfo ti2 = new TraitsInfo(className, dynamic, externalizable, count);
        this.traitsTable.add(ti2);
        for (int i10 = 0; i10 < count; ++i10) {
            String propName = this.readString();
            ti2.addProperty(propName);
        }
        return ti2;
    }

    protected String readUTF(int utflen) throws IOException {
        this.checkUTFLength(utflen);
        char[] charr = this.getTempCharArray(utflen);
        byte[] bytearr = this.getTempByteArray(utflen);
        int count = 0;
        int chCount = 0;
        this.in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c10 = bytearr[count] & 0xFF;
            switch (c10 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    charr[chCount] = (char)c10;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c10 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c10 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
            ++chCount;
        }
        return new String(charr, 0, chCount);
    }

    protected int readUInt29() throws IOException {
        int b10 = this.in.readByte() & 0xFF;
        if (b10 < 128) {
            return b10;
        }
        int value = (b10 & 0x7F) << 7;
        b10 = this.in.readByte() & 0xFF;
        if (b10 < 128) {
            return value | b10;
        }
        value = (value | b10 & 0x7F) << 7;
        b10 = this.in.readByte() & 0xFF;
        if (b10 < 128) {
            return value | b10;
        }
        value = (value | b10 & 0x7F) << 8;
        b10 = this.in.readByte() & 0xFF;
        return value | b10;
    }

    protected Object readXml() throws IOException {
        String xml = null;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            xml = (String)this.getObjectReference(ref >> 1);
        } else {
            int len = ref >> 1;
            xml = 0 == len ? (String)ClassUtil.createDefaultInstance(String.class, null) : this.readUTF(len);
            this.objectTable.add(xml);
            if (this.isDebug) {
                this.trace.write(xml);
            }
        }
        return this.stringToDocument(xml);
    }

    protected Object getObjectReference(int ref) {
        if (this.isDebug) {
            this.trace.writeRef(ref);
        }
        return this.objectTable.get(ref);
    }

    protected String getStringReference(int ref) {
        String str = (String)this.stringTable.get(ref);
        if (Trace.amf && this.isDebug) {
            this.trace.writeStringRef(ref);
        }
        return str;
    }

    protected TraitsInfo getTraitReference(int ref) {
        if (Trace.amf && this.isDebug) {
            this.trace.writeTraitsInfoRef(ref);
        }
        return (TraitsInfo)this.traitsTable.get(ref);
    }

    protected int rememberObject(Object obj) {
        int id2 = this.objectTable.size();
        this.objectTable.add(obj);
        return id2;
    }

    protected Object readObjectOneLevelDown(boolean nestCollectionLevelDown) throws ClassNotFoundException, IOException {
        this.increaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.increaseNestCollectionLevel();
        }
        Object value = this.readObject();
        this.decreaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.decreaseNestCollectionLevel();
        }
        return value;
    }
}

