/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.client;

import flex.messaging.MessageException;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfMessageSerializer;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amf.client.AMFHeaderProcessor;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFConnection {
    public static final String COOKIE = "Cookie";
    public static final String COOKIE2 = "Cookie2";
    public static final String COOKIE_SEPERATOR = ";";
    public static final String COOKIE_NAMEVALUE_SEPERATOR = "=";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    private static int DEFAULT_OBJECT_ENCODING = 3;
    private static String HTTP_HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private ActionContext actionContext;
    private boolean connected;
    private boolean instantiateTypes = true;
    private Proxy proxy;
    private int objectEncoding;
    private boolean objectEncodingSet = false;
    private SerializationContext serializationContext;
    private String url;
    private URL urlObject;
    protected List<MessageHeader> amfHeaders;
    protected AMFHeaderProcessor amfHeaderProcessor;
    protected AmfTrace amfTrace;
    protected Map<String, String> cookies;
    protected Map<String, String> httpRequestHeaders;
    protected int responseCounter;
    protected HttpURLConnection urlConnection;
    protected BufferedInputStream urlConnectionInputStream;

    public static void registerAlias(String alias, String className) {
        ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
        registry.registerAlias(alias, className);
        registry.registerAlias(className, alias);
    }

    public AMFHeaderProcessor getAMFHeaderProcessor() {
        return this.amfHeaderProcessor;
    }

    public void setAMFHeaderProcessor(AMFHeaderProcessor amfHeaderProcessor) {
        this.amfHeaderProcessor = amfHeaderProcessor;
    }

    public AmfTrace getAmfTrace() {
        return this.amfTrace;
    }

    public void setAmfTrace(AmfTrace amfTrace) {
        this.amfTrace = amfTrace;
    }

    public static int getDefaultObjectEncoding() {
        return DEFAULT_OBJECT_ENCODING;
    }

    public static void setDefaultObjectEncoding(int value) {
        DEFAULT_OBJECT_ENCODING = value;
    }

    public boolean isInstantiateTypes() {
        return this.instantiateTypes;
    }

    public void setInstantiateTypes(boolean instantiateTypes) {
        this.instantiateTypes = instantiateTypes;
    }

    public int getObjectEncoding() {
        if (!this.objectEncodingSet) {
            return AMFConnection.getDefaultObjectEncoding();
        }
        return this.objectEncoding;
    }

    public void setObjectEncoding(int objectEncoding) {
        this.objectEncoding = objectEncoding;
        this.objectEncodingSet = true;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getUrl() {
        return this.url;
    }

    public void addAmfHeader(String name, boolean mustUnderstand, Object data) {
        if (this.amfHeaders == null) {
            this.amfHeaders = new ArrayList<MessageHeader>();
        }
        MessageHeader header = new MessageHeader(name, mustUnderstand, data);
        this.amfHeaders.add(header);
    }

    public void addAmfHeader(String name, Object data) {
        this.addAmfHeader(name, false, data);
    }

    public boolean removeAmfHeader(String name) {
        boolean exists = false;
        if (this.amfHeaders != null) {
            Iterator<MessageHeader> iterator = this.amfHeaders.iterator();
            while (iterator.hasNext()) {
                MessageHeader header = iterator.next();
                if (!name.equals(header.getName())) continue;
                iterator.remove();
                exists = true;
            }
        }
        return exists;
    }

    public void removeAllAmfHeaders() {
        if (this.amfHeaders != null) {
            this.amfHeaders = null;
        }
    }

    public void addHttpRequestHeader(String name, String value) {
        if (this.httpRequestHeaders == null) {
            this.httpRequestHeaders = new HashMap<String, String>();
        }
        this.httpRequestHeaders.put(name, value);
    }

    public boolean removeHttpRequestHeader(String name) {
        boolean exists = false;
        if (this.httpRequestHeaders != null) {
            String previousValue = this.httpRequestHeaders.remove(name);
            exists = previousValue != null;
        }
        return exists;
    }

    public void removeAllHttpRequestHeaders() {
        if (this.httpRequestHeaders != null) {
            this.httpRequestHeaders = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String command, Object ... arguments) throws ClientStatusException, ServerStatusException {
        Object object;
        if (!this.connected) {
            String message = "AMF connection is not connected";
            ClientStatusException cse = new ClientStatusException(message, "AMFConnection.Call.Failed");
            throw cse;
        }
        String responseURI = this.getResponseURI();
        ActionMessage requestMessage = new ActionMessage(this.getObjectEncoding());
        if (this.amfHeaders != null) {
            for (MessageHeader header : this.amfHeaders) {
                requestMessage.addHeader(header);
            }
        }
        MessageBody amfMessage = new MessageBody(command, responseURI, arguments);
        requestMessage.addBody(amfMessage);
        this.actionContext.setRequestMessage(requestMessage);
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfMessageSerializer amfMessageSerializer = new AmfMessageSerializer();
        amfMessageSerializer.initialize(this.serializationContext, outBuffer, this.amfTrace);
        try {
            try {
                Object result;
                amfMessageSerializer.writeMessage(requestMessage);
                object = result = this.send(outBuffer);
                Object var11_13 = null;
            }
            catch (Exception e10) {
                if (e10 instanceof ClientStatusException) {
                    throw (ClientStatusException)e10;
                }
                if (!(e10 instanceof ServerStatusException)) throw new ClientStatusException(e10, "AMFConnection.Call.Failed", this.generateHttpResponseInfo());
                throw (ServerStatusException)e10;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                outBuffer.close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return object;
        }
        outBuffer.close();
        return object;
    }

    public void close() {
        if (this.cookies != null) {
            this.cookies.clear();
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
            this.urlConnection = null;
        }
        this.url = null;
        this.urlObject = null;
        this.serializationContext = null;
        this.connected = false;
    }

    public void connect(String connectUrl) throws ClientStatusException {
        if (this.connected) {
            this.close();
        }
        this.url = connectUrl;
        String encodedUrl = null;
        try {
            URL raw = new URL(this.url);
            URI uri = new URI(raw.getProtocol(), raw.getUserInfo(), raw.getHost(), raw.getPort(), raw.getPath(), raw.getQuery(), null);
            encodedUrl = uri.toString();
        }
        catch (Exception e10) {
            // empty catch block
        }
        try {
            this.urlObject = new URL(encodedUrl != null ? encodedUrl : this.url);
            this.serializationContext = new SerializationContext();
            this.serializationContext.createASObjectForMissingType = true;
            this.serializationContext.legacyCollection = true;
            this.serializationContext.legacyMap = true;
            this.internalConnect();
        }
        catch (IOException e11) {
            ClientStatusException exception = new ClientStatusException(e11, "AMFConnection.Connect.Failed");
            throw exception;
        }
    }

    protected HttpResponseInfo generateHttpResponseInfo() {
        HttpResponseInfo httpResponseInfo = null;
        try {
            if (this.urlConnection != null) {
                int responseCode = this.urlConnection.getResponseCode();
                String responseMessage = this.urlConnection.getResponseMessage();
                httpResponseInfo = new HttpResponseInfo(responseCode, responseMessage, this.urlConnectionInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return httpResponseInfo;
    }

    protected String getResponseURI() {
        String responseURI = "/" + this.responseCounter;
        ++this.responseCounter;
        return responseURI;
    }

    protected void internalConnect() throws IOException {
        this.urlConnection = this.proxy == null ? (HttpURLConnection)this.urlObject.openConnection() : (HttpURLConnection)this.urlObject.openConnection(this.proxy);
        this.urlConnection.setDoOutput(true);
        this.setHttpRequestHeaders();
        this.serializationContext.instantiateTypes = this.instantiateTypes;
        this.actionContext = new ActionContext();
        this.connected = true;
    }

    protected Object processHttpResponse(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        this.processHttpResponseHeaders();
        return this.processHttpResponseBody(inputStream);
    }

    protected Object processHttpResponseBody(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        if (this.urlConnectionInputStream != null) {
            this.urlConnectionInputStream.close();
        }
        this.urlConnectionInputStream = new BufferedInputStream(inputStream);
        this.urlConnectionInputStream.mark(2);
        ActionMessage message = new ActionMessage();
        this.actionContext.setRequestMessage(message);
        AmfMessageDeserializer deserializer = new AmfMessageDeserializer();
        deserializer.initialize(this.serializationContext, this.urlConnectionInputStream, this.amfTrace);
        try {
            deserializer.readMessage(message, this.actionContext);
        }
        catch (MessageException me2) {
            if ("VersionMismatch".equals(me2.getCode())) {
                this.urlConnectionInputStream.reset();
                String errorMessage = "Unsupported AMF version";
                throw new ClientStatusException(errorMessage, "AMFConnection.Call.Failed", this.generateHttpResponseInfo());
            }
            throw me2;
        }
        return this.processAmfPacket(message);
    }

    protected void processHttpResponseHeaders() {
        Map<String, List<String>> headers = this.urlConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> element : headers.entrySet()) {
            String headerName = element.getKey();
            List<String> headerValues = element.getValue();
            for (String headerValue : headerValues) {
                if (!SET_COOKIE.equals(headerName) && !COOKIE.equals(headerName) && !SET_COOKIE2.equals(headerName) && !COOKIE2.equals(headerName)) continue;
                this.processSetCookieHeader(headerValue);
            }
        }
    }

    protected Object processAmfPacket(ActionMessage packet) throws ServerStatusException {
        this.processAmfHeaders(packet.getHeaders());
        return this.processAmfBody(packet.getBodies());
    }

    protected void processAmfHeaders(ArrayList<MessageHeader> headers) {
        if (this.amfHeaderProcessor == null) {
            return;
        }
        for (MessageHeader header : headers) {
            this.amfHeaderProcessor.processHeader(header);
        }
    }

    protected Object processAmfBody(ArrayList<MessageBody> messages) throws ServerStatusException {
        for (MessageBody message : messages) {
            String targetURI = message.getTargetURI();
            if (targetURI.endsWith("/onResult")) {
                return message.getData();
            }
            if (!targetURI.endsWith("/onStatus")) continue;
            String exMessage = "Server error";
            HttpResponseInfo responseInfo = this.generateHttpResponseInfo();
            ServerStatusException exception = new ServerStatusException(exMessage, message.getData(), responseInfo);
            throw exception;
        }
        return null;
    }

    protected Object send(ByteArrayOutputStream outBuffer) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        this.internalConnect();
        outBuffer.writeTo(this.urlConnection.getOutputStream());
        outBuffer.flush();
        outBuffer.close();
        return this.processHttpResponse(this.urlConnection.getInputStream());
    }

    protected void processSetCookieHeader(String headerValue) {
        String cookie = headerValue;
        if (cookie.indexOf(COOKIE_SEPERATOR) > 0) {
            cookie = headerValue.substring(0, cookie.indexOf(COOKIE_SEPERATOR));
        }
        String name = cookie.substring(0, cookie.indexOf(COOKIE_NAMEVALUE_SEPERATOR));
        String value = cookie.substring(cookie.indexOf(COOKIE_NAMEVALUE_SEPERATOR) + 1, cookie.length());
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
    }

    protected void setHttpRequestHeaders() {
        this.setHttpRequestCookieHeader();
        if (this.httpRequestHeaders != null) {
            for (Map.Entry<String, String> element : this.httpRequestHeaders.entrySet()) {
                String key = element.getKey();
                String value = element.getValue();
                this.urlConnection.setRequestProperty(key, value);
            }
        }
        this.urlConnection.setRequestProperty(HTTP_HEADER_NAME_CONTENT_TYPE, "application/x-amf");
    }

    protected void setHttpRequestCookieHeader() {
        if (this.cookies == null) {
            return;
        }
        StringBuffer cookieHeaderValue = null;
        for (Map.Entry<String, String> element : this.cookies.entrySet()) {
            String name = element.getKey();
            String value = element.getValue();
            if (cookieHeaderValue == null) {
                cookieHeaderValue = new StringBuffer(name + COOKIE_NAMEVALUE_SEPERATOR + value);
                continue;
            }
            cookieHeaderValue.append("; " + name + COOKIE_NAMEVALUE_SEPERATOR + value);
        }
        if (cookieHeaderValue != null) {
            this.urlConnection.setRequestProperty(COOKIE, cookieHeaderValue.toString());
        }
    }

    public static class HttpResponseInfo {
        private int responseCode;
        private String responseMessage;
        private InputStream responseInputStream;

        public HttpResponseInfo(int responseCode, String responseMessage, InputStream responseInputStream) {
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.responseInputStream = responseInputStream;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public InputStream getResponseInputStream() {
            return this.responseInputStream;
        }

        public String toString() {
            return "HttpResponseInfo \n\tcode: " + this.responseCode + "\n\tmessage: " + this.responseMessage;
        }
    }
}

