/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amfx.AmfxInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AmfxMessageDeserializer
extends DefaultHandler
implements MessageDeserializer {
    protected InputStream in;
    protected Locator locator;
    protected AmfxInput amfxIn;
    protected AmfTrace debugTrace;
    protected boolean isDebug;
    private static Class[] attribArr = new Class[]{Attributes.class};

    public void initialize(SerializationContext context, InputStream in2, AmfTrace trace) {
        this.amfxIn = new AmfxInput(context);
        this.in = in2;
        this.debugTrace = trace;
        boolean bl2 = this.isDebug = this.debugTrace != null;
        if (this.debugTrace != null) {
            this.amfxIn.setDebugTrace(this.debugTrace);
        }
    }

    public void setSerializationContext(SerializationContext context) {
        this.amfxIn = new AmfxInput(context);
    }

    public void readMessage(ActionMessage m10, ActionContext context) throws IOException {
        if (this.isDebug) {
            this.debugTrace.startRequest("Deserializing AMFX/HTTP request");
        }
        this.amfxIn.reset();
        this.amfxIn.setDebugTrace(this.debugTrace);
        this.amfxIn.setActionMessage(m10);
        this.parse(m10);
        context.setVersion(m10.getVersion());
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.amfxIn.readObject();
    }

    protected void parse(ActionMessage m10) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.in, (DefaultHandler)this);
        }
        catch (MessageException ex2) {
            this.clientMessageEncodingException(m10, ex2);
        }
        catch (SAXParseException e10) {
            if (e10.getException() != null) {
                this.clientMessageEncodingException(m10, e10.getException());
            } else {
                this.clientMessageEncodingException(m10, e10);
            }
        }
        catch (Exception ex3) {
            this.clientMessageEncodingException(m10, ex3);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        throw new MessageException("External entities are not allowed");
    }

    protected void clientMessageEncodingException(ActionMessage m10, Throwable t10) {
        MessageException me2 = t10 instanceof MessageException ? (MessageException)t10 : new MessageException("Error occurred parsing AMFX: " + t10.getMessage());
        me2.setCode("Client.Message.Encoding");
        throw me2;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String methodName = "start_" + localName;
            Method method = this.amfxIn.getClass().getMethod(methodName, attribArr);
            method.invoke((Object)this.amfxIn, attributes);
        }
        catch (NoSuchMethodException e10) {
            this.fatalError(new SAXParseException("Unknown type: " + qName, this.locator));
        }
        catch (IllegalAccessException e11) {
            this.fatalError(new SAXParseException(e11.getMessage(), this.locator, e11));
        }
        catch (InvocationTargetException e12) {
            Throwable t10 = e12.getTargetException();
            if (t10 instanceof SAXException) {
                throw (SAXException)t10;
            }
            if (t10 instanceof Exception) {
                this.fatalError(new SAXParseException(t10.getMessage(), this.locator, (Exception)t10));
            }
            this.fatalError(new SAXParseException(e12.getMessage(), this.locator, e12));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String methodName = "end_" + localName;
            Method method = this.amfxIn.getClass().getMethod(methodName, new Class[0]);
            method.invoke((Object)this.amfxIn, new Object[0]);
        }
        catch (NoSuchMethodException e10) {
            this.fatalError(new SAXParseException("Unfinished type: " + qName, this.locator));
        }
        catch (IllegalAccessException e11) {
            this.fatalError(new SAXParseException(e11.getMessage(), this.locator, e11));
        }
        catch (InvocationTargetException e12) {
            Throwable t10 = e12.getTargetException();
            if (t10 instanceof SAXException) {
                throw (SAXException)t10;
            }
            if (t10 instanceof Error) {
                throw (Error)t10;
            }
            this.fatalError(new SAXParseException(t10.getMessage(), this.locator));
        }
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        String chars = new String(ch2, start, length);
        if (chars.length() > 0) {
            this.amfxIn.text(chars);
        }
    }

    public void setDocumentLocator(Locator l10) {
        this.locator = l10;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw new MessageException(exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (exception.getException() != null && exception.getException() instanceof MessageException) {
            throw (MessageException)exception.getException();
        }
        throw new MessageException(exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw new MessageException(exception.getMessage());
    }
}

