/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.log.LoggingHttpServletRequestWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HTTPRequestLog {
    public static final String HTTP_ERROR_INFO = "com.adobe.internal._exception_info";
    private static String filename;

    public static boolean init(ServletContext context) {
        String logfile = context.getInitParameter("HttpErrorLog");
        if (logfile == null || logfile.length() == 0) {
            return false;
        }
        filename = logfile;
        return true;
    }

    public static void setFileName(String fileName) {
        if (fileName != null) {
            filename = fileName;
        }
    }

    public static String getFileName() {
        return filename;
    }

    public static synchronized void outputRequest(String header, HttpServletRequest httpReq) {
        if (!(httpReq instanceof LoggingHttpServletRequestWrapper) || filename == null) {
            return;
        }
        LoggingHttpServletRequestWrapper req = (LoggingHttpServletRequestWrapper)httpReq;
        try {
            FileWriter fw2 = new FileWriter(filename, true);
            fw2.write("#===== Request Client Infomation =====#\n");
            if (header != null) {
                fw2.write("Error             : " + header + "\n");
            }
            fw2.write("Timestamp         : " + new Date(System.currentTimeMillis()).toString() + "\n");
            fw2.write("Client IP Address : " + req.getRemoteAddr() + "\n");
            fw2.write("Client FQDN       : " + req.getRemoteHost() + "\n");
            fw2.write("Body size         : " + req.getContentLength() + "\n");
            fw2.write("#===== HTTP Headers =====#\n");
            HTTPRequestLog.outputHeaders(fw2, req);
            fw2.write("#===== HTTP Body =====#\n");
            HTTPRequestLog.outputBody(fw2, req);
            fw2.close();
        }
        catch (IOException ex2) {
            System.out.println("Unable to write HTTP request data to file " + filename + ": " + ex2.toString());
        }
    }

    public static void outputPrint(String message) {
        try {
            FileWriter fw2 = new FileWriter(filename, true);
            fw2.write(message + "\n");
            fw2.close();
        }
        catch (IOException ex2) {
            System.out.println("Unable to log message '" + message + "' to file " + filename + " : " + ex2.toString());
        }
    }

    private static void outputHeaders(FileWriter fw2, LoggingHttpServletRequestWrapper req) throws IOException {
        Enumeration reqHeaderNum = req.getHeaderNames();
        if (reqHeaderNum == null) {
            fw2.write("No headers\n");
            return;
        }
        while (reqHeaderNum.hasMoreElements()) {
            String key = (String)reqHeaderNum.nextElement();
            HTTPRequestLog.outputHeaderElements(fw2, req, key);
        }
    }

    private static void outputHeaderElements(FileWriter fw2, LoggingHttpServletRequestWrapper req, String key) throws IOException {
        Enumeration e10 = req.getHeaders(key);
        String keyname = key;
        while (e10.hasMoreElements()) {
            fw2.write(keyname + " : " + e10.nextElement() + "\n");
            keyname = "        ";
        }
    }

    private static void outputBody(FileWriter fw2, LoggingHttpServletRequestWrapper req) throws IOException {
        int leng = req.getContentLength();
        if (leng <= 0) {
            return;
        }
        byte[] rbuf = new byte[leng];
        ServletInputStream in2 = req.getInputStream();
        if (in2.read(rbuf, 0, leng) > 0) {
            HTTPRequestLog.outputBinary(fw2, rbuf);
        }
    }

    private static void outputBinary(FileWriter fw2, byte[] buf) throws IOException {
        int adrs = 0;
        for (int j10 = 0; j10 < buf.length; j10 += 16) {
            int i10;
            String adrsStr = "00000000" + Integer.toHexString(adrs);
            adrsStr = adrsStr.substring(adrsStr.length() - 8, adrsStr.length());
            fw2.write("\n" + adrsStr + " : ");
            adrs += 16;
            for (i10 = 0; i10 < 16; ++i10) {
                if (i10 + j10 >= buf.length) {
                    fw2.write("   ");
                    continue;
                }
                int n10 = buf[i10 + j10];
                if (n10 < 0) {
                    n10 += 256;
                }
                String s10 = "00" + Integer.toHexString(n10);
                s10 = s10.substring(s10.length() - 2, s10.length());
                fw2.write(s10 + " ");
            }
            fw2.write("    ");
            for (i10 = 0; i10 < 16 && i10 + j10 < buf.length; ++i10) {
                if (buf[i10 + j10] < 32 || buf[i10 + j10] > 222 || buf[i10 + j10] > 126 && buf[i10 + j10] < 161) {
                    fw2.write(".");
                    continue;
                }
                String s11 = String.valueOf((char)buf[i10 + j10]);
                fw2.write(s11);
            }
        }
        fw2.write("\n");
    }
}

