/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class LoggingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] _bodyInfoData;

    public LoggingHttpServletRequestWrapper(HttpServletRequest parent) {
        super(parent);
    }

    public void doReadBody() throws IOException {
        int length = super.getContentLength();
        if (length > 0) {
            int readLen;
            ByteArrayOutputStream out = new ByteArrayOutputStream(length);
            ServletInputStream in2 = super.getInputStream();
            byte[] bodyByte = new byte[length];
            for (int remain = length; remain > 0 && (readLen = in2.read(bodyByte)) > 0; remain -= readLen) {
                out.write(bodyByte, 0, readLen);
            }
            this._bodyInfoData = out.toByteArray();
            out.close();
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._bodyInfoData != null) {
            return new ExServletInputStream(new ByteArrayInputStream(this._bodyInfoData));
        }
        return super.getInputStream();
    }

    private static class ExServletInputStream
    extends ServletInputStream {
        private InputStream _inputStream;

        ExServletInputStream(InputStream inputStream) {
            this._inputStream = inputStream;
        }

        public int readLine(byte[] b10, int off, int len) throws IOException {
            throw new UnsupportedOperationException("This method is not extended");
        }

        public int read(byte[] b10, int off, int len) throws IOException {
            return this._inputStream.read(b10, off, len);
        }

        public int read(byte[] b10) throws IOException {
            return this._inputStream.read(b10);
        }

        public void mark(int readlimit) {
            this._inputStream.mark(readlimit);
        }

        public long skip(long n10) throws IOException {
            return this._inputStream.skip(n10);
        }

        public void reset() throws IOException {
            this._inputStream.reset();
        }

        public int read() throws IOException {
            return this._inputStream.read();
        }

        public boolean markSupported() {
            return this._inputStream.markSupported();
        }

        public void close() throws IOException {
            this._inputStream.close();
        }

        public int available() throws IOException {
            return this._inputStream.available();
        }
    }
}

