/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.MessageException;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.services.messaging.adapters.JMSProxy;
import flex.messaging.services.messaging.adapters.JMSSettings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMSProducer
extends JMSProxy {
    protected MessageProducer producer;
    protected int deliveryMode = 2;
    protected int messagePriority = 4;
    protected String messageType;

    @Override
    public void initialize(JMSSettings settings) {
        super.initialize(settings);
        String deliveryString = settings.getDeliveryMode();
        if (deliveryString.equals("default_delivery_mode")) {
            this.deliveryMode = 2;
        } else if (deliveryString.equals("persistent")) {
            this.deliveryMode = 2;
        } else if (deliveryString.equals("non_persistent")) {
            this.deliveryMode = 1;
        }
        this.messagePriority = settings.getMessagePriority();
        this.messageType = settings.getMessageType();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.messageType == null || !this.messageType.equals("javax.jms.TextMessage") && !this.messageType.equals("javax.jms.ObjectMessage") && !this.messageType.equals("javax.jms.MapMessage")) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10811, new Object[]{this.messageType});
            throw ce2;
        }
    }

    @Override
    public void start() throws NamingException, JMSException {
        super.start();
        if (Log.isInfo()) {
            Log.getLogger("Service.Message.JMS").info("JMS producer for JMS destination '" + this.destinationJndiName + "' is starting.");
        }
    }

    @Override
    public void stop() {
        block4: {
            if (Log.isInfo()) {
                Log.getLogger("Service.Message.JMS").info("JMS producer for JMS destination '" + this.destinationJndiName + "' is stopping.");
            }
            try {
                if (this.producer != null) {
                    this.producer.close();
                }
            }
            catch (JMSException e10) {
                if (!Log.isWarn()) break block4;
                Log.getLogger("Service.Message.JMS").warn("JMS producer for JMS destination '" + this.destinationJndiName + "' received an error while closing" + " its underlying MessageProducer: " + e10.getMessage());
            }
        }
        super.stop();
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        if (deliveryMode == 2 || deliveryMode == 1 || deliveryMode == 2) {
            this.deliveryMode = deliveryMode;
        }
    }

    public int getMessagePriority() {
        return this.messagePriority;
    }

    public void setMessagePriority(int messagePriority) {
        this.messagePriority = messagePriority;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    protected void copyHeadersToProperties(Map properties, javax.jms.Message message) throws JMSException {
        for (String propName : properties.keySet()) {
            Object propValue = properties.get(propName);
            if (propName.equals("timeToLive")) continue;
            if (propName.equals("DSMPII")) {
                Field[] fields = propValue.getClass().getFields();
                for (int i10 = 0; i10 < fields.length; ++i10) {
                    Field field = fields[i10];
                    String mpiPropertyName = "DSMPII" + field.getName();
                    Object mpiPropertyValue = null;
                    try {
                        mpiPropertyValue = field.get(propValue);
                        message.setObjectProperty(mpiPropertyName, mpiPropertyValue);
                        continue;
                    }
                    catch (Exception e10) {
                        if (!Log.isWarn()) continue;
                        Log.getLogger("Service.Message.JMS").warn("JMSProducer could not retrieve the value of MessagePerformanceUtils property '" + propValue + "' from the Flex message, therefore it will not be set on the JMS message.");
                    }
                }
                continue;
            }
            if (propValue == null) continue;
            message.setObjectProperty(propName, propValue);
        }
    }

    protected long getTimeToLive(Map properties) throws JMSException {
        long l10;
        long timeToLive = this.producer.getTimeToLive();
        if (properties.containsKey("timeToLive") && (l10 = ((Long)properties.get("timeToLive")).longValue()) != 0L) {
            timeToLive = l10;
        }
        return timeToLive;
    }

    void sendMessage(Message flexMessage) throws JMSException {
        MessagePerformanceUtils.markServerPreAdapterExternalTime(flexMessage);
        if ("javax.jms.TextMessage".equals(this.messageType)) {
            this.sendTextMessage(flexMessage.getBody().toString(), flexMessage.getHeaders());
        } else {
            if ("javax.jms.ObjectMessage".equals(this.messageType)) {
                try {
                    this.sendObjectMessage((Serializable)flexMessage.getBody(), flexMessage.getHeaders());
                }
                catch (ClassCastException ce2) {
                    MessageException me2 = new MessageException();
                    me2.setMessage(10810);
                    throw me2;
                }
            }
            if ("javax.jms.MapMessage".equals(this.messageType)) {
                try {
                    this.sendMapMessage((Map)flexMessage.getBody(), flexMessage.getHeaders());
                }
                catch (ClassCastException ce3) {
                    MessageException me3 = new MessageException();
                    me3.setMessage(10812);
                    throw me3;
                }
            }
        }
    }

    abstract void sendObjectMessage(Serializable var1, Map var2) throws JMSException;

    abstract void sendTextMessage(String var1, Map var2) throws JMSException;

    abstract void sendMapMessage(Map<String, ?> var1, Map var2) throws JMSException;
}

