/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.util.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SettingsReplaceUtil {
    private static final int TOKEN_NOT_SUPPORTED = 10129;
    private static final int TOKEN_NOT_SUPPORTED_ANY = 10130;
    private static final int PARSE_ERROR_DYNAMIC_URL = 10131;
    public static final String SLASH_CONTEXT_PATH_TOKEN = "/{context.root}";
    public static final String CONTEXT_PATH_TOKEN = "{context.root}";
    public static final String CONTEXT_PATH_ALT_TOKEN = "{context-root}";
    public static final String SERVER_NAME_TOKEN = "{server.name}";
    public static final String SERVER_NAME_ALT_TOKEN = "{server-name}";
    public static final String SERVER_PORT_TOKEN = "{server.port}";
    public static final String SERVER_PORT_ALT_TOKEN = "{server-port}";

    public static String replaceContextPath(String url, String contextPath) {
        String token = CONTEXT_PATH_TOKEN;
        int contextIndex = url.indexOf(CONTEXT_PATH_ALT_TOKEN);
        if (contextIndex != -1) {
            token = CONTEXT_PATH_ALT_TOKEN;
            url = StringUtils.substitute(url, CONTEXT_PATH_ALT_TOKEN, CONTEXT_PATH_TOKEN);
        }
        contextIndex = url.indexOf(CONTEXT_PATH_TOKEN);
        if (contextPath == null && contextIndex != -1) {
            MessageException me2 = new MessageException();
            if (FlexContext.getHttpRequest() == null) {
                me2.setMessage(10129, "0", new Object[]{token});
            } else {
                me2.setMessage(10129, new Object[]{token});
            }
            throw me2;
        }
        if (contextPath != null) {
            if (contextIndex == 0) {
                url = contextPath + url.substring(CONTEXT_PATH_TOKEN.length());
            } else if (contextIndex > 0) {
                url = url.indexOf(SLASH_CONTEXT_PATH_TOKEN) != -1 ? StringUtils.substitute(url, SLASH_CONTEXT_PATH_TOKEN, contextPath) : StringUtils.substitute(url, CONTEXT_PATH_TOKEN, contextPath);
            }
        }
        return url;
    }

    public static String replaceAllTokensGivenServerName(String url, String contextPath, String serverName, String serverPort, String serverProtocol) {
        if (url.startsWith("/")) {
            url = serverProtocol + "://{server.name}:{server.port}" + url;
        }
        url = SettingsReplaceUtil.replaceContextPath(url, contextPath);
        String token = SERVER_NAME_TOKEN;
        int serverNameIndex = url.indexOf(SERVER_NAME_ALT_TOKEN);
        if (serverNameIndex != -1) {
            token = SERVER_NAME_ALT_TOKEN;
            url = StringUtils.substitute(url, SERVER_NAME_ALT_TOKEN, SERVER_NAME_TOKEN);
        }
        serverNameIndex = url.indexOf(SERVER_NAME_TOKEN);
        if (serverName == null && serverNameIndex != -1) {
            MessageException me2 = new MessageException();
            me2.setMessage(10129, new Object[]{token});
            throw me2;
        }
        if (serverName != null && serverNameIndex != -1) {
            url = StringUtils.substitute(url, SERVER_NAME_TOKEN, serverName);
        }
        token = SERVER_PORT_TOKEN;
        int serverPortIndex = url.indexOf(SERVER_PORT_ALT_TOKEN);
        if (serverPortIndex != -1) {
            token = SERVER_PORT_ALT_TOKEN;
            url = StringUtils.substitute(url, SERVER_PORT_ALT_TOKEN, SERVER_PORT_TOKEN);
        }
        serverPortIndex = url.indexOf(SERVER_PORT_TOKEN);
        if (serverPort == null && serverPortIndex != -1) {
            MessageException me3 = new MessageException();
            me3.setMessage(10129, new Object[]{token});
            throw me3;
        }
        if (serverPort != null && serverPortIndex != -1) {
            url = StringUtils.substitute(url, SERVER_PORT_TOKEN, serverPort);
        }
        return SettingsReplaceUtil.updateIPv6(url);
    }

    public static Set replaceAllTokensCalculateServerName(List urls, String contextPath) {
        ArrayList<String> contextParsedUrls = new ArrayList<String>(urls.size());
        HashSet newURLs = new HashSet(urls.size());
        for (int i10 = 0; i10 < urls.size(); ++i10) {
            String url = (String)urls.get(i10);
            url = url.toLowerCase().trim();
            url = SettingsReplaceUtil.replaceContextPath(url, contextPath);
            contextParsedUrls.add(url);
        }
        SettingsReplaceUtil.replaceServerNameWithLocalHost(contextParsedUrls, newURLs);
        return newURLs;
    }

    public static void replaceServerNameWithLocalHost(List urls, Set newURLs) {
        for (String url : urls) {
            url = url.toLowerCase().trim();
            String token = SERVER_PORT_TOKEN;
            int serverPortIndex = url.indexOf(SERVER_PORT_ALT_TOKEN);
            if (serverPortIndex != -1) {
                token = SERVER_PORT_ALT_TOKEN;
                url = StringUtils.substitute(url, SERVER_PORT_ALT_TOKEN, SERVER_PORT_TOKEN);
            }
            if ((serverPortIndex = url.indexOf(SERVER_PORT_TOKEN)) != -1) {
                MessageException me2 = new MessageException();
                me2.setMessage(10130, new Object[]{token});
                throw me2;
            }
            if (url.indexOf(SERVER_NAME_ALT_TOKEN) != 0) {
                StringUtils.substitute(url, SERVER_NAME_ALT_TOKEN, SERVER_NAME_TOKEN);
            }
            if (url.indexOf(SERVER_NAME_TOKEN) != 0) {
                try {
                    SettingsReplaceUtil.addLocalServerURL(url, "localhost", newURLs);
                    SettingsReplaceUtil.addLocalServerURL(url, "127.0.0.1", newURLs);
                    SettingsReplaceUtil.addLocalServerURL(url, "[::1]", newURLs);
                    InetAddress local = InetAddress.getLocalHost();
                    SettingsReplaceUtil.addInetAddress(local, url, newURLs);
                    Enumeration<NetworkInterface> e10 = NetworkInterface.getNetworkInterfaces();
                    while (e10.hasMoreElements()) {
                        NetworkInterface address = e10.nextElement();
                        Enumeration<InetAddress> e22 = address.getInetAddresses();
                        while (e22.hasMoreElements()) {
                            local = e22.nextElement();
                            SettingsReplaceUtil.addInetAddress(local, url, newURLs);
                        }
                    }
                    continue;
                }
                catch (Exception e11) {
                    MessageException me3 = new MessageException();
                    me3.setMessage(10131);
                    throw me3;
                }
            }
            SettingsReplaceUtil.addParsedURL(url, newURLs);
        }
    }

    private static void addInetAddress(InetAddress local, String url, Set newURLs) throws Exception {
        String localHostName;
        String localHostAddress = local.getHostAddress();
        if (localHostAddress != null) {
            SettingsReplaceUtil.addLocalServerURL(url, localHostAddress, newURLs);
        }
        if ((localHostName = local.getHostName()) != null) {
            SettingsReplaceUtil.addLocalServerURL(url, localHostName, newURLs);
            InetAddress[] addrs = InetAddress.getAllByName(localHostName);
            for (int i10 = 0; i10 < addrs.length; ++i10) {
                String hostAddress;
                InetAddress addr = addrs[i10];
                String hostName = addr.getHostName();
                if (!hostName.equals(localHostName)) {
                    SettingsReplaceUtil.addLocalServerURL(url, hostName, newURLs);
                }
                if ((hostAddress = addr.getHostAddress()).equals(localHostAddress)) continue;
                SettingsReplaceUtil.addLocalServerURL(url, hostAddress, newURLs);
            }
        }
    }

    private static void addLocalServerURL(String url, String sub2, Set newURLs) {
        String toSub = null;
        if (sub2.indexOf(":") != -1) {
            StringBuffer ipv6Sub = new StringBuffer("[");
            ipv6Sub.append(sub2);
            ipv6Sub.append("]");
            toSub = ipv6Sub.toString();
        } else {
            toSub = sub2;
        }
        String newUrl = StringUtils.substitute(url, SERVER_NAME_TOKEN, toSub);
        SettingsReplaceUtil.addParsedURL(newUrl, newURLs);
    }

    private static void addParsedURL(String url, Set newURLs) {
        if (!newURLs.contains(url)) {
            newURLs.add(SettingsReplaceUtil.updateIPv6(url));
        }
    }

    public static String updateIPv6(String src2) {
        if (src2 != null && src2.indexOf(91) != -1 && src2.indexOf(93) != -1) {
            int start = src2.indexOf(91);
            int end = src2.indexOf(93);
            StringBuffer updated = new StringBuffer(src2.substring(0, start + 1));
            updated.append(SettingsReplaceUtil.updateToLongForm(src2.substring(start + 1, end)));
            updated.append(src2.substring(end));
            return updated.toString();
        }
        return src2;
    }

    protected static String updateToLongForm(String src2) {
        int numberOfTokens = 0;
        int doubleColonIndex = src2.indexOf("::", 0);
        if (doubleColonIndex != -1) {
            String[] hexTokens = src2.split("\\:");
            for (int i10 = 0; i10 < hexTokens.length; ++i10) {
                if (hexTokens[i10].equals("")) continue;
                ++numberOfTokens;
            }
            int numberOfMissingZeros = 8 - numberOfTokens;
            if (numberOfMissingZeros > 0) {
                String replacement = "";
                if (!src2.startsWith("::")) {
                    replacement = ":";
                }
                while (numberOfMissingZeros-- > 0) {
                    replacement = replacement + "0:";
                }
                src2 = src2.replaceFirst("\\::", replacement);
            }
        }
        return src2;
    }
}

