/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.SkipVisitorException;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;

public class DescendentHTMLCollection
implements HTMLCollection {
    private final NodeImpl rootNode;
    private final NodeFilter nodeFilter;

    public DescendentHTMLCollection(NodeImpl node, NodeFilter filter) {
        this.rootNode = node;
        this.nodeFilter = filter;
    }

    public int getLength() {
        NodeCounter nc2 = new NodeCounter();
        this.rootNode.visit(nc2);
        return nc2.getCount();
    }

    public Node item(int index) {
        NodeScanner ns2 = new NodeScanner(index);
        try {
            this.rootNode.visit(ns2);
        }
        catch (StopVisitorException stopVisitorException) {
            // empty catch block
        }
        return ns2.getNode();
    }

    public Node namedItem(String name) {
        Document doc2 = this.rootNode.getOwnerDocument();
        if (doc2 == null) {
            return null;
        }
        Element node = doc2.getElementById(name);
        if (node != null && this.nodeFilter.accept(node)) {
            return node;
        }
        return null;
    }

    public int indexOf(Node node) {
        NodeScanner2 ns2 = new NodeScanner2(node);
        try {
            this.rootNode.visit(ns2);
        }
        catch (StopVisitorException stopVisitorException) {
            // empty catch block
        }
        return ns2.getIndex();
    }

    private final class NodeScanner2
    implements NodeVisitor {
        private int count = 0;
        private int foundIndex = -1;
        private final Node targetNode;

        public NodeScanner2(Node node) {
            this.targetNode = node;
        }

        public final void visit(Node node) {
            if (DescendentHTMLCollection.this.nodeFilter.accept(node)) {
                if (node == this.targetNode) {
                    this.foundIndex = this.count;
                    throw new StopVisitorException();
                }
                ++this.count;
                throw new SkipVisitorException();
            }
        }

        public int getIndex() {
            return this.foundIndex;
        }
    }

    private final class NodeScanner
    implements NodeVisitor {
        private int count = 0;
        private Node foundNode = null;
        private final int targetIndex;

        public NodeScanner(int idx) {
            this.targetIndex = idx;
        }

        public final void visit(Node node) {
            if (DescendentHTMLCollection.this.nodeFilter.accept(node)) {
                if (this.count == this.targetIndex) {
                    this.foundNode = node;
                    throw new StopVisitorException();
                }
                ++this.count;
                throw new SkipVisitorException();
            }
        }

        public Node getNode() {
            return this.foundNode;
        }
    }

    private final class NodeCounter
    implements NodeVisitor {
        private int count = 0;

        private NodeCounter() {
        }

        public final void visit(Node node) {
            if (DescendentHTMLCollection.this.nodeFilter.accept(node)) {
                ++this.count;
                throw new SkipVisitorException();
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

