/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.ColorRenderState;
import org.lobobrowser.html.style.FontNameRenderState;
import org.lobobrowser.html.style.FontSizeRenderState;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.html2.HTMLFontElement;

public class HTMLFontElementImpl
extends HTMLAbstractUIElement
implements HTMLFontElement {
    public HTMLFontElementImpl(String name) {
        super(name);
    }

    public String getColor() {
        return this.getAttribute("color");
    }

    public String getFace() {
        return this.getAttribute("face");
    }

    public String getSize() {
        return this.getAttribute("size");
    }

    public void setColor(String color) {
        this.setAttribute("color", color);
    }

    public void setFace(String face) {
        this.setAttribute("face", face);
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        String face = this.getAttribute("face");
        String size = this.getAttribute("size");
        String color = this.getAttribute("color");
        if (face != null) {
            prevRenderState = new FontNameRenderState(prevRenderState, face);
        }
        if (size != null) {
            int fontNumber = HtmlValues.getFontNumberOldStyle(size, prevRenderState);
            float fontSize = HtmlValues.getFontSize(fontNumber);
            prevRenderState = new FontSizeRenderState(prevRenderState, fontSize);
        }
        if (color != null) {
            prevRenderState = new ColorRenderState(prevRenderState, ColorFactory.getInstance().getColor(color));
        }
        return prevRenderState;
    }
}

