/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.Nodes;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HtmlBlockPanel
extends JComponent
implements NodeRenderer,
RenderableContainer,
ClipboardOwner {
    private static final Logger logger = null;
    private static final boolean loggableInfo = false;
    protected final FrameContext frameContext;
    protected final UserAgentContext ucontext;
    protected final HtmlRendererContext rcontext;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected RBlock rblock;
    protected int preferredWidth = -1;
    private Insets defaultPaddingInsets = null;
    private boolean processingDocumentNotification = false;

    public HtmlBlockPanel(int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this(listNesting, ColorFactory.TRANSPARENT, false, pcontext, rcontext, frameContext);
    }

    public HtmlBlockPanel(int listNesting, Color background, boolean opaque, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.frameContext = frameContext;
        this.ucontext = pcontext;
        this.rcontext = rcontext;
        this.setOpaque(opaque);
        this.setBackground(background);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                String command = e10.getActionCommand();
                if ("copy".equals(command)) {
                    HtmlBlockPanel.this.copy();
                }
            }
        };
        this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(65485, 0), 0);
        this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 0);
    }

    public BoundableRenderable getRootRenderable() {
        return this.rblock;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public Dimension getPreferredSize() {
        RBlock block;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int pw2 = this.preferredWidth;
        if (pw2 != -1 && (block = this.rblock) != null) {
            block.layout(pw2, 0, false, false, 0);
            int newPw = Math.max(block.width + block.getVScrollBarWidth(), pw2);
            return new Dimension(newPw, block.height);
        }
        return new Dimension(600, 400);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public boolean copy() {
        String selection = this.getSelectionText();
        if (selection != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(selection), this);
            return true;
        }
        return false;
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public int getFirstLineHeight() {
        RBlock block = this.rblock;
        return block == null ? 0 : block.getFirstLineHeight();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    public boolean isSelectionAvailable() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    public Node getSelectionNode() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            return Nodes.getCommonAncestor((Node)((Object)start.renderable.getModelNode()), (Node)((Object)end.renderable.getModelNode()));
        }
        return null;
    }

    public void setRootNode(NodeImpl node) {
        if (node != null) {
            RBlock block = new RBlock(node, 0, this.ucontext, this.rcontext, this.frameContext, this, 5);
            block.setDefaultPaddingInsets(this.defaultPaddingInsets);
            node.setUINode(block);
            this.rblock = block;
        } else {
            this.rblock = null;
        }
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container parent;
        Container toValidate = this;
        while ((parent = toValidate.getParent()) != null && !parent.isValid()) {
            toValidate = parent;
        }
        ((Component)toValidate).validate();
    }

    public void setRootNode(NodeImpl node, boolean setContainer) {
        this.setRootNode(node);
    }

    protected void revalidatePanel() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public NodeImpl getRootNode() {
        RBlock block = this.rblock;
        return block == null ? null : (NodeImpl)block.getModelNode();
    }

    public void paint(Graphics g10) {
        RBlock block;
        if (this.isOpaque()) {
            Rectangle clipBounds = g10.getClipBounds();
            g10.setColor(this.getBackground());
            g10.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        if (g10 instanceof Graphics2D) {
            Graphics2D g22 = (Graphics2D)g10;
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if ((block = this.rblock) != null) {
            boolean liflag = loggableInfo;
            long time1 = liflag ? System.currentTimeMillis() : 0L;
            block.paint(g10);
            if (liflag) {
                long time2 = System.currentTimeMillis();
                NodeImpl rootNode = this.getRootNode();
                String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
            }
            RenderableSpot start = this.startSelection;
            RenderableSpot end = this.endSelection;
            if (start != null && end != null && !start.equals(end)) {
                block.paintSelection(g10, false, start, end);
            }
        }
    }

    public void doLayout() {
        if (EventQueue.isDispatchThread()) {
            Dimension size = this.getSize();
            boolean liflag = loggableInfo;
            long time1 = 0L;
            if (liflag) {
                time1 = System.currentTimeMillis();
            }
            this.removeAll();
            RBlock block = this.rblock;
            if (block != null) {
                ModelNode rootNode = block.getModelNode();
                block.layout(size.width, size.height, true, true);
                block.setOrigin(0, 0);
                block.updateWidgetBounds(0, 0);
                if (liflag) {
                    long time2 = System.currentTimeMillis();
                    String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
                }
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlBlockPanel.this.doLayout();
                }
            });
        }
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public String getSelectionText() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            StringBuffer buffer = new StringBuffer();
            this.rblock.extractSelectionText(buffer, false, start, end);
            return buffer.toString();
        }
        return null;
    }

    public boolean hasSelection() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    protected void paintChildren(Graphics g10) {
    }

    public Color getPaintedBackgroundColor() {
        return this.isOpaque() ? this.getBackground() : null;
    }

    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    public void relayout() {
        this.revalidatePanel();
    }

    public void invalidateLayoutUpTree() {
    }

    public void updateAllWidgetBounds() {
        this.rblock.updateWidgetBounds(0, 0);
    }

    public Point getGUIPoint(int clientX, int clientY) {
        return new Point(clientX, clientY);
    }

    public void focus() {
        this.grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDocumentNotifications(DocumentNotification[] notifications) {
        if (this.processingDocumentNotification) {
            throw new IllegalStateException("Recursive");
        }
        this.processingDocumentNotification = true;
        try {
            boolean topLayout = false;
            ArrayList<RElement> repainters = null;
            int length = notifications.length;
            block8: for (int i10 = 0; i10 < length; ++i10) {
                DocumentNotification dn2 = notifications[i10];
                int type = dn2.type;
                switch (type) {
                    case 2: 
                    case 3: {
                        RElement relement;
                        UINode uiNode;
                        NodeImpl node = dn2.node;
                        if (node == null) {
                            this.rblock.invalidateLayoutDeep();
                        } else {
                            uiNode = node.findUINode();
                            if (uiNode != null) {
                                relement = (RElement)uiNode;
                                relement.invalidateLayoutUpTree();
                            }
                        }
                        topLayout = true;
                        continue block8;
                    }
                    case 1: {
                        UINode uiNode;
                        NodeImpl node = dn2.node;
                        NodeImpl parent = (NodeImpl)node.getParentNode();
                        if (parent != null && (uiNode = parent.findUINode()) != null) {
                            RElement relement = (RElement)uiNode;
                            relement.invalidateLayoutUpTree();
                        }
                        topLayout = true;
                        continue block8;
                    }
                    case 0: {
                        NodeImpl node = dn2.node;
                        UINode uiNode = node.findUINode();
                        if (uiNode == null) continue block8;
                        if (repainters == null) {
                            repainters = new ArrayList<RElement>(1);
                        }
                        RElement relement = (RElement)uiNode;
                        repainters.add(relement);
                        continue block8;
                    }
                }
            }
            if (topLayout) {
                this.revalidatePanel();
            } else if (repainters != null) {
                Iterator i11 = repainters.iterator();
                while (i11.hasNext()) {
                    RElement element = (RElement)i11.next();
                    element.repaint();
                }
            }
        }
        finally {
            this.processingDocumentNotification = false;
        }
    }

    public void addDelayedPair(DelayedPair pair) {
    }

    public RenderableContainer getParentContainer() {
        return null;
    }

    public Collection getDelayedPairs() {
        return null;
    }

    public void clearDelayedPairs() {
    }
}

