/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlParserContext;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.gui.FrameSetPanel;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLFrameSetElement;
import org.xml.sax.SAXException;

public class HtmlPanel
extends JComponent
implements FrameContext {
    private final EventDispatch2 selectionDispatch = new SelectionDispatch();
    private final Timer notificationTimer;
    private final DocumentNotificationListener notificationListener;
    private static final int NOTIF_TIMER_DELAY = 300;
    private volatile boolean isFrameSet = false;
    private volatile NodeRenderer nodeRenderer = null;
    private volatile NodeImpl rootNode;
    private volatile HtmlBlockPanel htmlBlock;
    private volatile FrameSetPanel frameSetPanel;
    private volatile int preferredWidth = -1;
    private ArrayList notifications = new ArrayList(1);

    public HtmlPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setOpaque(false);
        this.notificationTimer = new Timer(300, new NotificationTimerAction());
        this.notificationTimer.setRepeats(false);
        this.notificationListener = new LocalDocumentNotificationListener();
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
        HtmlBlockPanel htmlBlock = this.htmlBlock;
        if (htmlBlock != null) {
            htmlBlock.setPreferredWidth(width);
        }
    }

    public BoundableRenderable getBlockRenderable() {
        HtmlBlockPanel htmlBlock = this.htmlBlock;
        return htmlBlock == null ? null : htmlBlock.getRootRenderable();
    }

    public FrameSetPanel getFrameSetPanel() {
        int componentCount = this.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        Component c10 = this.getComponent(0);
        if (c10 instanceof FrameSetPanel) {
            return (FrameSetPanel)c10;
        }
        return null;
    }

    private void setUpAsBlock(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        HtmlBlockPanel shp = this.createHtmlBlockPanel(ucontext, rcontext);
        shp.setPreferredWidth(this.preferredWidth);
        this.htmlBlock = shp;
        this.frameSetPanel = null;
        shp.setDefaultPaddingInsets(new Insets(8, 8, 8, 8));
        this.removeAll();
        this.add(shp);
        this.nodeRenderer = shp;
    }

    private void setUpFrameSet(NodeImpl fsrn) {
        FrameSetPanel fsp;
        this.isFrameSet = true;
        this.htmlBlock = null;
        this.frameSetPanel = fsp = this.createFrameSetPanel();
        this.nodeRenderer = fsp;
        this.removeAll();
        this.add(fsp);
        fsp.setRootNode(fsrn);
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        return new HtmlBlockPanel(0, Color.WHITE, true, ucontext, rcontext, this);
    }

    protected FrameSetPanel createFrameSetPanel() {
        return new FrameSetPanel();
    }

    public void scroll(int x10, int y10) {
    }

    public void clearDocument() {
        if (EventQueue.isDispatchThread()) {
            this.clearDocumentImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.clearDocumentImpl();
                }
            });
        }
    }

    private void clearDocumentImpl() {
        NodeRenderer nr2;
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        if ((nr2 = this.nodeRenderer) != null) {
            nr2.setRootNode(null);
        }
        this.rootNode = null;
        this.htmlBlock = null;
        this.nodeRenderer = null;
        this.isFrameSet = false;
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void setDocument(Document node, HtmlRendererContext rcontext, HtmlParserContext pcontext) {
        this.setDocument(node, rcontext);
    }

    public void setDocument(final Document node, final HtmlRendererContext rcontext) {
        if (EventQueue.isDispatchThread()) {
            this.setDocumentImpl(node, rcontext);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlPanel.this.setDocumentImpl(node, rcontext);
                }
            });
        }
    }

    private void setDocumentImpl(Document node, HtmlRendererContext rcontext) {
        NodeRenderer nr2;
        boolean newIfs;
        if (!(node instanceof HTMLDocumentImpl)) {
            throw new IllegalArgumentException("Only nodes of type HTMLDocumentImpl are currently supported. Use DocumentBuilderImpl.");
        }
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        HTMLDocumentImpl nodeImpl = (HTMLDocumentImpl)node;
        nodeImpl.addDocumentNotificationListener(this.notificationListener);
        this.rootNode = nodeImpl;
        NodeImpl fsrn = this.getFrameSetRootNode(nodeImpl);
        boolean bl2 = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
            } else {
                this.setUpAsBlock(rcontext.getUserAgentContext(), rcontext);
            }
        }
        if ((nr2 = this.nodeRenderer) != null) {
            if (newIfs) {
                nr2.setRootNode(fsrn);
            } else {
                nr2.setRootNode(nodeImpl);
            }
        } else {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHtml(String htmlSource, String uri, HtmlRendererContext rcontext) {
        try {
            DocumentBuilderImpl builder = new DocumentBuilderImpl(rcontext.getUserAgentContext(), rcontext);
            StringReader reader = new StringReader(htmlSource);
            try {
                InputSourceImpl is2 = new InputSourceImpl(reader, uri);
                Document document = builder.parse(is2);
                this.setDocument(document, rcontext);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected condition.", ioe);
        }
        catch (SAXException se2) {
            throw new IllegalStateException("Unexpected condition.", se2);
        }
    }

    public NodeImpl getRootNode() {
        return this.rootNode;
    }

    private boolean resetIfFrameSet() {
        boolean newIfs;
        NodeImpl nodeImpl = this.rootNode;
        NodeImpl fsrn = this.getFrameSetRootNode(nodeImpl);
        boolean bl2 = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
                NodeRenderer nr2 = this.nodeRenderer;
                nr2.setRootNode(fsrn);
                this.validate();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private NodeImpl getFrameSetRootNode(NodeImpl node) {
        if (node instanceof Document) {
            ElementImpl element = (ElementImpl)((Document)((Object)node)).getDocumentElement();
            if (element != null && "HTML".equalsIgnoreCase(element.getTagName())) {
                return this.getFrameSet(element);
            }
            return this.getFrameSet(node);
        }
        return null;
    }

    private NodeImpl getFrameSet(NodeImpl node) {
        NodeImpl[] children = node.getChildrenArray();
        if (children == null) {
            return null;
        }
        int length = children.length;
        NodeImpl frameSet = null;
        for (int i10 = 0; i10 < length; ++i10) {
            String tagName;
            NodeImpl child = children[i10];
            if (child instanceof Text || !(child instanceof ElementImpl) || "HEAD".equalsIgnoreCase(tagName = child.getNodeName()) || "NOFRAMES".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName) || "SCRIPT".equalsIgnoreCase(tagName) || "NOSCRIPT".equalsIgnoreCase(tagName)) continue;
            if ("FRAMESET".equalsIgnoreCase(tagName)) {
                frameSet = child;
                break;
            }
            if (!this.hasSomeHtml((ElementImpl)child)) continue;
            return null;
        }
        return frameSet;
    }

    private boolean hasSomeHtml(ElementImpl element) {
        String tagName = element.getTagName();
        if ("HEAD".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName)) {
            return false;
        }
        NodeImpl[] children = element.getChildrenArray();
        if (children != null) {
            int length = children.length;
            for (int i10 = 0; i10 < length; ++i10) {
                String textContent;
                NodeImpl child = children[i10];
                if (!(child instanceof Text ? (textContent = ((Text)((Object)child)).getTextContent()) != null && !"".equals(textContent.trim()) : child instanceof ElementImpl && this.hasSomeHtml((ElementImpl)child))) continue;
                return false;
            }
        }
        return true;
    }

    public void expandSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlock;
        if (block != null) {
            block.setSelectionEnd(rpoint);
            block.repaint();
            this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, block.isSelectionAvailable()));
        }
    }

    public void resetSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlock;
        if (block != null) {
            block.setSelectionStart(rpoint);
            block.setSelectionEnd(rpoint);
            block.repaint();
        }
        this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, false));
    }

    public String getSelectionText() {
        HtmlBlockPanel block = this.htmlBlock;
        if (block == null) {
            return null;
        }
        return block.getSelectionText();
    }

    public Node getSelectionNode() {
        HtmlBlockPanel block = this.htmlBlock;
        if (block == null) {
            return null;
        }
        return block.getSelectionNode();
    }

    public boolean hasSelection() {
        HtmlBlockPanel block = this.htmlBlock;
        if (block == null) {
            return false;
        }
        return block.hasSelection();
    }

    public boolean copy() {
        HtmlBlockPanel block = this.htmlBlock;
        if (block != null) {
            return block.copy();
        }
        return false;
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.addListener(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotification(DocumentNotification notification) {
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(notification);
        }
        if (EventQueue.isDispatchThread()) {
            this.processNotifications();
        } else {
            this.notificationTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedRelayout(NodeImpl node) {
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(new DocumentNotification(2, node));
        }
        this.notificationTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        FrameSetPanel frameSetPanel;
        DocumentNotification[] notifsArray;
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            int size = notifs.size();
            if (size == 0) {
                return;
            }
            notifsArray = new DocumentNotification[size];
            notifsArray = notifs.toArray(notifsArray);
            notifs.clear();
        }
        int length = notifsArray.length;
        for (int i10 = 0; i10 < length; ++i10) {
            DocumentNotification dn2 = notifsArray[i10];
            if (!(dn2.node instanceof HTMLFrameSetElement) || this.htmlBlock == null || !this.resetIfFrameSet()) continue;
            return;
        }
        HtmlBlockPanel blockPanel = this.htmlBlock;
        if (blockPanel != null) {
            blockPanel.processDocumentNotifications(notifsArray);
        }
        if ((frameSetPanel = this.frameSetPanel) != null) {
            frameSetPanel.processDocumentNotifications(notifsArray);
        }
    }

    private class NotificationTimerAction
    implements ActionListener {
        private NotificationTimerAction() {
        }

        public void actionPerformed(ActionEvent e10) {
            HtmlPanel.this.processNotifications();
        }
    }

    private class LocalDocumentNotificationListener
    implements DocumentNotificationListener {
        private LocalDocumentNotificationListener() {
        }

        public void allInvalidated() {
            HtmlPanel.this.addNotification(new DocumentNotification(3, null));
        }

        public void invalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, node));
        }

        public void lookInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(0, node));
        }

        public void positionInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(1, node));
        }

        public void sizeInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(2, node));
        }

        public void externalScriptLoading(NodeImpl node) {
        }

        public void nodeLoaded(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, node));
        }
    }

    private class SelectionDispatch
    extends EventDispatch2 {
        private SelectionDispatch() {
        }

        protected void dispatchEvent(EventListener listener, EventObject event) {
            ((SelectionChangeListener)listener).selectionChanged((SelectionChangeEvent)event);
        }
    }
}

