/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RTableCell;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.VirtualCell;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderThreadState;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLTableCellElement;
import org.w3c.dom.html2.HTMLTableRowElement;

class TableMatrix {
    private static final NodeFilter COLUMNS_FILTER = new ColumnsFilter();
    private final ArrayList ROWS = new ArrayList();
    private final ArrayList ALL_CELLS = new ArrayList();
    private final ArrayList ROW_ELEMENTS = new ArrayList();
    private final HTMLElementImpl tableElement;
    private final UserAgentContext parserContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private final RElement relement;
    private final RenderableContainer container;
    private SizeInfo[] columnSizes;
    private SizeInfo[] rowSizes;
    private int tableWidth;
    private int tableHeight;
    private int hasOldStyleBorder;
    private int cellSpacingY;
    private int cellSpacingX;
    private int widthsOfExtras;
    private int heightsOfExtras;
    private HtmlLength tableWidthLength;

    public TableMatrix(HTMLElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer, RElement relement) {
        this.tableElement = element;
        this.parserContext = pcontext;
        this.rendererContext = rcontext;
        this.frameContext = frameContext;
        this.relement = relement;
        this.container = tableAsContainer;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getNumRows() {
        return this.ROWS.size();
    }

    public int getNumColumns() {
        return this.columnSizes.length;
    }

    public int getTableHeight() {
        return this.tableHeight;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void reset(Insets insets, int availWidth, int availHeight) {
        this.ROWS.clear();
        this.ALL_CELLS.clear();
        this.ROW_ELEMENTS.clear();
        String borderText = this.tableElement.getAttribute("border");
        int border = 0;
        if (borderText != null) {
            try {
                border = Integer.parseInt(borderText);
                if (border < 0) {
                    border = 0;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String cellSpacingText = this.tableElement.getAttribute("cellspacing");
        int cellSpacing = 1;
        if (cellSpacingText != null) {
            try {
                cellSpacing = Integer.parseInt(cellSpacingText);
                if (cellSpacing < 0) {
                    cellSpacing = 0;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.cellSpacingX = cellSpacing;
        this.cellSpacingY = cellSpacing;
        this.tableWidthLength = TableMatrix.getWidthLength(this.tableElement, availWidth);
        this.populateRows();
        this.adjustForCellSpans();
        this.createSizeArrays();
        SizeInfo[] columnSizes = this.columnSizes;
        int numCols = columnSizes.length;
        int widthsOfExtras = insets.left + insets.right + (numCols + 1) * cellSpacing;
        if (border > 0) {
            widthsOfExtras += numCols * 2;
        }
        this.widthsOfExtras = widthsOfExtras;
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = insets.top + insets.bottom + (numRows + 1) * cellSpacing;
        if (border > 0) {
            heightsOfExtras += numRows * 2;
        }
        this.heightsOfExtras = heightsOfExtras;
        this.hasOldStyleBorder = border > 0 ? 1 : 0;
    }

    public void build(int availWidth, int availHeight) {
        int hasBorder = this.hasOldStyleBorder;
        this.determineColumnSizes(hasBorder, this.cellSpacingX, this.cellSpacingY, availWidth);
        this.determineRowSizes(hasBorder, this.cellSpacingY, availHeight);
    }

    private final HTMLTableRowElementImpl getParentRow(HTMLTableCellElementImpl cellNode) {
        Node parentNode = cellNode.getParentNode();
        while (!(parentNode instanceof HTMLTableRowElementImpl)) {
            if (parentNode instanceof HTMLTableElementImpl) {
                return null;
            }
            parentNode = parentNode.getParentNode();
        }
        return (HTMLTableRowElementImpl)parentNode;
    }

    private static HtmlLength getWidthLength(HTMLElementImpl element, int availWidth) {
        try {
            String widthText;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            String string = widthText = props == null ? null : props.getWidth();
            if (widthText == null) {
                return new HtmlLength(element.getAttribute("width"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(widthText, element.getRenderState(), 0, availWidth));
        }
        catch (Exception err) {
            return null;
        }
    }

    private static HtmlLength getHeightLength(HTMLElementImpl element, int availHeight) {
        try {
            String heightText;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            String string = heightText = props == null ? null : props.getHeight();
            if (heightText == null) {
                return new HtmlLength(element.getAttribute("height"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(heightText, element.getRenderState(), 0, availHeight));
        }
        catch (Exception err) {
            return null;
        }
    }

    private void populateRows() {
        HTMLElementImpl te2 = this.tableElement;
        String cellPaddingText = te2.getAttribute("cellpadding");
        int cellPadding = 1;
        if (cellPaddingText != null) {
            try {
                cellPadding = Integer.parseInt(cellPaddingText);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ArrayList rows = this.ROWS;
        ArrayList rowElements = this.ROW_ELEMENTS;
        ArrayList allCells = this.ALL_CELLS;
        HashMap rowElementToRowArray = new HashMap(2);
        ArrayList cellList = te2.getDescendents(COLUMNS_FILTER);
        ArrayList<VirtualCell> currentNullRow = null;
        Iterator ci2 = cellList.iterator();
        while (ci2.hasNext()) {
            RTableCell ac2;
            ArrayList<VirtualCell> row;
            HTMLTableCellElementImpl columnNode = (HTMLTableCellElementImpl)ci2.next();
            HTMLTableRowElementImpl rowElement = this.getParentRow(columnNode);
            if (rowElement != null) {
                currentNullRow = null;
                row = (ArrayList<VirtualCell>)rowElementToRowArray.get(rowElement);
                if (row == null) {
                    row = new ArrayList<VirtualCell>();
                    rowElementToRowArray.put(rowElement, row);
                    rows.add(row);
                    rowElements.add(rowElement);
                }
            } else if (currentNullRow != null) {
                row = currentNullRow;
            } else {
                currentNullRow = row = new ArrayList<VirtualCell>();
                rows.add(row);
                rowElements.add(null);
            }
            if ((ac2 = (RTableCell)columnNode.getUINode()) == null) {
                ac2 = new RTableCell(columnNode, this.parserContext, this.rendererContext, this.frameContext, this.container);
                ac2.setParent(this.relement);
                columnNode.setUINode(ac2);
            }
            ac2.setCellPadding(cellPadding);
            VirtualCell vc2 = new VirtualCell(ac2, true);
            ac2.setTopLeftVirtualCell(vc2);
            row.add(vc2);
            allCells.add(ac2);
        }
    }

    private void adjustForCellSpans() {
        VirtualCell vc2;
        int c10;
        int numCols;
        ArrayList row;
        int r10;
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        for (r10 = 0; r10 < numRows; ++r10) {
            row = (ArrayList)rows.get(r10);
            numCols = row.size();
            for (c10 = 0; c10 < numCols; ++c10) {
                int rowspan;
                vc2 = (VirtualCell)row.get(c10);
                if (vc2 == null || !vc2.isTopLeft()) continue;
                RTableCell ac2 = vc2.getActualCell();
                int colspan = ac2.getColSpan();
                if (colspan < 1) {
                    colspan = 1;
                }
                if ((rowspan = ac2.getRowSpan()) < 1) {
                    rowspan = 1;
                }
                int targetRows = r10 + rowspan;
                while (rows.size() < targetRows) {
                    rows.add(new ArrayList());
                }
                numRows = rows.size();
                for (int y10 = 0; y10 < rowspan; ++y10) {
                    int xstart;
                    if (colspan <= 1 && y10 <= 0) continue;
                    int nr2 = r10 + y10;
                    ArrayList newRow = (ArrayList)rows.get(nr2);
                    for (int cc2 = xstart = y10 == 0 ? 1 : 0; cc2 < colspan; ++cc2) {
                        int nc2 = c10 + cc2;
                        while (newRow.size() < nc2) {
                            newRow.add(null);
                        }
                        newRow.add(nc2, new VirtualCell(ac2, false));
                    }
                    if (row != newRow) continue;
                    numCols = row.size();
                }
            }
        }
        for (r10 = 0; r10 < numRows; ++r10) {
            row = (ArrayList)rows.get(r10);
            numCols = row.size();
            for (c10 = 0; c10 < numCols; ++c10) {
                vc2 = (VirtualCell)row.get(c10);
                if (vc2 == null) continue;
                vc2.setColumn(c10);
                vc2.setRow(r10);
            }
        }
    }

    private void createSizeArrays() {
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        SizeInfo[] rowSizes = new SizeInfo[numRows];
        this.rowSizes = rowSizes;
        int numCols = 0;
        ArrayList rowElements = this.ROW_ELEMENTS;
        for (int i10 = 0; i10 < numRows; ++i10) {
            HTMLTableRowElement rowElement;
            SizeInfo rowSizeInfo;
            ArrayList row = (ArrayList)rows.get(i10);
            int rs2 = row.size();
            if (rs2 > numCols) {
                numCols = rs2;
            }
            rowSizes[i10] = rowSizeInfo = new SizeInfo();
            try {
                rowElement = (HTMLTableRowElement)rowElements.get(i10);
            }
            catch (IndexOutOfBoundsException iob2) {
                rowElement = null;
            }
            String rowHeightText = rowElement == null ? null : rowElement.getAttribute("height");
            HtmlLength rowHeightLength = null;
            if (rowHeightText != null) {
                try {
                    rowHeightLength = new HtmlLength(rowHeightText);
                }
                catch (Exception err) {
                    // empty catch block
                }
            }
            if (rowHeightLength != null) {
                rowSizeInfo.htmlLength = rowHeightLength;
                continue;
            }
            HtmlLength bestHeightLength = null;
            for (int x10 = 0; x10 < rs2; ++x10) {
                HtmlLength vcHeightLength;
                VirtualCell vc2 = (VirtualCell)row.get(x10);
                if (vc2 == null || (vcHeightLength = vc2.getHeightLength()) == null || !vcHeightLength.isPreferredOver(bestHeightLength)) continue;
                bestHeightLength = vcHeightLength;
            }
            rowSizeInfo.htmlLength = bestHeightLength;
        }
        SizeInfo[] columnSizes = new SizeInfo[numCols];
        this.columnSizes = columnSizes;
        for (int i11 = 0; i11 < numCols; ++i11) {
            HtmlLength vcWidthLength;
            RTableCell ac2;
            VirtualCell vc3;
            ArrayList row;
            int y10;
            HtmlLength bestWidthLength = null;
            for (y10 = 0; y10 < numRows; ++y10) {
                row = (ArrayList)rows.get(y10);
                try {
                    vc3 = (VirtualCell)row.get(i11);
                }
                catch (IndexOutOfBoundsException iob3) {
                    vc3 = null;
                }
                if (vc3 == null || (ac2 = vc3.getActualCell()).getColSpan() != 1 || (vcWidthLength = vc3.getWidthLength()) == null || !vcWidthLength.isPreferredOver(bestWidthLength)) continue;
                bestWidthLength = vcWidthLength;
            }
            if (bestWidthLength == null) {
                for (y10 = 0; y10 < numRows; ++y10) {
                    row = (ArrayList)rows.get(y10);
                    try {
                        vc3 = (VirtualCell)row.get(i11);
                    }
                    catch (IndexOutOfBoundsException iob4) {
                        vc3 = null;
                    }
                    if (vc3 == null || (ac2 = vc3.getActualCell()).getColSpan() <= 1 || (vcWidthLength = vc3.getWidthLength()) == null || !vcWidthLength.isPreferredOver(bestWidthLength)) continue;
                    bestWidthLength = vcWidthLength;
                }
            }
            SizeInfo colSizeInfo = new SizeInfo();
            colSizeInfo.htmlLength = bestWidthLength;
            columnSizes[i11] = colSizeInfo;
        }
    }

    private void determineColumnSizes(int hasBorder, int cellSpacingX, int cellSpacingY, int availWidth) {
        boolean widthKnown;
        int tableWidth;
        HtmlLength tableWidthLength = this.tableWidthLength;
        if (tableWidthLength != null) {
            tableWidth = tableWidthLength.getLength(availWidth);
            widthKnown = true;
        } else {
            tableWidth = availWidth;
            widthKnown = false;
        }
        SizeInfo[] columnSizes = this.columnSizes;
        int widthsOfExtras = this.widthsOfExtras;
        int cellAvailWidth = tableWidth - widthsOfExtras;
        if (cellAvailWidth < 0) {
            tableWidth += -cellAvailWidth;
            cellAvailWidth = 0;
        }
        this.determineTentativeSizes(columnSizes, widthsOfExtras, cellAvailWidth, widthKnown);
        this.preLayout(hasBorder, cellSpacingX, cellSpacingY, widthKnown);
        this.adjustForRenderWidths(columnSizes, hasBorder, cellSpacingX, widthKnown);
        this.adjustWidthsForExpectedMax(columnSizes, cellAvailWidth, widthKnown);
    }

    private void determineTentativeSizes(SizeInfo[] columnSizes, int widthsOfExtras, int cellAvailWidth, boolean setNoWidthColumns) {
        int totalWidthUsed;
        int difference;
        int numCols = columnSizes.length;
        int widthUsedByPercent = 0;
        for (int i10 = 0; i10 < numCols; ++i10) {
            SizeInfo colSizeInfo = columnSizes[i10];
            HtmlLength widthLength = colSizeInfo.htmlLength;
            if (widthLength == null || widthLength.getLengthType() != 2) continue;
            int actualSizeInt = widthLength.getLength(cellAvailWidth);
            widthUsedByPercent += actualSizeInt;
            colSizeInfo.actualSize = actualSizeInt;
        }
        int widthUsedByAbsolute = 0;
        int numNoWidthColumns = 0;
        for (int i11 = 0; i11 < numCols; ++i11) {
            SizeInfo colSizeInfo = columnSizes[i11];
            HtmlLength widthLength = colSizeInfo.htmlLength;
            if (widthLength != null && widthLength.getLengthType() != 2) {
                int actualSizeInt = widthLength.getRawValue();
                widthUsedByAbsolute += actualSizeInt;
                colSizeInfo.actualSize = actualSizeInt;
                continue;
            }
            if (widthLength != null) continue;
            ++numNoWidthColumns;
        }
        if (numNoWidthColumns == 0 && (difference = (totalWidthUsed = widthUsedByPercent + widthUsedByAbsolute) - cellAvailWidth) > 0) {
            int newActualSize;
            int oldActualSize;
            HtmlLength widthLength;
            SizeInfo sizeInfo;
            int i12;
            if (widthUsedByAbsolute > 0) {
                int expectedAbsoluteWidthTotal = widthUsedByAbsolute - difference;
                if (expectedAbsoluteWidthTotal < 0) {
                    expectedAbsoluteWidthTotal = 0;
                }
                double ratio = (double)expectedAbsoluteWidthTotal / (double)widthUsedByAbsolute;
                for (i12 = 0; i12 < numCols; ++i12) {
                    sizeInfo = columnSizes[i12];
                    widthLength = columnSizes[i12].htmlLength;
                    if (widthLength == null || widthLength.getLengthType() == 2) continue;
                    oldActualSize = sizeInfo.actualSize;
                    sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                    totalWidthUsed += newActualSize - oldActualSize;
                }
                difference = totalWidthUsed - cellAvailWidth;
            }
            if (difference > 0 && widthUsedByPercent > 0) {
                int expectedPercentWidthTotal = widthUsedByPercent - difference;
                if (expectedPercentWidthTotal < 0) {
                    expectedPercentWidthTotal = 0;
                }
                double ratio = (double)expectedPercentWidthTotal / (double)widthUsedByPercent;
                for (i12 = 0; i12 < numCols; ++i12) {
                    sizeInfo = columnSizes[i12];
                    widthLength = columnSizes[i12].htmlLength;
                    if (widthLength == null || widthLength.getLengthType() != 2) continue;
                    oldActualSize = sizeInfo.actualSize;
                    sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                    totalWidthUsed += newActualSize - oldActualSize;
                }
            }
        }
    }

    private void adjustForRenderWidths(SizeInfo[] columnSizes, int hasBorder, int cellSpacing, boolean tableWidthKnown) {
        int numCols = columnSizes.length;
        for (int i10 = 0; i10 < numCols; ++i10) {
            SizeInfo si2 = columnSizes[i10];
            if (si2.actualSize >= si2.layoutSize) continue;
            si2.actualSize = si2.layoutSize;
        }
    }

    private void layoutColumn(SizeInfo[] columnSizes, SizeInfo colSize, int col, int cellSpacingX, int hasBorder) {
        SizeInfo[] rowSizes = this.rowSizes;
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        int actualSize = colSize.actualSize;
        colSize.layoutSize = 0;
        int row = 0;
        while (row < numRows) {
            RTableCell ac2;
            ArrayList columns = (ArrayList)rows.get(row);
            VirtualCell vc2 = null;
            try {
                vc2 = (VirtualCell)columns.get(col);
            }
            catch (IndexOutOfBoundsException iob2) {
                vc2 = null;
            }
            RTableCell rTableCell = ac2 = vc2 == null ? null : vc2.getActualCell();
            if (ac2 != null) {
                int colSpan = ac2.getColSpan();
                if (colSpan > 1) {
                    int cellExtras;
                    int firstCol = ac2.getVirtualColumn();
                    int vcActualWidth = cellExtras = (colSpan - 1) * (cellSpacingX + 2 * hasBorder);
                    for (int x10 = 0; x10 < colSpan; ++x10) {
                        vcActualWidth += columnSizes[firstCol + x10].actualSize;
                    }
                    Dimension size = ac2.doCellLayout(vcActualWidth, 0, false, false);
                    int vcRenderWidth = size.width;
                    int denominator = vcActualWidth - cellExtras;
                    int newTentativeCellWidth = denominator > 0 ? actualSize * (vcRenderWidth - cellExtras) / denominator : (vcRenderWidth - cellExtras) / colSpan;
                    if (newTentativeCellWidth > colSize.layoutSize) {
                        colSize.layoutSize = newTentativeCellWidth;
                    }
                    int rowSpan = ac2.getRowSpan();
                    int vch = (size.height - (rowSpan - 1) * (this.cellSpacingY + 2 * hasBorder)) / rowSpan;
                    for (int y10 = 0; y10 < rowSpan; ++y10) {
                        if (rowSizes[row + y10].minSize >= vch) continue;
                        rowSizes[row + y10].minSize = vch;
                    }
                } else {
                    Dimension size = ac2.doCellLayout(actualSize, 0, false, false);
                    if (size.width > colSize.layoutSize) {
                        colSize.layoutSize = size.width;
                    }
                    int rowSpan = ac2.getRowSpan();
                    int vch = (size.height - (rowSpan - 1) * (this.cellSpacingY + 2 * hasBorder)) / rowSpan;
                    for (int y11 = 0; y11 < rowSpan; ++y11) {
                        if (rowSizes[row + y11].minSize >= vch) continue;
                        rowSizes[row + y11].minSize = vch;
                    }
                }
            }
            row = ac2 == null ? row + 1 : ac2.getVirtualRow() + ac2.getRowSpan();
        }
    }

    private int adjustWidthsForExpectedMax(SizeInfo[] columnSizes, int cellAvailWidth, boolean expand) {
        int hasBorder = this.hasOldStyleBorder;
        int cellSpacingX = this.cellSpacingX;
        int currentTotal = 0;
        int numCols = columnSizes.length;
        for (int i10 = 0; i10 < numCols; ++i10) {
            currentTotal += columnSizes[i10].actualSize;
        }
        int difference = currentTotal - cellAvailWidth;
        if (difference > 0 || difference < 0 && expand) {
            SizeInfo sizeInfo;
            int i11;
            int noWidthTotal = 0;
            int numNoWidth = 0;
            for (int i12 = 0; i12 < numCols; ++i12) {
                if (columnSizes[i12].htmlLength != null) continue;
                ++numNoWidth;
                noWidthTotal += columnSizes[i12].actualSize;
            }
            if (noWidthTotal > 0) {
                int expectedNoWidthTotal = noWidthTotal - difference;
                if (expectedNoWidthTotal < 0) {
                    expectedNoWidthTotal = 0;
                }
                double ratio = (double)expectedNoWidthTotal / (double)noWidthTotal;
                int noWidthCount = 0;
                for (i11 = 0; i11 < numCols; ++i11) {
                    int newActualSize;
                    sizeInfo = columnSizes[i11];
                    if (sizeInfo.htmlLength != null) continue;
                    int oldActualSize = sizeInfo.actualSize;
                    if (++noWidthCount == numNoWidth) {
                        int currentDiff = currentTotal - cellAvailWidth;
                        newActualSize = oldActualSize - currentDiff;
                        if (newActualSize < 0) {
                            newActualSize = 0;
                        }
                    } else {
                        newActualSize = (int)Math.round((double)oldActualSize * ratio);
                    }
                    sizeInfo.actualSize = newActualSize;
                    if (newActualSize < sizeInfo.layoutSize) {
                        this.layoutColumn(columnSizes, sizeInfo, i11, cellSpacingX, hasBorder);
                        if (newActualSize < sizeInfo.layoutSize) {
                            sizeInfo.actualSize = newActualSize = sizeInfo.layoutSize;
                        }
                    }
                    currentTotal += newActualSize - oldActualSize;
                }
                difference = currentTotal - cellAvailWidth;
            }
            if (difference > 0 || difference < 0 && expand) {
                int absoluteWidthTotal = 0;
                for (int i13 = 0; i13 < numCols; ++i13) {
                    HtmlLength widthLength = columnSizes[i13].htmlLength;
                    if (widthLength == null || widthLength.getLengthType() == 2) continue;
                    absoluteWidthTotal += columnSizes[i13].actualSize;
                }
                if (absoluteWidthTotal > 0) {
                    int expectedAbsoluteWidthTotal = absoluteWidthTotal - difference;
                    if (expectedAbsoluteWidthTotal < 0) {
                        expectedAbsoluteWidthTotal = 0;
                    }
                    double ratio = (double)expectedAbsoluteWidthTotal / (double)absoluteWidthTotal;
                    for (i11 = 0; i11 < numCols; ++i11) {
                        int newActualSize;
                        sizeInfo = columnSizes[i11];
                        HtmlLength widthLength = columnSizes[i11].htmlLength;
                        if (widthLength == null || widthLength.getLengthType() == 2) continue;
                        int oldActualSize = sizeInfo.actualSize;
                        sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                        if (newActualSize < sizeInfo.layoutSize) {
                            this.layoutColumn(columnSizes, sizeInfo, i11, cellSpacingX, hasBorder);
                            if (newActualSize < sizeInfo.layoutSize) {
                                sizeInfo.actualSize = newActualSize = sizeInfo.layoutSize;
                            }
                        }
                        currentTotal += newActualSize - oldActualSize;
                    }
                    difference = currentTotal - cellAvailWidth;
                }
                if (difference > 0 || difference < 0 && expand) {
                    int percentWidthTotal = 0;
                    for (int i14 = 0; i14 < numCols; ++i14) {
                        HtmlLength widthLength = columnSizes[i14].htmlLength;
                        if (widthLength == null || widthLength.getLengthType() != 2) continue;
                        percentWidthTotal += columnSizes[i14].actualSize;
                    }
                    if (percentWidthTotal > 0) {
                        int expectedPercentWidthTotal = percentWidthTotal - difference;
                        if (expectedPercentWidthTotal < 0) {
                            expectedPercentWidthTotal = 0;
                        }
                        double ratio = (double)expectedPercentWidthTotal / (double)percentWidthTotal;
                        for (int i15 = 0; i15 < numCols; ++i15) {
                            int newActualSize;
                            SizeInfo sizeInfo2 = columnSizes[i15];
                            HtmlLength widthLength = columnSizes[i15].htmlLength;
                            if (widthLength == null || widthLength.getLengthType() != 2) continue;
                            int oldActualSize = sizeInfo2.actualSize;
                            sizeInfo2.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                            if (newActualSize < sizeInfo2.layoutSize) {
                                this.layoutColumn(columnSizes, sizeInfo2, i15, cellSpacingX, hasBorder);
                                if (newActualSize < sizeInfo2.layoutSize) {
                                    sizeInfo2.actualSize = newActualSize = sizeInfo2.layoutSize;
                                }
                            }
                            currentTotal += newActualSize - oldActualSize;
                        }
                    }
                }
            }
        }
        return currentTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void preLayout(int hasBorder, int cellSpacingX, int cellSpacingY, boolean tableWidthKnown) {
        SizeInfo[] colSizes = this.columnSizes;
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        for (int i10 = 0; i10 < numRows; ++i10) {
            rowSizes[i10].minSize = 0;
        }
        int numCols = colSizes.length;
        for (int i11 = 0; i11 < numCols; ++i11) {
            colSizes[i11].layoutSize = 0;
        }
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        for (int i12 = 0; i12 < numCells; ++i12) {
            Dimension size;
            int cellsTotalWidth;
            int cellsUsedWidth;
            RTableCell cell = (RTableCell)allCells.get(i12);
            int col = cell.getVirtualColumn();
            int colSpan = cell.getColSpan();
            boolean widthDeclared = false;
            if (colSpan > 1) {
                cellsUsedWidth = 0;
                for (int x10 = 0; x10 < colSpan; ++x10) {
                    SizeInfo colSize = colSizes[col + x10];
                    if (colSize.htmlLength != null) {
                        widthDeclared = true;
                    }
                    cellsUsedWidth += colSize.actualSize;
                }
                cellsTotalWidth = cellsUsedWidth + (colSpan - 1) * (cellSpacingX + 2 * hasBorder);
            } else {
                SizeInfo colSize = colSizes[col];
                if (colSize.htmlLength != null) {
                    widthDeclared = true;
                }
                cellsUsedWidth = cellsTotalWidth = colSize.actualSize;
            }
            RenderThreadState state = RenderThreadState.getState();
            boolean prevOverrideNoWrap = state.overrideNoWrap;
            try {
                if (!prevOverrideNoWrap) {
                    state.overrideNoWrap = !widthDeclared;
                }
                size = cell.doCellLayout(cellsTotalWidth, 0, false, false);
            }
            finally {
                state.overrideNoWrap = prevOverrideNoWrap;
            }
            int cellLayoutWidth = size.width;
            if (colSpan > 1) {
                if (cellsUsedWidth > 0) {
                    double ratio = (double)cellLayoutWidth / (double)cellsUsedWidth;
                    for (int x11 = 0; x11 < colSpan; ++x11) {
                        SizeInfo si2 = colSizes[col + x11];
                        int newLayoutSize = (int)Math.round((double)si2.actualSize * ratio);
                        if (si2.layoutSize >= newLayoutSize) continue;
                        si2.layoutSize = newLayoutSize;
                    }
                } else {
                    int newLayoutSize = cellLayoutWidth / colSpan;
                    for (int x12 = 0; x12 < colSpan; ++x12) {
                        SizeInfo si3 = colSizes[col + x12];
                        if (si3.layoutSize >= newLayoutSize) continue;
                        si3.layoutSize = newLayoutSize;
                    }
                }
            } else {
                SizeInfo colSizeInfo = colSizes[col];
                if (colSizeInfo.layoutSize < cellLayoutWidth) {
                    colSizeInfo.layoutSize = cellLayoutWidth;
                }
            }
            int actualCellHeight = size.height;
            int row = cell.getVirtualRow();
            int rowSpan = cell.getRowSpan();
            if (rowSpan > 1) {
                int vch = (actualCellHeight - (rowSpan - 1) * (cellSpacingY + 2 * hasBorder)) / rowSpan;
                for (int y10 = 0; y10 < rowSpan; ++y10) {
                    if (rowSizes[row + y10].minSize >= vch) continue;
                    rowSizes[row + y10].minSize = vch;
                }
                continue;
            }
            if (rowSizes[row].minSize >= actualCellHeight) continue;
            rowSizes[row].minSize = actualCellHeight;
        }
    }

    private void determineRowSizes(int hasBorder, int cellSpacing, int availHeight) {
        HtmlLength tableHeightLength = TableMatrix.getHeightLength(this.tableElement, availHeight);
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        if (tableHeightLength != null) {
            int tableHeight = tableHeightLength.getLength(availHeight);
            this.determineRowSizesFixedTH(hasBorder, cellSpacing, availHeight, tableHeight);
        } else {
            int tableHeight = heightsOfExtras;
            for (int row = 0; row < numRows; ++row) {
                tableHeight += rowSizes[row].minSize;
            }
            this.determineRowSizesFlexibleTH(hasBorder, cellSpacing, availHeight);
        }
    }

    private void determineRowSizesFixedTH(int hasBorder, int cellSpacing, int availHeight, int tableHeight) {
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        int cellAvailHeight = tableHeight - heightsOfExtras;
        if (cellAvailHeight < 0) {
            cellAvailHeight = 0;
        }
        int heightUsedbyPercent = 0;
        int otherMinSize = 0;
        for (int i10 = 0; i10 < numRows; ++i10) {
            SizeInfo rowSizeInfo = rowSizes[i10];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() == 2) {
                int actualSizeInt = heightLength.getLength(cellAvailHeight);
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedbyPercent += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
                continue;
            }
            otherMinSize += rowSizeInfo.minSize;
        }
        if (heightUsedbyPercent + otherMinSize > cellAvailHeight) {
            double ratio = (double)(cellAvailHeight - otherMinSize) / (double)heightUsedbyPercent;
            for (int i11 = 0; i11 < numRows; ++i11) {
                SizeInfo rowSizeInfo = rowSizes[i11];
                HtmlLength heightLength = rowSizeInfo.htmlLength;
                if (heightLength == null || heightLength.getLengthType() != 2) continue;
                int actualSize = rowSizeInfo.actualSize;
                int prevActualSize = actualSize;
                int newActualSize = (int)Math.round((double)prevActualSize * ratio);
                if (newActualSize < rowSizeInfo.minSize) {
                    newActualSize = rowSizeInfo.minSize;
                }
                heightUsedbyPercent += newActualSize - prevActualSize;
                rowSizeInfo.actualSize = newActualSize;
            }
        }
        int heightUsedByAbsolute = 0;
        int noHeightMinSize = 0;
        int numNoHeightColumns = 0;
        for (int i12 = 0; i12 < numRows; ++i12) {
            SizeInfo rowSizeInfo = rowSizes[i12];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() != 2) {
                int actualSizeInt = heightLength.getRawValue();
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByAbsolute += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
                continue;
            }
            if (heightLength != null) continue;
            ++numNoHeightColumns;
            noHeightMinSize += rowSizeInfo.minSize;
        }
        if (heightUsedByAbsolute + heightUsedbyPercent + noHeightMinSize > cellAvailHeight) {
            double ratio = (double)(cellAvailHeight - noHeightMinSize - heightUsedbyPercent) / (double)heightUsedByAbsolute;
            for (int i13 = 0; i13 < numRows; ++i13) {
                SizeInfo rowSizeInfo = rowSizes[i13];
                HtmlLength heightLength = rowSizeInfo.htmlLength;
                if (heightLength == null || heightLength.getLengthType() == 2) continue;
                int actualSize = rowSizeInfo.actualSize;
                int prevActualSize = actualSize;
                int newActualSize = (int)Math.round((double)prevActualSize * ratio);
                if (newActualSize < rowSizeInfo.minSize) {
                    newActualSize = rowSizeInfo.minSize;
                }
                heightUsedByAbsolute += newActualSize - prevActualSize;
                rowSizeInfo.actualSize = newActualSize;
            }
        }
        int remainingHeight = cellAvailHeight - heightUsedByAbsolute - heightUsedbyPercent;
        int heightUsedByRemaining = 0;
        for (int i14 = 0; i14 < numRows; ++i14) {
            SizeInfo rowSizeInfo = rowSizes[i14];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null) continue;
            int actualSizeInt = remainingHeight / numNoHeightColumns;
            if (actualSizeInt < rowSizeInfo.minSize) {
                actualSizeInt = rowSizeInfo.minSize;
            }
            heightUsedByRemaining += actualSizeInt;
            rowSizeInfo.actualSize = actualSizeInt;
        }
        int totalUsed = heightUsedByAbsolute + heightUsedbyPercent + heightUsedByRemaining;
        if (totalUsed >= cellAvailHeight) {
            this.tableHeight = totalUsed + heightsOfExtras;
        } else {
            double ratio = (double)cellAvailHeight / (double)totalUsed;
            for (int i15 = 0; i15 < numRows; ++i15) {
                SizeInfo rowSizeInfo = rowSizes[i15];
                int actualSize = rowSizeInfo.actualSize;
                rowSizeInfo.actualSize = (int)Math.round((double)actualSize * ratio);
            }
            this.tableHeight = tableHeight;
        }
        this.finalRender(hasBorder, cellSpacing);
    }

    private void determineRowSizesFlexibleTH(int hasBorder, int cellSpacing, int availHeight) {
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        int heightUsedByAbsolute = 0;
        int percentSum = 0;
        for (int i10 = 0; i10 < numRows; ++i10) {
            SizeInfo rowSizeInfo = rowSizes[i10];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() == 1) {
                int actualSizeInt = heightLength.getRawValue();
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByAbsolute += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
                continue;
            }
            if (heightLength == null || heightLength.getLengthType() != 2) continue;
            percentSum += heightLength.getRawValue();
        }
        int heightUsedByNoSize = 0;
        for (int i11 = 0; i11 < numRows; ++i11) {
            SizeInfo rowSizeInfo = rowSizes[i11];
            HtmlLength widthLength = rowSizeInfo.htmlLength;
            if (widthLength != null) continue;
            int actualSizeInt = rowSizeInfo.minSize;
            heightUsedByNoSize += actualSizeInt;
            rowSizeInfo.actualSize = actualSizeInt;
        }
        int expectedTotalCellHeight = (int)Math.round((double)(heightUsedByAbsolute + heightUsedByNoSize) / (1.0 - (double)percentSum / 100.0));
        int heightUsedByPercent = 0;
        for (int i12 = 0; i12 < numRows; ++i12) {
            SizeInfo rowSizeInfo = rowSizes[i12];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength == null || heightLength.getLengthType() != 2) continue;
            int actualSizeInt = heightLength.getLength(expectedTotalCellHeight);
            if (actualSizeInt < rowSizeInfo.minSize) {
                actualSizeInt = rowSizeInfo.minSize;
            }
            heightUsedByPercent += actualSizeInt;
            rowSizeInfo.actualSize = actualSizeInt;
        }
        this.tableHeight = heightUsedByAbsolute + heightUsedByNoSize + heightUsedByPercent + heightsOfExtras;
        this.finalRender(hasBorder, cellSpacing);
    }

    private final void finalRender(int hasBorder, int cellSpacing) {
        ArrayList allCells = this.ALL_CELLS;
        SizeInfo[] colSizes = this.columnSizes;
        SizeInfo[] rowSizes = this.rowSizes;
        int numCells = allCells.size();
        for (int i10 = 0; i10 < numCells; ++i10) {
            int totalCellHeight;
            int totalCellWidth;
            RTableCell cell = (RTableCell)allCells.get(i10);
            int col = cell.getVirtualColumn();
            int colSpan = cell.getColSpan();
            if (colSpan > 1) {
                totalCellWidth = (colSpan - 1) * (cellSpacing + 2 * hasBorder);
                for (int x10 = 0; x10 < colSpan; ++x10) {
                    totalCellWidth += colSizes[col + x10].actualSize;
                }
            } else {
                totalCellWidth = colSizes[col].actualSize;
            }
            int row = cell.getVirtualRow();
            int rowSpan = cell.getRowSpan();
            if (rowSpan > 1) {
                totalCellHeight = (rowSpan - 1) * (cellSpacing + 2 * hasBorder);
                for (int y10 = 0; y10 < rowSpan; ++y10) {
                    totalCellHeight += rowSizes[row + y10].actualSize;
                }
            } else {
                totalCellHeight = rowSizes[row].actualSize;
            }
            Dimension size = cell.doCellLayout(totalCellWidth, totalCellHeight, true, true);
            if (size.width > totalCellWidth && colSpan == 1 && size.width > colSizes[col].actualSize) {
                colSizes[col].actualSize = size.width;
            }
            if (size.height <= totalCellHeight || rowSpan != 1 || size.height <= rowSizes[row].actualSize) continue;
            rowSizes[row].actualSize = size.height;
        }
    }

    public final void doLayout(Insets insets) {
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int yoffset = insets.top;
        int cellSpacingY = this.cellSpacingY;
        int hasBorder = this.hasOldStyleBorder;
        for (int i10 = 0; i10 < numRows; ++i10) {
            yoffset += cellSpacingY;
            SizeInfo rowSizeInfo = rowSizes[i10];
            rowSizeInfo.offset = yoffset += hasBorder;
            yoffset += rowSizeInfo.actualSize;
            yoffset += hasBorder;
        }
        this.tableHeight = yoffset + cellSpacingY + insets.bottom;
        SizeInfo[] colSizes = this.columnSizes;
        int numColumns = colSizes.length;
        int xoffset = insets.left;
        int cellSpacingX = this.cellSpacingX;
        for (int i11 = 0; i11 < numColumns; ++i11) {
            xoffset += cellSpacingX;
            SizeInfo colSizeInfo = colSizes[i11];
            colSizeInfo.offset = xoffset += hasBorder;
            xoffset += colSizeInfo.actualSize;
            xoffset += hasBorder;
        }
        this.tableWidth = xoffset + cellSpacingX + insets.right;
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        for (int i12 = 0; i12 < numCells; ++i12) {
            RTableCell cell = (RTableCell)allCells.get(i12);
            cell.setCellBounds(colSizes, rowSizes, hasBorder, cellSpacingX, cellSpacingY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g10, Dimension size) {
        RTableCell cell;
        int i10;
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        for (i10 = 0; i10 < numCells; ++i10) {
            cell = (RTableCell)allCells.get(i10);
            Graphics newG = g10.create(cell.x, cell.y, cell.width, cell.height);
            try {
                cell.paint(newG);
                continue;
            }
            finally {
                newG.dispose();
            }
        }
        if (this.hasOldStyleBorder > 0) {
            g10.setColor(Color.GRAY);
            for (i10 = 0; i10 < numCells; ++i10) {
                cell = (RTableCell)allCells.get(i10);
                int cx2 = cell.getX() - 1;
                int cy2 = cell.getY() - 1;
                int cwidth = cell.getWidth() + 1;
                int cheight = cell.getHeight() + 1;
                g10.drawRect(cx2, cy2, cwidth, cheight);
            }
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x10, int y10) {
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        for (int i10 = 0; i10 < numCells; ++i10) {
            RenderableSpot rp2;
            RTableCell cell = (RTableCell)allCells.get(i10);
            Rectangle bounds = cell.getBounds();
            if (!bounds.contains(x10, y10) || (rp2 = cell.getLowestRenderableSpot(x10 - bounds.x, y10 - bounds.y)) == null) continue;
            return rp2;
        }
        return null;
    }

    public Iterator getRenderables() {
        return this.ALL_CELLS.iterator();
    }

    public static class SizeInfo {
        public HtmlLength htmlLength;
        public int actualSize;
        public int layoutSize;
        public int minSize;
        public int offset;
    }

    private static class ColumnsFilter
    implements NodeFilter {
        private ColumnsFilter() {
        }

        public final boolean accept(Node node) {
            return node instanceof HTMLTableCellElement;
        }
    }

    private static class RowsFilter
    implements NodeFilter {
        private RowsFilter() {
        }

        public final boolean accept(Node node) {
            return node instanceof HTMLTableRowElement;
        }
    }
}

