/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSUtilities {
    private static final Logger logger = null;

    private CSSUtilities() {
    }

    public static String preProcessCss(String text) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(text));
            StringBuffer sb2 = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("//")) continue;
                sb2.append(line);
                sb2.append("\r\n");
            }
            return sb2.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
    }

    public static InputSource getCssInputSourceForStyleSheet(String text) {
        StringReader reader = new StringReader(text);
        InputSource is2 = new InputSource(reader);
        return is2;
    }

    public static CSSStyleSheet parse(String href, HTMLDocumentImpl doc2, String baseUri, boolean considerDoubleSlashComments) throws MalformedURLException {
        UserAgentContext bcontext = doc2.getUserAgentContext();
        final HttpRequest request = bcontext.createHttpRequest();
        URL baseURL = new URL(baseUri);
        URL scriptURL = Urls.createURL(baseURL, href);
        final String scriptURI = scriptURL == null ? href : scriptURL.toExternalForm();
        SecurityManager sm2 = System.getSecurityManager();
        if (sm2 == null) {
            request.open("GET", scriptURI, false);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    request.open("GET", scriptURI, false);
                    return null;
                }
            });
        }
        int status = request.getStatus();
        if (status != 200 && status != 0) {
            return null;
        }
        String text = request.getResponseText();
        if (text != null && !"".equals(text)) {
            String processedText = considerDoubleSlashComments ? CSSUtilities.preProcessCss(text) : text;
            CSSOMParser parser = new CSSOMParser();
            InputSource is2 = CSSUtilities.getCssInputSourceForStyleSheet(processedText);
            is2.setURI(scriptURI);
            try {
                CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(is2);
                sheet.setHref(scriptURI);
                return sheet;
            }
            catch (Throwable err) {
                return null;
            }
        }
        return null;
    }

    public static boolean matchesMedia(String mediaValues, HtmlRendererContext rcontext) {
        if (mediaValues == null || mediaValues.length() == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(mediaValues, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            String mediaName = Strings.trimForAlphaNumDash(token);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesMedia(MediaList mediaList, HtmlRendererContext rcontext) {
        if (mediaList == null) {
            return true;
        }
        int length = mediaList.getLength();
        if (length == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        for (int i10 = 0; i10 < length; ++i10) {
            String mediaName = mediaList.item(i10);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }
}

