/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.FontInfo;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.html.style.WordInfo;
import org.lobobrowser.util.gui.ColorFactory;
import org.lobobrowser.util.gui.FontFactory;

public class StyleSheetRenderState
implements RenderState {
    private static final FontFactory FONT_FACTORY = FontFactory.getInstance();
    private static final String DEFAULT_FONT_FAMILY = "Times New Roman";
    private static final Font DEFAULT_FONT = FONT_FACTORY.getFont("Times New Roman", null, null, null, 14.0f);
    protected static final Insets INVALID_INSETS = new Insets(0, 0, 0, 0);
    protected static final BackgroundInfo INVALID_BACKGROUND_INFO = new BackgroundInfo();
    protected static final Color INVALID_COLOR = new Color(100, 0, 100);
    protected final HTMLElementImpl element;
    protected final RenderState prevRenderState;
    private Font iFont;
    private FontMetrics iFontMetrics;
    private Color iColor;
    private Color iBackgroundColor = INVALID_COLOR;
    private Color iTextBackgroundColor = INVALID_COLOR;
    private Color iOverlayColor = INVALID_COLOR;
    private BackgroundInfo iBackgroundInfo = INVALID_BACKGROUND_INFO;
    private int iTextDecoration = -1;
    private int iBlankWidth = -1;
    private boolean iHighlight;
    private Integer iDisplay;
    Map iWordInfoMap = null;
    private int alignXPercent = -1;
    private Map counters = null;
    private String iTextIndentText = null;
    protected Integer iWhiteSpace;
    private Insets marginInsets = INVALID_INSETS;
    private Insets paddingInsets = INVALID_INSETS;

    public StyleSheetRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        this.prevRenderState = prevRenderState;
        this.element = element;
    }

    protected int getDefaultDisplay() {
        return 1;
    }

    public int getDisplay() {
        String displayTextTL;
        String displayText;
        Integer d10 = this.iDisplay;
        if (d10 != null) {
            return d10;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = displayText = props == null ? null : props.getDisplay();
        int displayInt = displayText != null ? ("block".equals(displayTextTL = displayText.toLowerCase()) ? 2 : ("inline".equals(displayTextTL) ? 1 : ("none".equals(displayTextTL) ? 0 : ("list-item".equals(displayTextTL) ? 3 : ("table".equals(displayTextTL) ? 6 : ("table-cell".equals(displayTextTL) ? 5 : ("table-row".equals(displayTextTL) ? 4 : this.getDefaultDisplay()))))))) : this.getDefaultDisplay();
        this.iDisplay = d10 = new Integer(displayInt);
        return displayInt;
    }

    public RenderState getPreviousRenderState() {
        return this.prevRenderState;
    }

    public int getFontBase() {
        RenderState prs = this.prevRenderState;
        return prs == null ? 3 : prs.getFontBase();
    }

    public void repaint() {
    }

    protected final CSS2PropertiesImpl getCssProperties() {
        HTMLElementImpl element = this.element;
        return element == null ? null : element.getCurrentStyle();
    }

    public StyleSheetRenderState() {
        this.element = null;
        this.prevRenderState = null;
    }

    public void invalidate() {
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
        this.iFont = null;
        this.iFontMetrics = null;
        this.iColor = null;
        this.iTextDecoration = -1;
        this.iBlankWidth = -1;
        this.alignXPercent = -1;
        this.iBackgroundColor = INVALID_COLOR;
        this.iTextBackgroundColor = INVALID_COLOR;
        this.iOverlayColor = INVALID_COLOR;
        this.iBackgroundInfo = INVALID_BACKGROUND_INFO;
        this.iDisplay = null;
        this.iTextIndentText = null;
        this.iWhiteSpace = null;
        this.marginInsets = INVALID_INSETS;
        this.paddingInsets = INVALID_INSETS;
    }

    public Font getFont() {
        int fstyle;
        String newFontWeight;
        String fontSpec;
        Font f10 = this.iFont;
        if (f10 != null) {
            return f10;
        }
        CSS2PropertiesImpl style = this.getCssProperties();
        RenderState prs = this.prevRenderState;
        if (style == null) {
            if (prs != null) {
                this.iFont = f10 = prs.getFont();
                return f10;
            }
            this.iFont = f10 = DEFAULT_FONT;
            return f10;
        }
        Float fontSize = null;
        String fontStyle = null;
        String fontVariant = null;
        String fontWeight = null;
        String fontFamily = null;
        String string = fontSpec = style == null ? null : style.getFont();
        if (fontSpec != null) {
            FontInfo fontInfo = HtmlValues.createFontInfo(fontSpec, this.prevRenderState);
            fontSize = fontInfo.fontSize;
            fontStyle = fontInfo.fontStyle;
            fontVariant = fontInfo.fontVariant;
            fontWeight = fontInfo.fontWeight;
            fontFamily = fontInfo.fontFamily;
        }
        String newFontSize = style == null ? null : style.getFontSize();
        String newFontFamily = style == null ? null : style.getFontFamily();
        String newFontStyle = style == null ? null : style.getFontStyle();
        String newFontVariant = style == null ? null : style.getFontVariant();
        String string2 = newFontWeight = style == null ? null : style.getFontWeight();
        if (fontSpec == null && newFontSize == null && newFontWeight == null && newFontStyle == null && newFontFamily == null && newFontVariant == null) {
            if (prs != null) {
                this.iFont = f10 = prs.getFont();
                return f10;
            }
            this.iFont = f10 = DEFAULT_FONT;
            return f10;
        }
        if (newFontSize != null) {
            try {
                fontSize = new Float(HtmlValues.getFontSize(newFontSize, prs));
            }
            catch (Exception err) {
                fontSize = HtmlValues.DEFAULT_FONT_SIZE_BOX;
            }
        } else if (fontSize == null) {
            fontSize = prs != null ? new Float(prs.getFont().getSize()) : HtmlValues.DEFAULT_FONT_SIZE_BOX;
        }
        if (newFontFamily != null) {
            fontFamily = newFontFamily;
        } else if (fontFamily == null && prs != null) {
            fontFamily = prs.getFont().getFamily();
        }
        if (fontFamily == null) {
            fontFamily = DEFAULT_FONT_FAMILY;
        }
        if (newFontStyle != null) {
            fontStyle = newFontStyle;
        } else if (fontStyle == null && prs != null && ((fstyle = prs.getFont().getStyle()) & 2) != 0) {
            fontStyle = "italic";
        }
        if (newFontVariant != null) {
            fontVariant = newFontVariant;
        } else if (prs != null) {
            // empty if block
        }
        if (newFontWeight != null) {
            fontWeight = newFontWeight;
        } else if (fontWeight == null && prs != null && ((fstyle = prs.getFont().getStyle()) & 1) != 0) {
            fontWeight = "bold";
        }
        this.iFont = f10 = FONT_FACTORY.getFont(fontFamily, fontStyle, fontVariant, fontWeight, fontSize.floatValue());
        return f10;
    }

    public Color getColor() {
        String colorValue;
        Color c10 = this.iColor;
        if (c10 != null) {
            return c10;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = colorValue = props == null ? null : props.getColor();
        if (colorValue == null || "".equals(colorValue)) {
            RenderState prs = this.prevRenderState;
            if (prs != null) {
                this.iColor = c10 = prs.getColor();
                return c10;
            }
            colorValue = "black";
        }
        this.iColor = c10 = ColorFactory.getInstance().getColor(colorValue);
        return c10;
    }

    public Color getBackgroundColor() {
        Color ancestorColor;
        RenderState prs;
        Color localColor;
        Color c10 = this.iBackgroundColor;
        if (c10 != INVALID_COLOR) {
            return c10;
        }
        BackgroundInfo binfo = this.getBackgroundInfo();
        Color color = localColor = binfo == null ? null : binfo.backgroundColor;
        if (localColor == null && this.getDisplay() == 1 && (prs = this.prevRenderState) != null && (ancestorColor = prs.getBackgroundColor()) != null) {
            this.iBackgroundColor = ancestorColor;
            return ancestorColor;
        }
        this.iBackgroundColor = localColor;
        return localColor;
    }

    public Color getTextBackgroundColor() {
        Color localColor;
        Color c10 = this.iTextBackgroundColor;
        if (c10 != INVALID_COLOR) {
            return c10;
        }
        if (this.getDisplay() != 1) {
            localColor = null;
        } else {
            Color ancestorColor;
            RenderState prs;
            BackgroundInfo binfo = this.getBackgroundInfo();
            Color color = localColor = binfo == null ? null : binfo.backgroundColor;
            if (localColor == null && (prs = this.prevRenderState) != null && (ancestorColor = prs.getTextBackgroundColor()) != null) {
                this.iTextBackgroundColor = ancestorColor;
                return ancestorColor;
            }
        }
        this.iTextBackgroundColor = localColor;
        return localColor;
    }

    public Color getOverlayColor() {
        String colorValue;
        Color c10 = this.iOverlayColor;
        if (c10 != INVALID_COLOR) {
            return c10;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = colorValue = props == null ? null : props.getOverlayColor();
        if (colorValue == null || colorValue.length() == 0) {
            RenderState prs = this.prevRenderState;
            if (prs != null) {
                this.iOverlayColor = c10 = prs.getOverlayColor();
                return c10;
            }
            colorValue = null;
        }
        this.iOverlayColor = c10 = colorValue == null ? null : ColorFactory.getInstance().getColor(colorValue);
        return c10;
    }

    public int getTextDecorationMask() {
        RenderState prs;
        String tdText;
        int td2 = this.iTextDecoration;
        if (td2 != -1) {
            return td2;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = tdText = props == null ? null : props.getTextDecoration();
        if (tdText == null && (prs = this.prevRenderState) != null) {
            this.iTextDecoration = td2 = prs.getTextDecorationMask();
            return td2;
        }
        td2 = 0;
        if (tdText != null) {
            StringTokenizer tok = new StringTokenizer(tdText.toLowerCase(), ", \t\n\r");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if ("none".equals(token)) continue;
                if ("underline".equals(token)) {
                    td2 |= 1;
                    continue;
                }
                if ("line-through".equals(token)) {
                    td2 |= 4;
                    continue;
                }
                if ("blink".equals(token)) {
                    td2 |= 8;
                    continue;
                }
                if (!"overline".equals(token)) continue;
                td2 |= 2;
            }
        }
        this.iTextDecoration = td2;
        return td2;
    }

    public final FontMetrics getFontMetrics() {
        FontMetrics fm2 = this.iFontMetrics;
        if (fm2 == null) {
            this.iFontMetrics = fm2 = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fm2;
    }

    public int getBlankWidth() {
        int bw2 = this.iBlankWidth;
        if (bw2 == -1) {
            this.iBlankWidth = bw2 = this.getFontMetrics().charWidth(' ');
        }
        return bw2;
    }

    public boolean isHighlight() {
        return this.iHighlight;
    }

    public void setHighlight(boolean highlight) {
        this.iHighlight = highlight;
    }

    public final WordInfo getWordInfo(String word) {
        FontMetrics fm2;
        WordInfo wi2;
        HashMap<String, WordInfo> map = this.iWordInfoMap;
        if (map == null) {
            this.iWordInfoMap = map = new HashMap<String, WordInfo>(1);
        }
        if ((wi2 = (WordInfo)map.get(word)) != null) {
            return wi2;
        }
        wi2 = new WordInfo();
        wi2.fontMetrics = fm2 = this.getFontMetrics();
        wi2.ascentPlusLeading = fm2.getAscent() + fm2.getLeading();
        wi2.descent = fm2.getDescent();
        wi2.height = fm2.getHeight();
        wi2.width = fm2.stringWidth(word);
        map.put(word, wi2);
        return wi2;
    }

    public int getAlignXPercent() {
        HTMLElementImpl element;
        String textAlign;
        int axp = this.alignXPercent;
        if (axp != -1) {
            return axp;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = textAlign = props == null ? null : props.getTextAlign();
        if (!(textAlign != null && textAlign.length() != 0 || (element = this.element) == null || (textAlign = element.getAttribute("align")) != null && textAlign.length() != 0)) {
            RenderState prs = this.prevRenderState;
            if (prs != null) {
                return prs.getAlignXPercent();
            }
            textAlign = null;
        }
        axp = textAlign == null ? 0 : ("center".equalsIgnoreCase(textAlign) ? 50 : ("right".equalsIgnoreCase(textAlign) ? 100 : 0));
        this.alignXPercent = axp;
        return axp;
    }

    public int getAlignYPercent() {
        return 0;
    }

    public int getCount(String counter, int nesting) {
        RenderState prs = this.prevRenderState;
        if (prs != null) {
            return prs.getCount(counter, nesting);
        }
        Map counters = this.counters;
        if (counters == null) {
            return 0;
        }
        ArrayList counterArray = (ArrayList)counters.get(counter);
        if (nesting < 0 || nesting >= counterArray.size()) {
            return 0;
        }
        Integer integer = (Integer)counterArray.get(nesting);
        return integer == null ? 0 : integer;
    }

    public void resetCount(String counter, int nesting, int value) {
        HashMap counters;
        RenderState prs = this.prevRenderState;
        if (prs != null) {
            prs.resetCount(counter, nesting, value);
        }
        if ((counters = this.counters) == null) {
            this.counters = counters = new HashMap(2);
            counters.put(counter, new ArrayList(0));
        }
        ArrayList counterArray = (ArrayList)counters.get(counter);
        while (counterArray.size() <= nesting) {
            counterArray.add(null);
        }
        counterArray.set(nesting, new Integer(value));
    }

    public int incrementCount(String counter, int nesting) {
        RenderState prs = this.prevRenderState;
        if (prs != null) {
            return prs.incrementCount(counter, nesting);
        }
        HashMap counters = this.counters;
        if (counters == null) {
            this.counters = counters = new HashMap(2);
            counters.put(counter, new ArrayList(0));
        }
        ArrayList counterArray = (ArrayList)counters.get(counter);
        while (counterArray.size() <= nesting) {
            counterArray.add(null);
        }
        Integer integer = (Integer)counterArray.get(nesting);
        int prevValue = integer == null ? 0 : integer;
        counterArray.set(nesting, new Integer(prevValue + 1));
        return prevValue;
    }

    public BackgroundInfo getBackgroundInfo() {
        BackgroundInfo binfo = this.iBackgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = null;
        CSS2PropertiesImpl props = this.getCssProperties();
        if (props != null) {
            String backgroundPositionText;
            String backgroundRepeatText;
            String backgroundImage;
            String backgroundImageText;
            String backgroundColorText;
            String background = props.getBackground();
            if (background != null) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                this.applyBackground(binfo, background);
            }
            if ((backgroundColorText = props.getBackgroundColor()) != null) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundColor = ColorFactory.getInstance().getColor(backgroundColorText);
            }
            if ((backgroundImageText = props.getBackgroundImage()) != null && (backgroundImage = HtmlValues.getURIFromStyleValue(backgroundImageText)) != null) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundImage = backgroundImage;
            }
            if ((backgroundRepeatText = props.getBackgroundRepeat()) != null) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                this.applyBackgroundRepeat(binfo, backgroundRepeatText);
            }
            if ((backgroundPositionText = props.getBackgroundPosition()) != null) {
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                this.applyBackgroundPosition(binfo, backgroundPositionText);
            }
        }
        this.iBackgroundInfo = binfo;
        return binfo;
    }

    public String getTextIndentText() {
        String tiText = this.iTextIndentText;
        if (tiText != null) {
            return tiText;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = tiText = props == null ? null : props.getTextIndent();
        if (tiText == null) {
            RenderState prs = this.prevRenderState;
            if (prs != null) {
                String parentText;
                this.iTextIndentText = parentText = prs.getTextIndentText();
                return parentText;
            }
            tiText = "";
        }
        return tiText;
    }

    public int getTextIndent(int availSize) {
        String tiText = this.getTextIndentText();
        if (tiText.length() == 0) {
            return 0;
        }
        return HtmlValues.getPixelSize(tiText, this, 0, availSize);
    }

    public int getWhiteSpace() {
        String whiteSpaceTextTL;
        RenderState prs;
        HTMLElementImpl element;
        String whiteSpaceText;
        if (RenderThreadState.getState().overrideNoWrap) {
            return 2;
        }
        Integer ws2 = this.iWhiteSpace;
        if (ws2 != null) {
            return ws2;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        String string = whiteSpaceText = props == null ? null : props.getWhiteSpace();
        int wsValue = whiteSpaceText == null ? ((element = this.element) != null && element.getAttributeAsBoolean("nowrap") ? 2 : ((prs = this.prevRenderState) != null ? prs.getWhiteSpace() : 0)) : ("nowrap".equals(whiteSpaceTextTL = whiteSpaceText.toLowerCase()) ? 2 : ("pre".equals(whiteSpaceTextTL) ? 1 : 0));
        this.iWhiteSpace = new Integer(wsValue);
        return wsValue;
    }

    public Insets getMarginInsets() {
        Insets mi2 = this.marginInsets;
        if (mi2 != INVALID_INSETS) {
            return mi2;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        mi2 = props == null ? null : HtmlValues.getMarginInsets(props, this);
        this.marginInsets = mi2;
        return mi2;
    }

    public Insets getPaddingInsets() {
        Insets mi2 = this.paddingInsets;
        if (mi2 != INVALID_INSETS) {
            return mi2;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        if (props == null) {
            mi2 = null;
        } else {
            this.paddingInsets = mi2 = HtmlValues.getPaddingInsets(props, this);
        }
        return mi2;
    }

    private void applyBackgroundHorizontalPositon(BackgroundInfo binfo, String xposition) {
        if (xposition.endsWith("%")) {
            binfo.backgroundXPositionAbsolute = false;
            try {
                binfo.backgroundXPosition = (int)Double.parseDouble(xposition.substring(0, xposition.length() - 1).trim());
            }
            catch (NumberFormatException nfe) {
                binfo.backgroundXPosition = 0;
            }
        } else if ("center".equalsIgnoreCase(xposition)) {
            binfo.backgroundXPositionAbsolute = false;
            binfo.backgroundXPosition = 50;
        } else if ("right".equalsIgnoreCase(xposition)) {
            binfo.backgroundXPositionAbsolute = false;
            binfo.backgroundXPosition = 100;
        } else if ("left".equalsIgnoreCase(xposition)) {
            binfo.backgroundXPositionAbsolute = false;
            binfo.backgroundXPosition = 0;
        } else {
            binfo.backgroundXPositionAbsolute = true;
            binfo.backgroundXPosition = HtmlValues.getPixelSize(xposition, this, 0);
        }
    }

    private void applyBackgroundVerticalPosition(BackgroundInfo binfo, String yposition) {
        if (yposition.endsWith("%")) {
            binfo.backgroundYPositionAbsolute = false;
            try {
                binfo.backgroundYPosition = (int)Double.parseDouble(yposition.substring(0, yposition.length() - 1).trim());
            }
            catch (NumberFormatException nfe) {
                binfo.backgroundYPosition = 0;
            }
        } else if ("center".equalsIgnoreCase(yposition)) {
            binfo.backgroundYPositionAbsolute = false;
            binfo.backgroundYPosition = 50;
        } else if ("bottom".equalsIgnoreCase(yposition)) {
            binfo.backgroundYPositionAbsolute = false;
            binfo.backgroundYPosition = 100;
        } else if ("top".equalsIgnoreCase(yposition)) {
            binfo.backgroundYPositionAbsolute = false;
            binfo.backgroundYPosition = 0;
        } else {
            binfo.backgroundYPositionAbsolute = true;
            binfo.backgroundYPosition = HtmlValues.getPixelSize(yposition, this, 0);
        }
    }

    private void applyBackgroundPosition(BackgroundInfo binfo, String position) {
        StringTokenizer tok = new StringTokenizer(position, " \t\r\n");
        if (tok.hasMoreTokens()) {
            String xposition = tok.nextToken();
            this.applyBackgroundHorizontalPositon(binfo, xposition);
            if (tok.hasMoreTokens()) {
                String yposition = tok.nextToken();
                this.applyBackgroundVerticalPosition(binfo, yposition);
            }
        }
    }

    private void applyBackground(BackgroundInfo binfo, String background) {
        String[] tokens = HtmlValues.splitCssValue(background);
        boolean hasXPosition = false;
        for (int i10 = 0; i10 < tokens.length; ++i10) {
            String token = tokens[i10];
            if (ColorFactory.getInstance().isColor(token)) {
                binfo.backgroundColor = ColorFactory.getInstance().getColor(token);
                continue;
            }
            if (HtmlValues.isUrl(token)) {
                binfo.backgroundImage = HtmlValues.getURIFromStyleValue(token);
                continue;
            }
            if (this.isBackgroundRepeat(token)) {
                this.applyBackgroundRepeat(binfo, token);
                continue;
            }
            if (!this.isBackgroundPosition(token)) continue;
            if (hasXPosition) {
                this.applyBackgroundVerticalPosition(binfo, token);
                continue;
            }
            hasXPosition = true;
            this.applyBackgroundHorizontalPositon(binfo, token);
        }
    }

    private boolean isBackgroundPosition(String token) {
        return HtmlValues.isLength(token) || token.endsWith("%") || token.equalsIgnoreCase("top") || token.equalsIgnoreCase("center") || token.equalsIgnoreCase("bottom") || token.equalsIgnoreCase("left") || token.equalsIgnoreCase("right");
    }

    private boolean isBackgroundRepeat(String repeat) {
        String repeatTL = repeat.toLowerCase();
        return repeatTL.indexOf("repeat") != -1;
    }

    private void applyBackgroundRepeat(BackgroundInfo binfo, String backgroundRepeatText) {
        String brtl = backgroundRepeatText.toLowerCase();
        if ("repeat".equals(brtl)) {
            binfo.backgroundRepeat = 0;
        } else if ("repeat-x".equals(brtl)) {
            binfo.backgroundRepeat = 2;
        } else if ("repeat-y".equals(brtl)) {
            binfo.backgroundRepeat = 3;
        } else if ("no-repeat".equals(brtl)) {
            binfo.backgroundRepeat = 1;
        }
    }

    public String toString() {
        return "StyleSheetRenderState[font=" + this.getFont() + ",textDecoration=" + this.getTextDecorationMask() + "]";
    }
}

