/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageRoutedNotifier;
import flex.messaging.client.FlexClient;
import flex.messaging.io.TypeMarshallingContext;
import java.security.Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlexContext {
    private static ThreadLocal flexClients = new ThreadLocal();
    private static ThreadLocal sessions = new ThreadLocal();
    private static ThreadLocal messageBrokers = new ThreadLocal();
    private static ThreadLocal responses = new ThreadLocal();
    private static ThreadLocal requests = new ThreadLocal();
    private static ThreadLocal tunnelRequests = new ThreadLocal();
    private static ThreadLocal servletConfigs = new ThreadLocal();
    private static ThreadLocal messageFromPeer = new ThreadLocal();
    private static ThreadLocal messageRoutedNotifiers = new ThreadLocal();
    private static ServletConfig lastGoodServletConfig;

    private FlexContext() {
    }

    public static void setThreadLocalObjects(FlexClient flexClient, FlexSession session, MessageBroker broker, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        flexClients.set(flexClient);
        sessions.set(session);
        messageBrokers.set(broker);
        requests.set(request);
        responses.set(response);
        servletConfigs.set(servletConfig);
        messageFromPeer.set(Boolean.FALSE);
        if (servletConfig != null) {
            lastGoodServletConfig = servletConfig;
        }
    }

    public static void setThreadLocalObjects(FlexClient flexClient, FlexSession session, MessageBroker broker) {
        FlexContext.setThreadLocalObjects(flexClient, session, broker, null, null, null);
    }

    public static void clearThreadLocalObjects() {
        MessageBroker mb2 = (MessageBroker)messageBrokers.get();
        if (mb2 != null) {
            mb2.clearSystemSettingsThreadLocal();
        }
        sessions.remove();
        messageBrokers.remove();
        requests.remove();
        responses.remove();
        tunnelRequests.remove();
        servletConfigs.remove();
        messageFromPeer.remove();
        TypeMarshallingContext.clearThreadLocalObjects();
    }

    public static HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)requests.get();
    }

    public static void setThreadLocalHttpRequest(HttpServletRequest value) {
        if (value == null) {
            requests.remove();
        } else {
            requests.set(value);
        }
    }

    public static HttpServletResponse getHttpResponse() {
        return (HttpServletResponse)responses.get();
    }

    public static void setThreadLocalHttpResponse(HttpServletResponse value) {
        if (value == null) {
            responses.remove();
        } else {
            responses.set(value);
        }
    }

    public static HttpServletRequest getTunnelHttpRequest() {
        return (HttpServletRequest)tunnelRequests.get();
    }

    public static void setThreadLocalTunnelHttpRequest(HttpServletRequest value) {
        if (value == null) {
            tunnelRequests.remove();
        } else {
            tunnelRequests.set(value);
        }
    }

    public static ServletConfig getServletConfig() {
        if (servletConfigs.get() != null) {
            return (ServletConfig)servletConfigs.get();
        }
        return lastGoodServletConfig;
    }

    public static void setThreadLocalServletConfig(ServletConfig value) {
        if (value == null) {
            servletConfigs.remove();
        } else {
            servletConfigs.set(value);
        }
    }

    public static ServletContext getServletContext() {
        return FlexContext.getServletConfig().getServletContext();
    }

    public static FlexClient getFlexClient() {
        return (FlexClient)flexClients.get();
    }

    public static void setThreadLocalFlexClient(FlexClient flexClient) {
        if (flexClient == null) {
            flexClients.remove();
        } else {
            flexClients.set(flexClient);
        }
    }

    public static FlexSession getFlexSession() {
        return (FlexSession)sessions.get();
    }

    public static void setThreadLocalSession(FlexSession session) {
        if (session == null) {
            sessions.remove();
        } else {
            sessions.set(session);
        }
    }

    public static MessageBroker getMessageBroker() {
        return (MessageBroker)messageBrokers.get();
    }

    public static void setThreadLocalMessageBroker(MessageBroker value) {
        if (value == null) {
            messageBrokers.remove();
        } else {
            messageBrokers.set(value);
        }
    }

    public static MessageRoutedNotifier getMessageRoutedNotifier() {
        return (MessageRoutedNotifier)messageRoutedNotifiers.get();
    }

    public static void setMessageRoutedNotifier(MessageRoutedNotifier value) {
        if (value == null) {
            messageRoutedNotifiers.remove();
        } else {
            messageRoutedNotifiers.set(value);
        }
    }

    public static boolean isMessageFromPeer() {
        return (Boolean)messageFromPeer.get();
    }

    public static void setMessageFromPeer(boolean value) {
        messageFromPeer.set(value);
    }

    public static boolean isPerClientAuthentication() {
        if (FlexContext.getMessageBroker().getLoginManager() == null) {
            return false;
        }
        return FlexContext.getMessageBroker().getLoginManager().isPerClientAuthentication();
    }

    public static Principal getUserPrincipal() {
        if (FlexContext.isPerClientAuthentication()) {
            FlexClient client = FlexContext.getFlexClient();
            if (client != null) {
                return client.getUserPrincipal();
            }
        } else {
            FlexSession session = FlexContext.getFlexSession();
            if (session != null) {
                return session.getUserPrincipal();
            }
        }
        return null;
    }

    public static void setUserPrincipal(Principal userPrincipal) {
        if (FlexContext.isPerClientAuthentication()) {
            FlexContext.getFlexClient().setUserPrincipal(userPrincipal);
        } else {
            FlexContext.getFlexSession().setUserPrincipal(userPrincipal);
        }
    }

    public static void createThreadLocalObjects() {
        if (flexClients == null) {
            flexClients = new ThreadLocal();
            sessions = new ThreadLocal();
            messageBrokers = new ThreadLocal();
            responses = new ThreadLocal();
            requests = new ThreadLocal();
            tunnelRequests = new ThreadLocal();
            servletConfigs = new ThreadLocal();
            messageFromPeer = new ThreadLocal();
            messageRoutedNotifiers = new ThreadLocal();
        }
    }

    public static void releaseThreadLocalObjects() {
        flexClients = null;
        sessions = null;
        messageBrokers = null;
        responses = null;
        requests = null;
        tunnelRequests = null;
        servletConfigs = null;
        messageFromPeer = null;
        messageRoutedNotifiers = null;
        lastGoodServletConfig = null;
    }
}

