/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Stack;

public class LocalFileResolver
implements ConfigurationFileResolver {
    private Stack configurationPathStack = new Stack();
    int version = CLIENT;
    public static int CLIENT = 0;
    public static int SERVER = 1;
    public static int LIVECYCLE = 2;

    public LocalFileResolver() {
    }

    public LocalFileResolver(int version) {
        this.version = version;
    }

    public void setErrorMessage(ConfigurationException e2, String path) {
        if (this.version == LIVECYCLE) {
            e2.setMessage(11122, new Object[]{path});
        } else if (this.version == SERVER) {
            e2.setMessage(11108);
        } else {
            e2.setMessage(11106);
        }
    }

    public InputStream getConfigurationFile(String path) {
        File f2 = new File(path);
        try {
            if (f2 != null && f2.exists() && f2.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f2);
                this.pushConfigurationFile(f2.getParent());
                return fin;
            }
            ConfigurationException e2 = new ConfigurationException();
            this.setErrorMessage(e2, path);
            throw e2;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e3 = new ConfigurationException();
            this.setErrorMessage(e3, path);
            e3.setRootCause(ex);
            throw e3;
        }
        catch (SecurityException se) {
            ConfigurationException e4 = new ConfigurationException();
            this.setErrorMessage(e4, path);
            e4.setRootCause(se);
            throw e4;
        }
    }

    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f2 = new File(path);
        try {
            if (f2 != null && f2.exists() && f2.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f2);
                this.pushConfigurationFile(f2.getParent());
                return fin;
            }
            ConfigurationException e2 = new ConfigurationException();
            e2.setMessage(11107, new Object[]{path});
            throw e2;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e3 = new ConfigurationException();
            e3.setMessage(11107, new Object[]{path});
            e3.setRootCause(ex);
            throw e3;
        }
        catch (SecurityException se) {
            ConfigurationException e4 = new ConfigurationException();
            e4.setMessage(11107, new Object[]{path});
            e4.setRootCause(se);
            throw e4;
        }
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    private void pushConfigurationFile(String topLevelPath) {
        this.configurationPathStack.push(topLevelPath);
    }

    public String getIncludedPath(String src) {
        return this.configurationPathStack.peek() + File.separator + src;
    }

    public long getIncludedLastModified(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f2 = new File(path);
        return f2.lastModified();
    }
}

