/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.ArrayList;
import flex.messaging.io.PageableRowSet;
import flex.messaging.util.UUIDUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PagedRowSet
implements PageableRowSet {
    private RowSet rowSet;
    private String[] colNames;
    private int pageSize = 50;
    private int colCount = 0;
    private int rowCount = 0;
    private String id = null;
    private String serviceName = "PageableRowSetCache";
    public static final String DEFAULT_PAGING_SERVICE_NAME = "PageableRowSetCache";

    public PagedRowSet(RowSet r2, int p2) {
        this.rowSet = r2;
        this.pageSize = p2;
        this.id = UUIDUtils.createUUID();
        this.init();
    }

    public PagedRowSet(RowSet r2, int p2, boolean createID) {
        this.rowSet = r2;
        this.pageSize = p2;
        if (createID) {
            this.id = UUIDUtils.createUUID();
        }
        this.init();
    }

    private void init() {
        if (this.rowSet != null) {
            this.initColumns();
            this.initRecords();
        } else {
            this.colNames = new String[0];
        }
    }

    private synchronized void initColumns() {
        try {
            ResultSetMetaData rsmd = this.rowSet.getMetaData();
            if (rsmd != null) {
                this.colCount = rsmd.getColumnCount();
            }
        }
        catch (SQLException ex) {
            this.colCount = 0;
        }
    }

    private synchronized void initRecords() {
        if (this.rowSet != null) {
            try {
                int currentIndex = this.rowSet.getRow();
                if (this.rowSet.last()) {
                    this.rowCount = this.rowSet.getRow();
                }
                if (currentIndex > 0) {
                    this.rowSet.absolute(currentIndex);
                } else {
                    this.rowSet.beforeFirst();
                }
            }
            catch (SQLException ex) {
                try {
                    this.rowSet.first();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public String[] getColumnNames() throws SQLException {
        if (this.colNames == null) {
            try {
                if (this.colCount == 0) {
                    this.initColumns();
                }
                this.colNames = new String[this.colCount];
                for (int i2 = 0; i2 < this.colCount; ++i2) {
                    this.colNames[i2] = this.rowSet.getMetaData().getColumnName(i2 + 1);
                }
            }
            catch (SQLException ex) {
                this.colNames = new String[0];
            }
        }
        return this.colNames;
    }

    public synchronized Map getRecords(int startIndex, int count) throws SQLException {
        ArrayList aRecords;
        block12: {
            aRecords = new ArrayList();
            if (this.colCount == 0) {
                this.initColumns();
            }
            if (startIndex < 1) {
                startIndex = 1;
            }
            if (!this.rowSet.absolute(startIndex)) break block12;
            for (int i2 = 0; i2 < count; ++i2) {
                ArrayList row;
                boolean hasNext = true;
                if (this.colCount > 0) {
                    row = new ArrayList(this.rowCount + 1);
                    for (int j2 = 1; j2 <= this.colCount; ++j2) {
                        row.add(this.rowSet.getObject(j2));
                    }
                } else {
                    row = new ArrayList();
                    try {
                        Object o2;
                        for (int j3 = 1; j3 <= 50 && (o2 = this.rowSet.getObject(j3)) != null; ++j3) {
                            row.add(o2);
                        }
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                aRecords.add(row.toArray());
                hasNext = this.rowSet.next();
                if (hasNext) {
                    continue;
                }
                break;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("Page", aRecords.toArray());
        result.put("Cursor", new Integer(startIndex));
        return result;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getInitialDownloadCount() {
        return this.pageSize;
    }

    public String getID() {
        return this.id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServicename(String serviceName) {
        this.serviceName = serviceName;
    }
}

