/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.AmfTypes;
import flex.messaging.io.amf.TraitsInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf0Output
extends AbstractAmfOutput
implements AmfTypes {
    public static final byte[] OBJECT_END_MARKER = new byte[]{0, 0, 9};
    protected IdentityHashMap serializedObjects;
    protected int serializedObjectCount = 0;
    protected boolean avmPlus;
    protected Amf3Output avmPlusOutput;

    public Amf0Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = false;
        this.serializedObjects = new IdentityHashMap(64);
    }

    public void setAvmPlus(boolean a2) {
        this.avmPlus = a2;
    }

    public void reset() {
        super.reset();
        this.serializedObjects.clear();
        this.serializedObjectCount = 0;
        if (this.avmPlusOutput != null) {
            this.avmPlusOutput.reset();
        }
    }

    protected void createAMF3Output() {
        this.avmPlusOutput = new Amf3Output(this.context);
        this.avmPlusOutput.setOutputStream(this.out);
        this.avmPlusOutput.setDebugTrace(this.trace);
    }

    public void writeObject(Object o2) throws IOException {
        if (o2 == null) {
            this.writeAMFNull();
            return;
        }
        if (o2 instanceof String) {
            this.writeAMFString((String)o2);
        } else if (o2 instanceof Number) {
            if (!this.context.legacyBigNumbers && (o2 instanceof BigInteger || o2 instanceof BigDecimal)) {
                this.writeAMFString(o2.toString());
            } else {
                this.writeAMFDouble(((Number)o2).doubleValue());
            }
        } else if (o2 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o2);
        } else if (o2 instanceof Character) {
            String s2 = o2.toString();
            this.writeAMFString(s2);
        } else if (o2 instanceof Date) {
            this.writeAMFDate((Date)o2);
        } else if (o2 instanceof Calendar) {
            this.writeAMFDate(((Calendar)o2).getTime());
        } else if (this.avmPlus) {
            if (this.avmPlusOutput == null) {
                this.createAMF3Output();
            }
            this.out.writeByte(17);
            this.avmPlusOutput.writeObject(o2);
        } else {
            Class<?> cls = o2.getClass();
            if (cls.isArray()) {
                this.writeAMFArray(o2, cls.getComponentType());
            } else if (o2 instanceof Map && this.context.legacyMap && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
            } else if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, null);
                } else {
                    this.writeArrayCollection((Collection)o2, null);
                }
            } else if (o2 instanceof Document) {
                this.out.write(15);
                String xml = this.documentToString(o2);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeUTF(xml, true, false);
            } else {
                if (o2 instanceof RowSet) {
                    o2 = new PagedRowSet((RowSet)o2, Integer.MAX_VALUE, false);
                } else if (o2 instanceof Throwable && this.context.legacyThrowable) {
                    o2 = new StatusInfoProxy((Throwable)o2);
                }
                this.writeCustomObject(o2);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo traits) throws IOException {
        String className = null;
        if (traits != null) {
            className = traits.getClassName();
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.serializedObjectCount - 1);
        }
        if (className == null || className.length() == 0) {
            this.out.write(3);
        } else {
            this.out.write(16);
            this.out.writeUTF(className);
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.out.writeUTF(name);
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        this.out.write(OBJECT_END_MARKER, 0, OBJECT_END_MARKER.length);
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b2) throws IOException {
        if (this.isDebug) {
            this.trace.write(b2);
        }
        this.out.write(1);
        this.out.writeBoolean(b2);
    }

    protected void writeAMFDouble(double d2) throws IOException {
        if (this.isDebug) {
            this.trace.write(d2);
        }
        this.out.write(0);
        this.out.writeDouble(d2);
    }

    protected void writeAMFDate(Date d2) throws IOException {
        if (this.isDebug) {
            this.trace.write(d2);
        }
        this.out.write(11);
        this.out.writeDouble(d2.getTime());
        int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
        this.out.writeShort(nCurrentTimezoneOffset / 60000);
    }

    protected void writeAMFArray(Object o2, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o2);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o2);
        } else {
            this.writeObjectArray((Object[])o2, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.serializeAsReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o2) throws IOException {
        PropertyProxy proxy = null;
        if (o2 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o2;
            if ((o2 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o2 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o2, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o2, proxy.getDescriptor());
                }
                return;
            }
            if (o2.getClass().isArray()) {
                this.writeObjectArray((Object[])o2, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o2 instanceof Map && !(o2 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o2);
                return;
            }
        }
        if (!this.serializeAsReference(o2)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o2);
            }
            this.writePropertyProxy(proxy, o2);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp, Object instance) throws IOException {
        Object newInst = pp.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        boolean externalizable = false;
        List propertyNames = pp.getPropertyNames(instance);
        TraitsInfo ti = new TraitsInfo(pp.getAlias(instance), pp.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeMapAsECMAArray(Map m2) throws IOException {
        if (!this.serializeAsReference(m2)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.serializedObjectCount - 1);
            }
            this.out.write(8);
            this.out.writeInt(0);
            for (Object key : m2.keySet()) {
                Object value = m2.get(key);
                this.writeObjectProperty(key.toString(), value);
            }
            this.writeObjectEnd();
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(5);
    }

    protected void writeAMFString(String str) throws IOException {
        if (this.isDebug) {
            this.trace.writeString(str);
        }
        this.writeUTF(str, false, true);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(values.length);
            for (int i2 = 0; i2 < values.length; ++i2) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i2);
                }
                if (!((item = values[i2]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.writeObject(item);
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c2, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(c2)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(c2.size());
            Iterator it = c2.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i2++);
                }
                if (!((item = it.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.writeObject(item);
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block11: {
            Class<?> aType;
            block10: {
                aType = obj.getClass().getComponentType();
                if (!aType.equals(Character.TYPE)) break block10;
                char[] c2 = (char[])obj;
                this.writeCharArrayAsString(c2);
                break block11;
            }
            if (this.serializeAsReference(obj)) break block11;
            if (aType.equals(Boolean.TYPE)) {
                this.out.write(10);
                boolean[] b2 = (boolean[])obj;
                this.out.writeInt(b2.length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i2 = 0; i2 < b2.length; ++i2) {
                        this.trace.arrayElement(i2);
                        this.writeAMFBoolean(b2[i2]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i3 = 0; i3 < b2.length; ++i3) {
                        this.writeAMFBoolean(b2[i3]);
                    }
                }
            } else {
                this.out.write(10);
                int length = Array.getLength(obj);
                this.out.writeInt(length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i4 = 0; i4 < length; ++i4) {
                        this.trace.arrayElement(i4);
                        double v2 = Array.getDouble(obj, i4);
                        this.writeAMFDouble(v2);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i5 = 0; i5 < length; ++i5) {
                        double v3 = Array.getDouble(obj, i5);
                        this.writeAMFDouble(v3);
                    }
                }
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca2) throws IOException {
        int length = ca2.length;
        char[] chars = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            Character c2 = ca2[i2];
            chars[i2] = c2 == null ? (char)'\u0000' : ca2[i2].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca2) throws IOException {
        this.writeAMFString(new String(ca2));
    }

    protected void writeUTF(String str, boolean forceLong, boolean writeType) throws IOException {
        byte[] bytearr;
        char c2;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        str.getChars(0, strlen, charr, 0);
        for (int i2 = 0; i2 < strlen; ++i2) {
            c2 = charr[i2];
            if (c2 <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c2 > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        int type = forceLong ? 12 : (utflen <= 65535 ? 2 : 12);
        if (writeType) {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 3 : 5));
            bytearr[count++] = (byte)type;
        } else {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 2 : 4));
        }
        if (type == 12) {
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (int i3 = 0; i3 < strlen; ++i3) {
            c2 = charr[i3];
            if (c2 <= '\u007f') {
                bytearr[count++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c2 & 0x3F);
        }
        this.out.write(bytearr, 0, count);
    }

    protected void rememberObjectReference(Object obj) {
        this.serializedObjects.put(obj, new Integer(this.serializedObjectCount++));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean serializeAsReference(Object obj) throws IOException {
        ref = this.serializedObjects.get(obj);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.out.write(7);
                this.out.writeShort(refNum);
                if (!this.isDebug) ** GOTO lbl13
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference value is not an Integer");
            }
        } else {
            this.rememberObjectReference(obj);
        }
lbl13:
        // 3 sources

        return ref != null;
    }
}

