/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import java.lang.reflect.Array;
import java.util.Collection;

public class ArrayDecoder
extends ActionScriptDecoder {
    public boolean hasShell() {
        return true;
    }

    public Object createShell(Object encodedObject, Class desiredClass) {
        Class<?> arrayElementClass = desiredClass.getComponentType();
        int size = 10;
        if (encodedObject != null) {
            if (encodedObject.getClass().isArray()) {
                size = Array.getLength(encodedObject);
            } else if (encodedObject instanceof Collection) {
                size = ((Collection)encodedObject).size();
            } else {
                TranslationException ex = new TranslationException("Could not create Array " + arrayElementClass);
                ex.setCode("Server.Processing");
                throw ex;
            }
        }
        Object shell = Array.newInstance(arrayElementClass, size);
        return shell;
    }

    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        if (shell == null || encodedObject == null) {
            return null;
        }
        Class<?> arrayElementClass = desiredClass.getComponentType();
        if (encodedObject instanceof Collection) {
            return this.decodeArray(shell, (Collection)encodedObject, arrayElementClass);
        }
        if (encodedObject.getClass().isArray()) {
            return this.decodeArray(shell, encodedObject, arrayElementClass);
        }
        if (encodedObject instanceof String && Character.class.equals(arrayElementClass)) {
            return this.decodeArray(shell, (String)encodedObject, arrayElementClass);
        }
        return null;
    }

    protected Object decodeArray(Object shellArray, String string, Class arrayElementClass) {
        if (Character.class.equals((Object)arrayElementClass)) {
            return string.toCharArray();
        }
        return null;
    }

    protected Object decodeArray(Object shellArray, Collection collection, Class arrayElementClass) {
        return this.decodeArray(shellArray, collection.toArray(), arrayElementClass);
    }

    protected Object decodeArray(Object shellArray, Object array, Class arrayElementClass) {
        Object encodedValue = null;
        Object decodedValue = null;
        int n2 = 0;
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            encodedValue = Array.get(array, i2);
            if (encodedValue == null) {
                Array.set(shellArray, n2, null);
            } else {
                ActionScriptDecoder decoder = SerializationContext.getSerializationContext().restoreReferences ? DecoderFactory.getReferenceAwareDecoder(encodedValue, arrayElementClass) : DecoderFactory.getDecoder(encodedValue, arrayElementClass);
                decodedValue = decoder.decodeObject(encodedValue, arrayElementClass);
                try {
                    Array.set(shellArray, n2, decodedValue);
                }
                catch (IllegalArgumentException ex) {
                    Array.set(shellArray, n2, null);
                }
            }
            ++n2;
        }
        return shellArray;
    }
}

