/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amfx.AmfxInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AmfxMessageDeserializer
extends DefaultHandler
implements MessageDeserializer {
    protected InputStream in;
    protected Locator locator;
    protected AmfxInput amfxIn;
    protected AmfTrace debugTrace;
    protected boolean isDebug;
    private static Class[] attribArr = new Class[]{Attributes.class};

    public void initialize(SerializationContext context, InputStream in, AmfTrace trace) {
        this.amfxIn = new AmfxInput(context);
        this.in = in;
        this.debugTrace = trace;
        boolean bl = this.isDebug = this.debugTrace != null;
        if (this.debugTrace != null) {
            this.amfxIn.setDebugTrace(this.debugTrace);
        }
    }

    public void setSerializationContext(SerializationContext context) {
        this.amfxIn = new AmfxInput(context);
    }

    public void readMessage(ActionMessage m2, ActionContext context) throws IOException {
        if (this.isDebug) {
            this.debugTrace.startRequest("Deserializing AMFX/HTTP request");
        }
        this.amfxIn.reset();
        this.amfxIn.setDebugTrace(this.debugTrace);
        this.amfxIn.setActionMessage(m2);
        this.parse(m2);
        context.setVersion(m2.getVersion());
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.amfxIn.readObject();
    }

    protected void parse(ActionMessage m2) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.in, (DefaultHandler)this);
        }
        catch (MessageException ex) {
            this.clientMessageEncodingException(m2, ex);
        }
        catch (SAXParseException e2) {
            if (e2.getException() != null) {
                this.clientMessageEncodingException(m2, e2.getException());
            } else {
                this.clientMessageEncodingException(m2, e2);
            }
        }
        catch (Exception ex) {
            this.clientMessageEncodingException(m2, ex);
        }
    }

    protected void clientMessageEncodingException(ActionMessage m2, Throwable t2) {
        MessageException me = t2 instanceof MessageException ? (MessageException)t2 : new MessageException("Error occurred parsing AMFX: " + t2.getMessage());
        me.setCode("Client.Message.Encoding");
        MessageBody body = new MessageBody();
        body.setData(me);
        m2.addBody(body);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String methodName = "start_" + localName;
            Method method = this.amfxIn.getClass().getMethod(methodName, attribArr);
            method.invoke((Object)this.amfxIn, attributes);
        }
        catch (NoSuchMethodException e2) {
            this.fatalError(new SAXParseException("Unknown type: " + qName, this.locator));
        }
        catch (IllegalAccessException e3) {
            this.fatalError(new SAXParseException(e3.getMessage(), this.locator, e3));
        }
        catch (InvocationTargetException e4) {
            Throwable t2 = e4.getTargetException();
            if (t2 instanceof SAXException) {
                throw (SAXException)t2;
            }
            if (t2 instanceof Exception) {
                this.fatalError(new SAXParseException(t2.getMessage(), this.locator, (Exception)t2));
            }
            this.fatalError(new SAXParseException(e4.getMessage(), this.locator, e4));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String methodName = "end_" + localName;
            Method method = this.amfxIn.getClass().getMethod(methodName, new Class[0]);
            method.invoke((Object)this.amfxIn, new Object[0]);
        }
        catch (NoSuchMethodException e2) {
            this.fatalError(new SAXParseException("Unfinished type: " + qName, this.locator));
        }
        catch (IllegalAccessException e3) {
            this.fatalError(new SAXParseException(e3.getMessage(), this.locator, e3));
        }
        catch (InvocationTargetException e4) {
            Throwable t2 = e4.getTargetException();
            if (t2 instanceof SAXException) {
                throw (SAXException)t2;
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            this.fatalError(new SAXParseException(t2.getMessage(), this.locator));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        if (chars.length() > 0) {
            this.amfxIn.text(chars);
        }
    }

    public void setDocumentLocator(Locator l2) {
        this.locator = l2;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw new MessageException(exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (exception.getException() != null && exception.getException() instanceof MessageException) {
            throw (MessageException)exception.getException();
        }
        throw new MessageException(exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw new MessageException(exception.getMessage());
    }
}

