/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.io.UnsupportedEncodingException;

public final class URLDecoder {
    public static String decode(String s2) {
        try {
            return URLDecoder.decode(s2, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("UTF8");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String s2, String enc) throws UnsupportedEncodingException {
        if (!URLDecoder.needsDecoding(s2)) {
            return s2;
        }
        int length = s2.length();
        byte[] bytes = new byte[length];
        s2.getBytes(0, length, bytes, 0);
        int k2 = 0;
        length = bytes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (bytes[i2] == 37) {
                while (bytes[i2 + 1] == 37) {
                    ++i2;
                }
                if (i2 >= length - 2) throw new IllegalArgumentException(s2);
                bytes[k2] = URLDecoder.x2c(bytes, i2);
                i2 += 2;
            } else {
                bytes[k2] = bytes[i2] == 43 ? 32 : bytes[i2];
            }
            ++k2;
        }
        return new String(bytes, 0, k2, enc);
    }

    private static boolean needsDecoding(String s2) {
        if (s2 == null) {
            return false;
        }
        int length = s2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '+' && c2 != '%') continue;
            return true;
        }
        return false;
    }

    private static byte x2c(byte[] b2, int i2) {
        byte b1 = b2[i2 + 1];
        byte b22 = b2[i2 + 2];
        if (b1 < 48 || b1 > 70 && b1 < 97 || b1 > 102 || b22 < 48 || b22 > 70 && b22 < 97 || b22 > 102) {
            throw new IllegalArgumentException("%" + (char)b1 + (char)b22);
        }
        int result = b1 >= 65 ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        result *= 16;
        return (byte)(result += b22 >= 65 ? (b22 & 0xDF) - 65 + 10 : b22 - 48);
    }
}

