/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.ZIndexComparator;

class RTable
extends BaseElementRenderable {
    private final TableMatrix tableMatrix;
    private SortedSet positionedRenderables;
    private int otherOrdinal;
    private volatile int lastAvailWidth = -1;
    private volatile int lastAvailHeight = -1;

    public RTable(HTMLElementImpl modelNode, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer container) {
        super(container, modelNode, pcontext);
        this.tableMatrix = new TableMatrix(modelNode, pcontext, rcontext, frameContext, this, this);
    }

    public int getVAlign() {
        return 5;
    }

    protected void applyStyle() {
        super.applyStyle();
        Insets bi = this.borderInsets;
        if (bi == null) {
            HTMLElementImpl element = (HTMLElementImpl)this.modelNode;
            String borderText = element.getAttribute("border");
            int border = 0;
            if (borderText != null) {
                try {
                    border = Integer.parseInt(borderText);
                    if (border < 0) {
                        border = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (border > 0) {
                this.borderInsets = new Insets(border, border, border, border);
            }
        }
        if (this.borderTopColor == null && this.borderLeftColor == null) {
            this.borderTopColor = this.borderLeftColor = Color.LIGHT_GRAY;
        }
        if (this.borderBottomColor == null && this.borderRightColor == null) {
            this.borderBottomColor = this.borderRightColor = Color.DARK_GRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g2) {
        try {
            this.prePaint(g2);
            Dimension size = this.getSize();
            TableMatrix tm = this.tableMatrix;
            tm.paint(g2, size);
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                Iterator i2 = prs.iterator();
                while (i2.hasNext()) {
                    PositionedRenderable pr = (PositionedRenderable)i2.next();
                    BoundableRenderable r2 = pr.renderable;
                    r2.paintTranslated(g2);
                }
            }
        }
        finally {
            super.paint(g2);
        }
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        if (availWidth != this.lastAvailWidth || availHeight != this.lastAvailHeight) {
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                prs.clear();
            }
            this.otherOrdinal = 0;
            this.clearGUIComponents();
            this.clearDelayedPairs();
            this.applyStyle();
            this.lastAvailHeight = availHeight;
            this.lastAvailWidth = availWidth;
            TableMatrix tm = this.tableMatrix;
            Insets insets = this.getInsets(false, false);
            tm.reset(insets, availWidth, availHeight);
            tm.build(availWidth, availHeight);
            tm.doLayout(insets);
            this.width = tm.getTableWidth();
            this.height = tm.getTableHeight();
            Collection pairs = this.delayedPairs;
            if (pairs != null) {
                Iterator i2 = pairs.iterator();
                while (i2.hasNext()) {
                    DelayedPair pair = (DelayedPair)i2.next();
                    if (pair.targetParent != this) continue;
                    this.importDelayedPair(pair);
                }
            }
        }
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.lastAvailHeight = -1;
        this.lastAvailWidth = -1;
    }

    public RenderableSpot getLowestRenderableSpot(int x2, int y2) {
        RenderableSpot rs;
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i2 = prs.iterator();
            while (i2.hasNext()) {
                int childY;
                PositionedRenderable pr = (PositionedRenderable)i2.next();
                BoundableRenderable r2 = pr.renderable;
                int childX = x2 - r2.getX();
                RenderableSpot rs2 = r2.getLowestRenderableSpot(childX, childY = y2 - r2.getY());
                if (rs2 == null) continue;
                return rs2;
            }
        }
        if ((rs = this.tableMatrix.getLowestRenderableSpot(x2, y2)) != null) {
            return rs;
        }
        return new RenderableSpot(this, x2, y2);
    }

    public Iterator getRenderables() {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            LinkedList<BoundableRenderable> c2 = new LinkedList<BoundableRenderable>();
            Iterator i2 = prs.iterator();
            while (i2.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i2.next();
                BoundableRenderable r2 = pr.renderable;
                c2.add(r2);
            }
            Iterator i22 = this.tableMatrix.getRenderables();
            while (i22.hasNext()) {
                c2.add((BoundableRenderable)i22.next());
            }
            return c2.iterator();
        }
        return this.tableMatrix.getRenderables();
    }

    public void repaint(ModelNode modelNode) {
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    private final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable) {
        TreeSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.otherOrdinal++));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.add(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void importDelayedPair(DelayedPair pair) {
        BoundableRenderable r2 = pair.child;
        r2.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r2, false);
    }

    public String toString() {
        return "RTable[this=" + System.identityHashCode(this) + ",node=" + this.modelNode + "]";
    }
}

