/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RWord
extends BaseBoundableRenderable {
    public final String word;
    public final FontMetrics fontMetrics;
    public final int descent;
    public final int ascentPlusLeading;

    public RWord(ModelNode me, String word, RenderableContainer container, FontMetrics fontMetrics, int descent, int ascentPlusLeading, int height) {
        super(container, me);
        this.word = word;
        this.fontMetrics = fontMetrics;
        this.descent = descent;
        this.ascentPlusLeading = ascentPlusLeading;
        this.height = height;
        this.width = fontMetrics.stringWidth(word);
    }

    protected void invalidateLayoutLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g2) {
        Color over;
        RenderState rs = this.modelNode.getRenderState();
        String word = this.word;
        int width = this.width;
        int ascentPlusLeading = this.ascentPlusLeading;
        int height = this.height;
        int textDecoration = rs.getTextDecorationMask();
        Color bkg = rs.getTextBackgroundColor();
        if (bkg != null) {
            Color oldColor = g2.getColor();
            try {
                g2.setColor(bkg);
                g2.fillRect(0, 0, width, height);
            }
            finally {
                g2.setColor(oldColor);
            }
        }
        g2.drawString(word, 0, ascentPlusLeading);
        int td = textDecoration;
        if (td != 0) {
            int lineOffset;
            if ((td & 1) != 0) {
                int lineOffset2 = ascentPlusLeading + 2;
                g2.drawLine(0, lineOffset2, width, lineOffset2);
            }
            if ((td & 4) != 0) {
                FontMetrics fm = this.fontMetrics;
                lineOffset = fm.getLeading() + (fm.getAscent() + fm.getDescent()) / 2;
                g2.drawLine(0, lineOffset, width, lineOffset);
            }
            if ((td & 2) != 0) {
                FontMetrics fm = this.fontMetrics;
                lineOffset = fm.getLeading();
                g2.drawLine(0, lineOffset, width, lineOffset);
            }
            if ((td & 8) != 0) {
                // empty if block
            }
        }
        if ((over = rs.getOverlayColor()) != null) {
            Color oldColor = g2.getColor();
            try {
                g2.setColor(over);
                g2.fillRect(0, 0, width, height);
            }
            finally {
                g2.setColor(oldColor);
            }
        }
    }

    public boolean paintSelection(Graphics g2, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        int w2;
        int len;
        FontMetrics fm;
        int startX = -1;
        int endX = -1;
        if (this == startPoint.renderable) {
            startX = startPoint.x;
        }
        if (this == endPoint.renderable) {
            endX = endPoint.x;
        }
        if (!inSelection && startX == -1 && endX == -1) {
            return false;
        }
        if (startX != -1 && endX != -1) {
            if (endX < startX) {
                int temp = startX;
                startX = endX;
                endX = temp;
            }
        } else if (startX != -1 && endX == -1 && inSelection) {
            endX = startX;
            startX = -1;
        } else if (startX == -1 && endX != -1 && !inSelection) {
            startX = endX;
            endX = -1;
        }
        int width1 = -1;
        int width2 = -1;
        char[] wordChars = this.word.toCharArray();
        if (startX != -1) {
            width1 = 0;
            fm = this.fontMetrics;
            for (len = 0; len < wordChars.length && (w2 = fm.charsWidth(wordChars, 0, len)) <= startX; ++len) {
                width1 = w2;
            }
        }
        if (endX != -1) {
            width2 = 0;
            fm = this.fontMetrics;
            for (len = 0; len < wordChars.length && (w2 = fm.charsWidth(wordChars, 0, len)) <= endX; ++len) {
                width2 = w2;
            }
        }
        if (width1 != -1 || width2 != -1) {
            int startPaint = width1 == -1 ? 0 : width1;
            int endPaint = width2 == -1 ? this.width : width2;
            g2.setColor(SELECTION_COLOR);
            g2.setXORMode(SELECTION_XOR);
            g2.fillRect(startPaint, 0, endPaint - startPaint, this.height);
            g2.setPaintMode();
            return width2 == -1;
        }
        if (inSelection) {
            g2.setColor(SELECTION_COLOR);
            g2.setXORMode(SELECTION_XOR);
            g2.fillRect(0, 0, this.width, this.height);
            g2.setPaintMode();
        }
        return inSelection;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        int w2;
        int len;
        FontMetrics fm;
        int startX = -1;
        int endX = -1;
        if (this == startPoint.renderable) {
            startX = startPoint.x;
        }
        if (this == endPoint.renderable) {
            endX = endPoint.x;
        }
        if (!inSelection && startX == -1 && endX == -1) {
            return false;
        }
        if (startX != -1 && endX != -1) {
            if (endX < startX) {
                int temp = startX;
                startX = endX;
                endX = temp;
            }
        } else if (startX != -1 && endX == -1 && inSelection) {
            endX = startX;
            startX = -1;
        } else if (startX == -1 && endX != -1 && !inSelection) {
            startX = endX;
            endX = -1;
        }
        int index1 = -1;
        int index2 = -1;
        char[] wordChars = this.word.toCharArray();
        if (startX != -1) {
            index1 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length && (w2 = fm.charsWidth(wordChars, 0, len)) <= startX) {
                index1 = len++;
            }
        }
        if (endX != -1) {
            index2 = 0;
            fm = this.fontMetrics;
            len = 0;
            while (len < wordChars.length && (w2 = fm.charsWidth(wordChars, 0, len)) <= endX) {
                index2 = len++;
            }
        }
        if (index1 != -1 || index2 != -1) {
            int startIndex = index1 == -1 ? 0 : index1;
            int endIndex = index2 == -1 ? wordChars.length : index2;
            buffer.append(wordChars, startIndex, endIndex - startIndex);
        } else if (inSelection) {
            buffer.append(wordChars);
            return true;
        }
        if (index1 != -1 && index2 != -1) {
            return false;
        }
        return !inSelection;
    }

    public RenderableSpot getLowestRenderableSpot(int x2, int y2) {
        return new RenderableSpot(this, x2, y2);
    }

    public String toString() {
        return "RWord[word=" + this.word + "]";
    }
}

