/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSFontFaceRuleImpl
implements CSSFontFaceRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private CSSStyleDeclarationImpl _style = null;

    public CSSFontFaceRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
    }

    public short getType() {
        return 5;
    }

    public String getCssText() {
        return "@font-face " + this.getStyle().getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is2 = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r10 = parser.parseRule(is2);
            if (r10.getType() != 5) {
                throw new DOMExceptionImpl(13, 8);
            }
            this._style = ((CSSFontFaceRuleImpl)r10)._style;
        }
        catch (CSSException e10) {
            throw new DOMExceptionImpl(12, 0, e10.getMessage());
        }
        catch (IOException e11) {
            throw new DOMExceptionImpl(12, 0, e11.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this._style = style;
    }
}

