/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private CSSRule _parentRule;
    private Vector _properties = new Vector();

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this._parentRule = parentRule;
    }

    public String getCssText() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("{");
        for (int i10 = 0; i10 < this._properties.size(); ++i10) {
            Property p10 = (Property)this._properties.elementAt(i10);
            if (p10 != null) {
                sb2.append(p10.toString());
            }
            if (i10 >= this._properties.size() - 1) continue;
            sb2.append("; ");
        }
        sb2.append("}");
        return sb2.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is2 = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this._properties.removeAllElements();
            parser.parseStyleDeclaration(this, is2);
        }
        catch (Exception e10) {
            throw new DOMExceptionImpl(12, 0, e10.getMessage());
        }
    }

    public String getPropertyValue(String propertyName) {
        Property p10 = this.getPropertyDeclaration(propertyName);
        return p10 != null ? p10.getValue().getCssText() : "";
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p10 = this.getPropertyDeclaration(propertyName);
        return p10 != null ? p10.getValue() : null;
    }

    public String removeProperty(String propertyName) throws DOMException {
        for (int i10 = 0; i10 < this._properties.size(); ++i10) {
            Property p10 = (Property)this._properties.elementAt(i10);
            if (!p10.getName().equalsIgnoreCase(propertyName)) continue;
            this._properties.removeElementAt(i10);
            return p10.getValue().toString();
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        Property p10 = this.getPropertyDeclaration(propertyName);
        if (p10 != null) {
            return p10.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            boolean important;
            InputSource is2 = new InputSource(new StringReader(value));
            CSSOMParser parser = new CSSOMParser();
            CSSValue expr = parser.parsePropertyValue(is2);
            Property p10 = this.getPropertyDeclaration(propertyName);
            boolean bl2 = important = priority != null ? priority.equalsIgnoreCase("important") : false;
            if (p10 == null) {
                p10 = new Property(propertyName, expr, important);
                this.addProperty(p10);
            } else {
                p10.setValue(expr);
                p10.setImportant(important);
            }
        }
        catch (Exception e10) {
            throw new DOMExceptionImpl(12, 0, e10.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int index) {
        Property p10 = (Property)this._properties.elementAt(index);
        return p10 != null ? p10.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property p10) {
        this._properties.addElement(p10);
    }

    private Property getPropertyDeclaration(String name) {
        for (int i10 = 0; i10 < this._properties.size(); ++i10) {
            Property p10 = (Property)this._properties.elementAt(i10);
            if (!p10.getName().equalsIgnoreCase(name)) continue;
            return p10;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

