/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;

public class LexicalUnitImpl
implements LexicalUnit,
Serializable {
    private short _type;
    private LexicalUnit _next;
    private LexicalUnit _prev;
    private float _floatVal;
    private String _dimension;
    private String _function;
    private LexicalUnit _params;
    private String _stringVal;

    protected LexicalUnitImpl(LexicalUnit previous, short type) {
        this._type = type;
        this._prev = previous;
        if (this._prev != null) {
            ((LexicalUnitImpl)this._prev)._next = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit previous, int value) {
        this(previous, 13);
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, float value) {
        this(previous, type);
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String dimension, float value) {
        this(previous, type);
        this._dimension = dimension;
        this._floatVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String value) {
        this(previous, type);
        this._stringVal = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String name, LexicalUnit params) {
        this(previous, type);
        this._function = name;
        this._params = params;
    }

    public short getLexicalUnitType() {
        return this._type;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this._next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this._prev;
    }

    public int getIntegerValue() {
        return (int)this._floatVal;
    }

    public float getFloatValue() {
        return this._floatVal;
    }

    public String getDimensionUnitText() {
        switch (this._type) {
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 18: {
                return "in";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 23: {
                return "%";
            }
            case 28: {
                return "deg";
            }
            case 29: {
                return "grad";
            }
            case 30: {
                return "rad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this._dimension;
            }
        }
        return "";
    }

    public String getFunctionName() {
        return this._function;
    }

    public LexicalUnit getParameters() {
        return this._params;
    }

    public String getStringValue() {
        return this._stringVal;
    }

    public LexicalUnit getSubValues() {
        return this._params;
    }

    public String toString() {
        StringBuffer sb2 = new StringBuffer();
        switch (this._type) {
            case 0: {
                sb2.append(",");
                break;
            }
            case 1: {
                sb2.append("+");
                break;
            }
            case 2: {
                sb2.append("-");
                break;
            }
            case 3: {
                sb2.append("*");
                break;
            }
            case 4: {
                sb2.append("/");
                break;
            }
            case 5: {
                sb2.append("%");
                break;
            }
            case 6: {
                sb2.append("^");
                break;
            }
            case 7: {
                sb2.append("<");
                break;
            }
            case 8: {
                sb2.append(">");
                break;
            }
            case 9: {
                sb2.append("<=");
                break;
            }
            case 10: {
                sb2.append(">=");
                break;
            }
            case 11: {
                sb2.append("~");
                break;
            }
            case 12: {
                sb2.append("inherit");
                break;
            }
            case 13: {
                sb2.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case 14: {
                sb2.append(this.trimFloat(this.getFloatValue()));
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                sb2.append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText());
                break;
            }
            case 24: {
                sb2.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case 25: {
                sb2.append("counter(");
                this.appendParams(sb2, this._params);
                sb2.append(")");
                break;
            }
            case 26: {
                sb2.append("counters(");
                this.appendParams(sb2, this._params);
                sb2.append(")");
                break;
            }
            case 27: {
                sb2.append("rgb(");
                this.appendParams(sb2, this._params);
                sb2.append(")");
                break;
            }
            case 35: {
                sb2.append(this.getStringValue());
                break;
            }
            case 36: {
                sb2.append("\"").append(this.getStringValue()).append("\"");
                break;
            }
            case 37: {
                sb2.append("attr(");
                this.appendParams(sb2, this._params);
                sb2.append(")");
                break;
            }
            case 38: {
                sb2.append("rect(");
                this.appendParams(sb2, this._params);
                sb2.append(")");
                break;
            }
            case 39: {
                sb2.append(this.getStringValue());
                break;
            }
            case 40: {
                sb2.append(this.getStringValue());
                break;
            }
            case 41: {
                sb2.append(this.getFunctionName());
                this.appendParams(sb2, this._params);
                sb2.append(")");
            }
        }
        return sb2.toString();
    }

    public String toDebugString() {
        StringBuffer sb2 = new StringBuffer();
        switch (this._type) {
            case 0: {
                sb2.append("SAC_OPERATOR_COMMA");
                break;
            }
            case 1: {
                sb2.append("SAC_OPERATOR_PLUS");
                break;
            }
            case 2: {
                sb2.append("SAC_OPERATOR_MINUS");
                break;
            }
            case 3: {
                sb2.append("SAC_OPERATOR_MULTIPLY");
                break;
            }
            case 4: {
                sb2.append("SAC_OPERATOR_SLASH");
                break;
            }
            case 5: {
                sb2.append("SAC_OPERATOR_MOD");
                break;
            }
            case 6: {
                sb2.append("SAC_OPERATOR_EXP");
                break;
            }
            case 7: {
                sb2.append("SAC_OPERATOR_LT");
                break;
            }
            case 8: {
                sb2.append("SAC_OPERATOR_GT");
                break;
            }
            case 9: {
                sb2.append("SAC_OPERATOR_LE");
                break;
            }
            case 10: {
                sb2.append("SAC_OPERATOR_GE");
                break;
            }
            case 11: {
                sb2.append("SAC_OPERATOR_TILDE");
                break;
            }
            case 12: {
                sb2.append("SAC_INHERIT");
                break;
            }
            case 13: {
                sb2.append("SAC_INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case 14: {
                sb2.append("SAC_REAL(").append(this.trimFloat(this.getFloatValue())).append(")");
                break;
            }
            case 15: {
                sb2.append("SAC_EM(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 16: {
                sb2.append("SAC_EX(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 17: {
                sb2.append("SAC_PIXEL(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 18: {
                sb2.append("SAC_INCH(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 19: {
                sb2.append("SAC_CENTIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 20: {
                sb2.append("SAC_MILLIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 21: {
                sb2.append("SAC_POINT(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 22: {
                sb2.append("SAC_PICA(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 23: {
                sb2.append("SAC_PERCENTAGE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 28: {
                sb2.append("SAC_DEGREE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 29: {
                sb2.append("SAC_GRADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 30: {
                sb2.append("SAC_RADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 31: {
                sb2.append("SAC_MILLISECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 32: {
                sb2.append("SAC_SECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 33: {
                sb2.append("SAC_HERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 34: {
                sb2.append("SAC_KILOHERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 42: {
                sb2.append("SAC_DIMENSION(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 24: {
                sb2.append("SAC_URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case 25: {
                sb2.append("SAC_COUNTER_FUNCTION(counter(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
                break;
            }
            case 26: {
                sb2.append("SAC_COUNTERS_FUNCTION(counters(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
                break;
            }
            case 27: {
                sb2.append("SAC_RGBCOLOR(rgb(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
                break;
            }
            case 35: {
                sb2.append("SAC_IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case 36: {
                sb2.append("SAC_STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case 37: {
                sb2.append("SAC_ATTR(attr(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
                break;
            }
            case 38: {
                sb2.append("SAC_RECT_FUNCTION(rect(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
                break;
            }
            case 39: {
                sb2.append("SAC_UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case 40: {
                sb2.append("SAC_SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case 41: {
                sb2.append("SAC_FUNCTION(").append(this.getFunctionName()).append("(");
                this.appendParams(sb2, this._params);
                sb2.append("))");
            }
        }
        return sb2.toString();
    }

    private void appendParams(StringBuffer sb2, LexicalUnit first) {
        for (LexicalUnit l10 = first; l10 != null; l10 = l10.getNextLexicalUnit()) {
            sb2.append(l10.toString());
        }
    }

    private String trimFloat(float f10) {
        String s10 = String.valueOf(this.getFloatValue());
        return f10 - (float)((int)f10) != 0.0f ? s10 : s10.substring(0, s10.length() - 2);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, float f10) {
        if (f10 > (float)((int)f10)) {
            return new LexicalUnitImpl(prev, 14, f10);
        }
        return new LexicalUnitImpl(prev, (int)f10);
    }

    public static LexicalUnit createPercentage(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 23, f10);
    }

    public static LexicalUnit createPixel(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 17, f10);
    }

    public static LexicalUnit createCentimeter(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 19, f10);
    }

    public static LexicalUnit createMillimeter(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 20, f10);
    }

    public static LexicalUnit createInch(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 18, f10);
    }

    public static LexicalUnit createPoint(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 21, f10);
    }

    public static LexicalUnit createPica(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 22, f10);
    }

    public static LexicalUnit createEm(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 15, f10);
    }

    public static LexicalUnit createEx(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 16, f10);
    }

    public static LexicalUnit createDegree(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 28, f10);
    }

    public static LexicalUnit createRadian(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 30, f10);
    }

    public static LexicalUnit createGradian(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 29, f10);
    }

    public static LexicalUnit createMillisecond(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 31, f10);
    }

    public static LexicalUnit createSecond(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 32, f10);
    }

    public static LexicalUnit createHertz(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 33, f10);
    }

    public static LexicalUnit createDimension(LexicalUnit prev, float f10, String dim) {
        return new LexicalUnitImpl(prev, 42, dim, f10);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit prev, float f10) {
        return new LexicalUnitImpl(prev, 34, f10);
    }

    public static LexicalUnit createCounter(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 25, "counter", params);
    }

    public static LexicalUnit createCounters(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 26, "counters", params);
    }

    public static LexicalUnit createAttr(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 37, "attr", params);
    }

    public static LexicalUnit createRect(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 38, "rect", params);
    }

    public static LexicalUnit createRgbColor(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 27, "rgb", params);
    }

    public static LexicalUnit createFunction(LexicalUnit prev, String name, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 41, name, params);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 36, value);
    }

    public static LexicalUnit createIdent(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 35, value);
    }

    public static LexicalUnit createURI(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 24, value);
    }

    public static LexicalUnit createComma(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, 0);
    }
}

