/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.log;

import flex.management.BaseControl;
import flex.management.runtime.messaging.log.LogControlMBean;
import flex.management.runtime.messaging.log.LogManager;
import flex.messaging.log.AbstractTarget;
import flex.messaging.log.Log;
import flex.messaging.log.Target;

public class LogControl
extends BaseControl
implements LogControlMBean {
    private static final String TYPE = "Log";
    private LogManager logManager;

    public LogControl(BaseControl parent, LogManager manager) {
        super(parent);
        this.logManager = manager;
        this.register();
    }

    public void changeTargetLevel(String searchId, String level) {
        Target selectedTarget = Log.getTarget(searchId);
        if (selectedTarget != null) {
            selectedTarget.setLevel(new Short(level));
        }
    }

    public String getId() {
        return this.logManager.getId();
    }

    public String getType() {
        return TYPE;
    }

    public String[] getLoggers() {
        return this.logManager.getLoggers();
    }

    public String[] getTargets() {
        return this.logManager.getTargetIds();
    }

    public void addFilterForTarget(String targetId, String filter) {
        AbstractTarget target = (AbstractTarget)this.logManager.getTarget(targetId);
        if (target != null && this.logManager.checkFilter(filter)) {
            target.addFilter(filter);
        }
    }

    public String[] getTargetFilters(String targetId) {
        return this.logManager.getTargetFilters(targetId);
    }

    public void removeFilterForTarget(String targetId, String filter) {
        AbstractTarget target = (AbstractTarget)this.logManager.getTarget(targetId);
        if (target != null && target.containsFilter(filter)) {
            target.removeFilter(filter);
        }
    }

    public String[] getCategories() {
        return this.logManager.getCategories().toArray(new String[0]);
    }

    public Integer getTargetLevel(String searchId) {
        AbstractTarget target = (AbstractTarget)this.logManager.getTarget(searchId);
        if (target != null) {
            return new Integer(target.getLevel());
        }
        return new Integer(-1);
    }
}

