/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionListener;
import flex.messaging.MessageClient;
import flex.messaging.MessageClientListener;
import flex.messaging.MessageException;
import flex.messaging.client.AsyncPollHandler;
import flex.messaging.client.EndpointPushHandler;
import flex.messaging.client.FlexClientAttributeListener;
import flex.messaging.client.FlexClientBindingEvent;
import flex.messaging.client.FlexClientBindingListener;
import flex.messaging.client.FlexClientListener;
import flex.messaging.client.FlexClientManager;
import flex.messaging.client.FlexClientNotSubscribedException;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.client.FlushResult;
import flex.messaging.client.PollFlushResult;
import flex.messaging.client.PollWaitListener;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.UUIDUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class FlexClient
extends TimeoutAbstractObject
implements FlexSessionListener,
MessageClientListener {
    public static final String FLEX_CLIENT_LOG_CATEGORY = "Client.FlexClient";
    public static final String NULL_FLEXCLIENT_ID = "nil";
    private static final int FLEX_CLIENT_INVALIDATED = 10027;
    private static final int ENDPOINT_PUSH_HANDLER_ALREADY_REGISTERED = 10033;
    private static final String POLL_WAIT_THREAD_NAME_EXTENSION = "-in-poll-wait";
    private static final CopyOnWriteArrayList createdListeners = new CopyOnWriteArrayList();
    private volatile Map attributes;
    private volatile CopyOnWriteArrayList attributeListeners;
    private volatile CopyOnWriteArrayList destroyedListeners;
    private final FlexClientManager flexClientManager;
    private final String id;
    volatile boolean invalidating;
    private final Object lock = new Object();
    private volatile CopyOnWriteArrayList messageClients;
    private final Map outboundQueues = new HashMap(1);
    private Map endpointPushHandlers;
    private final CopyOnWriteArrayList sessions = new CopyOnWriteArrayList();
    private boolean valid;
    private Principal userPrincipal;

    public static void addClientCreatedListener(FlexClientListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent((Object)listener);
        }
    }

    public static void removeClientCreatedListener(FlexClientListener listener) {
        if (listener != null) {
            createdListeners.remove((Object)listener);
        }
    }

    public FlexClient(FlexClientManager manager) {
        this(manager, UUIDUtils.createUUID());
    }

    public FlexClient(FlexClientManager manager, String id2) {
        this.id = id2;
        this.flexClientManager = manager;
        this.updateLastUse();
        this.valid = true;
        if (Log.isDebug()) {
            Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).debug("FlexClient created with id '" + this.id + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientAttributeListener(FlexClientAttributeListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.attributeListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.attributeListeners == null) {
                        this.attributeListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.attributeListeners.addIfAbsent((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientDestroyedListener(FlexClientListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            return this.attributes == null ? null : this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            if (this.attributes == null) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return Collections.enumeration(new ArrayList(this.attributes.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointPushHandler getEndpointPushHandler(String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers != null && this.endpointPushHandlers.containsKey(endpointId)) {
                return (EndpointPushHandler)this.endpointPushHandlers.get(endpointId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastUse() {
        Object object = this.lock;
        synchronized (object) {
            long currentLastUse = super.getLastUse();
            long idleTime = System.currentTimeMillis() - currentLastUse;
            if (idleTime < this.flexClientManager.getFlexClientTimeoutMillis()) {
                return currentLastUse;
            }
            if (!this.outboundQueues.isEmpty()) {
                EndpointQueue queue2 = null;
                for (EndpointQueue queue2 : this.outboundQueues.values()) {
                    if (queue2.pushSession != null) {
                        return System.currentTimeMillis();
                    }
                    if (queue2.asyncPoll != null) {
                        return System.currentTimeMillis();
                    }
                    if (this.endpointPushHandlers == null || !this.endpointPushHandlers.containsKey(queue2.endpointId)) continue;
                    return System.currentTimeMillis();
                }
            }
            for (FlexSession session : this.sessions) {
                if (session.waitMonitor == null) continue;
                for (EndpointQueue queue : session.waitMonitor.values()) {
                    if (!queue.flexClient.equals(this)) continue;
                    return System.currentTimeMillis();
                }
            }
            return currentLastUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getUserPrincipal() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPrincipal(Principal userPrincipal) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.userPrincipal = userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Iterator iter;
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.flexClientManager.removeFlexClient(this);
            this.cancelTimeout();
        }
        if (!this.sessions.isEmpty()) {
            iter = this.sessions.iterator();
            while (iter.hasNext()) {
                this.unregisterFlexSession((FlexSession)iter.next());
            }
        }
        if (this.messageClients != null && !this.messageClients.isEmpty()) {
            for (MessageClient messageClient : this.messageClients) {
                messageClient.removeMessageClientDestroyedListener(this);
                messageClient.invalidate();
            }
            this.messageClients.clear();
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            iter = this.destroyedListeners.iterator();
            while (iter.hasNext()) {
                ((FlexClientListener)iter.next()).clientDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Object[] keys = this.attributes.keySet().toArray();
            for (int i10 = 0; i10 < keys.length; ++i10) {
                this.removeAttribute((String)keys[i10]);
            }
        }
        if (this.endpointPushHandlers != null && !this.endpointPushHandlers.isEmpty()) {
            iter = this.endpointPushHandlers.values().iterator();
            while (iter.hasNext()) {
                ((EndpointPushHandler)iter.next()).close(true);
            }
            this.endpointPushHandlers = null;
        }
        object = this.lock;
        synchronized (object) {
            this.valid = false;
            this.invalidating = false;
        }
        if (Log.isDebug()) {
            Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).debug("FlexClient with id '" + this.id + "' has been invalidated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFlexSessions() {
        ArrayList currentSessions = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            currentSessions = new ArrayList(this.sessions);
        }
        return currentSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        int sessionCount;
        Object object = this.lock;
        synchronized (object) {
            sessionCount = this.sessions != null ? this.sessions.size() : 0;
        }
        return sessionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubscriptionCount() {
        int count = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.messageClients != null && !this.messageClients.isEmpty()) {
                for (MessageClient messageClient : this.messageClients) {
                    count += messageClient.getSubscriptionCount();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessageClients() {
        ArrayList currentMessageClients = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            currentMessageClients = this.messageClients != null ? new ArrayList(this.messageClients) : new ArrayList();
        }
        return currentMessageClients;
    }

    public String getId() {
        return this.id;
    }

    public long getTimeoutPeriod() {
        return this.flexClientManager.getFlexClientTimeoutMillis();
    }

    public void messageClientCreated(MessageClient messageClient) {
    }

    public void messageClientDestroyed(MessageClient messageClient) {
        this.unregisterMessageClient(messageClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushResult poll(String endpointId) {
        FlushResult flushResult = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            EndpointQueue queue = (EndpointQueue)this.outboundQueues.get(endpointId);
            if (queue != null) {
                if (!queue.messages.isEmpty()) {
                    flushResult = this.internalFlush(queue);
                }
            } else {
                this.throwNotSubscribedException(endpointId);
            }
        }
        return flushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeoutAbstractObject pollAsync(String endpointId, AsyncPollHandler handler, long waitIntervalMillis) {
        AsyncPollWithTimeout asyncPollTask = null;
        Object object = this.lock;
        synchronized (object) {
            block13: {
                this.checkValid();
                EndpointQueue queue = (EndpointQueue)this.outboundQueues.get(endpointId);
                if (queue != null) {
                    if (!queue.messages.isEmpty()) {
                        handler.asyncPollComplete(this.internalFlush(queue));
                        break block13;
                    } else {
                        FlexSession session;
                        FlexSession flexSession = session = FlexContext.getFlexSession();
                        synchronized (flexSession) {
                            AsyncPollWithTimeout parkedPoll;
                            if (session.asyncPollMap != null && (parkedPoll = session.asyncPollMap.get(endpointId)) != null) {
                                PollFlushResult result;
                                if (parkedPoll.getFlexClient().equals(this)) {
                                    result = new PollFlushResult();
                                    result.setClientProcessingSuppressed(true);
                                    handler.asyncPollComplete(result);
                                } else {
                                    result = new PollFlushResult();
                                    result.setAvoidBusyPolling(true);
                                    this.completeAsyncPoll(parkedPoll, result);
                                }
                            }
                            AsyncPollWithTimeout asyncPoll = new AsyncPollWithTimeout(this, session, queue, handler, waitIntervalMillis, endpointId);
                            FlexSession flexSession2 = session;
                            synchronized (flexSession2) {
                                if (session.asyncPollMap == null) {
                                    session.asyncPollMap = new HashMap();
                                }
                                session.asyncPollMap.put(endpointId, asyncPoll);
                            }
                            queue.asyncPoll = asyncPoll;
                            return asyncPoll;
                        }
                    }
                }
                this.throwNotSubscribedException(endpointId);
            }
            return asyncPollTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FlushResult pollWithWait(String endpointId, FlexSession session, PollWaitListener listener, long waitIntervalMillis) {
        EndpointQueue queue;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            queue = (EndpointQueue)this.outboundQueues.get(endpointId);
            if (queue != null && !queue.messages.isEmpty()) {
                return this.internalFlush(queue);
            }
        }
        if (queue != null) {
            object = session;
            synchronized (object) {
                if (session.waitMonitor != null) {
                    EndpointQueue waitingQueue = session.waitMonitor.get(endpointId);
                    if (waitingQueue != null && waitingQueue.flexClient.equals(this)) {
                        PollFlushResult result = new PollFlushResult();
                        result.setClientProcessingSuppressed(true);
                        return result;
                    }
                } else {
                    session.waitMonitor = new HashMap();
                }
                session.waitMonitor.put(endpointId, queue);
            }
            waitIntervalMillis = waitIntervalMillis == -1L ? 0L : waitIntervalMillis;
            String threadName = Thread.currentThread().getName();
            try {
                FlushResult result;
                Object currentThread;
                boolean didWait = false;
                boolean avoidBusyPolling = false;
                Object object2 = queue;
                synchronized (object2) {
                    if (queue.messages.isEmpty()) {
                        if (Log.isDebug()) {
                            Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' is waiting for new messages to arrive.");
                        }
                        didWait = true;
                        currentThread = Thread.currentThread();
                        ((Thread)currentThread).setName(threadName + POLL_WAIT_THREAD_NAME_EXTENSION);
                        if (listener != null) {
                            listener.waitStart(queue);
                        }
                        queue.wait(waitIntervalMillis);
                        ((Thread)currentThread).setName(threadName);
                        if (listener != null) {
                            listener.waitEnd(queue);
                        }
                        if (queue.avoidBusyPolling) {
                            avoidBusyPolling = true;
                            queue.avoidBusyPolling = false;
                        }
                    }
                }
                object2 = session;
                synchronized (object2) {
                    if (session.waitMonitor != null) {
                        session.waitMonitor.remove(endpointId);
                    }
                }
                if (Log.isDebug()) {
                    if (didWait) {
                        Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' is done waiting for new messages to arrive and is flushing the outbound queue.");
                    } else {
                        Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).debug("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' didn't need to wait and is flushing the outbound queue.");
                    }
                }
                currentThread = this.lock;
                synchronized (currentThread) {
                    result = this.internalFlush(queue);
                }
                if (!avoidBusyPolling) return result;
                PollFlushResult swappedPollResult = new PollFlushResult();
                if (result != null) {
                    swappedPollResult.setMessages(result.getMessages());
                    swappedPollResult.setNextFlushWaitTimeMillis(result.getNextFlushWaitTimeMillis());
                }
                swappedPollResult.setAvoidBusyPolling(true);
                return swappedPollResult;
            }
            catch (InterruptedException e10) {
                if (!Log.isWarn()) return null;
                Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).warn("Poll wait thread '" + threadName + "' for FlexClient with id '" + this.id + "' could not finish waiting for new messages to arrive " + "because it was interrupted: " + e10.toString());
                return null;
            }
        }
        this.throwNotSubscribedException(endpointId);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushResult poll(MessageClient client) {
        FlushResult flushResult = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            String endpointId = client.getEndpointId();
            EndpointQueue queue = (EndpointQueue)this.outboundQueues.get(endpointId);
            if (queue != null) {
                try {
                    flushResult = this.internalFlush(queue, client);
                }
                catch (RuntimeException e10) {
                    if (Log.isError()) {
                        Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).error("Failed to flush an outbound queue for MessageClient '" + client.getClientId() + "' for FlexClient '" + this.getId() + "'.", e10);
                    }
                    throw e10;
                }
                if (flushResult != null) {
                    flushResult.setNextFlushWaitTimeMillis(0);
                }
            } else {
                this.throwNotSubscribedException(endpointId);
            }
        }
        return flushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Message message, MessageClient messageClient) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            this.updateLastUse();
            EndpointQueue queue = (EndpointQueue)this.outboundQueues.get(messageClient.getEndpointId());
            if (queue != null) {
                boolean empty;
                EndpointQueue endpointQueue = queue;
                synchronized (endpointQueue) {
                    try {
                        queue.processor.add(queue.messages, message);
                        empty = queue.messages.isEmpty();
                        if (Log.isDebug()) {
                            Log.getLogger("Message.General").debug("Queuing message: " + message.getMessageId() + StringUtils.NEWLINE + "  to send to MessageClient: " + messageClient.getClientId() + StringUtils.NEWLINE + "  for FlexClient: " + messageClient.getFlexClient().getId() + StringUtils.NEWLINE + "  via endpoint: " + queue.endpointId + StringUtils.NEWLINE + "  client outbound queue size: " + queue.messages.size());
                        }
                    }
                    catch (RuntimeException e10) {
                        if (Log.isError()) {
                            Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).error("Failed to add a message to an outbound queue for FlexClient '" + this.getId() + "'.", e10);
                        }
                        throw e10;
                    }
                    if (!empty) {
                        queue.notifyAll();
                    }
                }
                if (!empty) {
                    if (queue.asyncPoll != null) {
                        this.completeAsyncPoll(queue.asyncPoll, this.internalFlush(queue));
                    } else if (!empty && queue.flushTask == null && (queue.pushSession != null || this.endpointPushHandlers != null && this.endpointPushHandlers.containsKey(queue.endpointId))) {
                        this.directFlush(queue);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpointPushHandler(EndpointPushHandler handler, String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers == null) {
                this.endpointPushHandlers = new HashMap(1);
            }
            if (this.endpointPushHandlers.containsKey(endpointId)) {
                MessageException me2 = new MessageException();
                me2.setMessage(10033, new Object[]{this.getId(), endpointId});
                throw me2;
            }
            this.endpointPushHandlers.put(endpointId, handler);
        }
    }

    public void registerFlexSession(FlexSession session) {
        if (this.sessions.addIfAbsent((Object)session)) {
            session.addSessionDestroyedListener(this);
            session.registerFlexClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageClient(MessageClient messageClient) {
        if (this.messageClients == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageClients == null) {
                    this.messageClients = new CopyOnWriteArrayList();
                }
            }
        }
        if (this.messageClients.addIfAbsent((Object)messageClient)) {
            messageClient.addMessageClientDestroyedListener(this);
            String endpointId = messageClient.getEndpointId();
            Object object = this.lock;
            synchronized (object) {
                EndpointPushHandler handler;
                this.getOrCreateEndpointQueueAndRegisterSubscription(messageClient, endpointId);
                if (this.endpointPushHandlers != null && (handler = (EndpointPushHandler)this.endpointPushHandlers.get(endpointId)) != null) {
                    handler.registerMessageClient(messageClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            value = this.attributes != null ? this.attributes.remove(name) : null;
        }
        if (value == null) {
            return;
        }
        this.notifyAttributeUnbound(name, value);
        this.notifyAttributeRemoved(name, value);
    }

    public void removeClientAttributeListener(FlexClientAttributeListener listener) {
        if (listener != null && this.attributeListeners != null) {
            this.attributeListeners.remove((Object)listener);
        }
    }

    public void removeClientDestroyedListener(FlexClientListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove((Object)listener);
        }
    }

    public void sessionCreated(FlexSession session) {
    }

    public void sessionDestroyed(FlexSession session) {
        this.unregisterFlexSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.updateLastUse();
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            oldValue = this.attributes.put(name, value);
        }
        if (oldValue == null) {
            this.notifyAttributeBound(name, value);
            this.notifyAttributeAdded(name, value);
        } else {
            this.notifyAttributeUnbound(name, oldValue);
            this.notifyAttributeReplaced(name, oldValue);
            this.notifyAttributeBound(name, value);
        }
    }

    public void timeout() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEndpointPushHandler(EndpointPushHandler handler, String endpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointPushHandlers == null) {
                return;
            }
            if (this.endpointPushHandlers.get(endpointId).equals(handler)) {
                this.endpointPushHandlers.remove(endpointId);
            }
        }
    }

    public void unregisterFlexSession(FlexSession session) {
        if (this.sessions.remove((Object)session)) {
            session.removeSessionDestroyedListener(this);
            session.unregisterFlexClient(this);
            if (this.sessions.isEmpty()) {
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageClient(MessageClient messageClient) {
        if (this.messageClients != null && this.messageClients.remove((Object)messageClient)) {
            messageClient.removeMessageClientDestroyedListener(this);
            String endpointId = messageClient.getEndpointId();
            Object object = this.lock;
            synchronized (object) {
                EndpointPushHandler handler;
                EndpointQueue queue = (EndpointQueue)this.outboundQueues.get(endpointId);
                if (queue != null) {
                    Object flushResult;
                    --queue.messageClientRefCount;
                    if (!messageClient.isAttemptingInvalidationClientNotification()) {
                        Object messageClientId = messageClient.getClientId();
                        Iterator iter = queue.messages.iterator();
                        while (iter.hasNext()) {
                            Message message = (Message)iter.next();
                            if (!message.getClientId().equals(messageClientId)) continue;
                            iter.remove();
                        }
                    }
                    if (queue.messageClientRefCount == 0 && (queue.messages.isEmpty() || messageClient.isClientChannelDisconnected())) {
                        if (queue.asyncPoll != null) {
                            flushResult = this.internalFlush(queue);
                            if (!messageClient.isAttemptingInvalidationClientNotification()) {
                                CommandMessage msg = new CommandMessage();
                                msg.setClientId(messageClient.getClientId());
                                msg.setOperation(10);
                                ArrayList<CommandMessage> messages = ((FlushResult)flushResult).getMessages();
                                if (messages == null) {
                                    messages = new ArrayList<CommandMessage>(1);
                                }
                                messages.add(msg);
                            }
                            this.completeAsyncPoll(queue.asyncPoll, (FlushResult)flushResult);
                        }
                        this.outboundQueues.remove(endpointId);
                    }
                    flushResult = queue;
                    synchronized (flushResult) {
                        queue.notifyAll();
                    }
                }
                if (this.endpointPushHandlers != null && (handler = (EndpointPushHandler)this.endpointPushHandlers.get(endpointId)) != null) {
                    handler.unregisterMessageClient(messageClient);
                }
            }
        }
    }

    void notifyCreated() {
        if (!createdListeners.isEmpty()) {
            Iterator iter = createdListeners.iterator();
            while (iter.hasNext()) {
                ((FlexClientListener)iter.next()).clientCreated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAsyncPoll(AsyncPollWithTimeout asyncPoll, FlushResult result) {
        Object object = this.lock;
        synchronized (object) {
            FlexSession session;
            asyncPoll.cancelTimeout();
            EndpointQueue queue = asyncPoll.getEndpointQueue();
            if (queue.asyncPoll.equals(asyncPoll)) {
                queue.asyncPoll = null;
            }
            FlexSession flexSession = session = asyncPoll.getFlexSession();
            synchronized (flexSession) {
                if (session.asyncPollMap != null) {
                    session.asyncPollMap.remove(asyncPoll.getEndpointId());
                }
            }
            asyncPoll.getHandler().asyncPollComplete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directFlush(EndpointQueue queue) {
        Object object = this.lock;
        synchronized (object) {
            FlushResult flushResult;
            if (!this.valid) {
                return;
            }
            if (queue.flushTask != null) {
                queue.flushTask = null;
            }
            if ((flushResult = this.internalFlush(queue)) != null) {
                int flushWaitTime;
                List messages = flushResult.getMessages();
                if (messages != null && !messages.isEmpty()) {
                    this.updateLastUse();
                    if (queue.pushSession != null) {
                        Iterator iter = messages.iterator();
                        while (iter.hasNext()) {
                            queue.pushSession.push((Message)iter.next());
                        }
                    } else if (this.endpointPushHandlers != null) {
                        EndpointPushHandler handler = (EndpointPushHandler)this.endpointPushHandlers.get(queue.endpointId);
                        handler.pushMessages(messages);
                    }
                }
                if ((flushWaitTime = flushResult.getNextFlushWaitTimeMillis()) > 0) {
                    queue.flushTask = new FlexClientFlushTask(queue);
                    this.flexClientManager.scheduleFlush(queue.flushTask, flushWaitTime);
                } else {
                    return;
                }
            }
        }
    }

    private EndpointQueue getOrCreateEndpointQueueAndRegisterSubscription(MessageClient messageClient, String endpointId) {
        EndpointQueue newQueue = null;
        if (!this.outboundQueues.containsKey(endpointId)) {
            newQueue = new EndpointQueue();
            newQueue.flexClient = this;
            newQueue.endpointId = endpointId;
            newQueue.messages = new ArrayList();
            FlexSession session = messageClient.getFlexSession();
            if (session.isPushSupported()) {
                newQueue.pushSession = session;
            }
            newQueue.processor = this.flexClientManager.createOutboundQueueProcessor(this, endpointId);
            newQueue.messageClientRefCount = 1;
            this.outboundQueues.put(endpointId, newQueue);
        } else {
            newQueue = (EndpointQueue)this.outboundQueues.get(endpointId);
            ++newQueue.messageClientRefCount;
            FlexSession session = messageClient.getFlexSession();
            if (session.isPushSupported()) {
                newQueue.pushSession = session;
            }
        }
        return newQueue;
    }

    private FlushResult internalFlush(EndpointQueue queue) {
        return this.internalFlush(queue, null);
    }

    private FlushResult internalFlush(EndpointQueue queue, MessageClient client) {
        FlushResult flushResult = null;
        try {
            List messages;
            flushResult = client == null ? queue.processor.flush(queue.messages) : queue.processor.flush(client, queue.messages);
            this.shutdownQueue(queue);
            List list = messages = flushResult != null ? flushResult.getMessages() : null;
            if (messages != null && !messages.isEmpty()) {
                this.updateLastUse();
            }
        }
        catch (RuntimeException e10) {
            if (Log.isError()) {
                Log.getLogger(FLEX_CLIENT_LOG_CATEGORY).error("Failed to flush an outbound queue for FlexClient '" + this.getId() + "'.", e10);
            }
            throw e10;
        }
        return flushResult;
    }

    private void notifyAttributeAdded(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexClientAttributeListener)iter.next()).attributeAdded(event);
            }
        }
    }

    private void notifyAttributeBound(String name, Object value) {
        if (value != null && value instanceof FlexClientBindingListener) {
            FlexClientBindingEvent bindingEvent = new FlexClientBindingEvent(this, name);
            ((FlexClientBindingListener)value).valueBound(bindingEvent);
        }
    }

    private void notifyAttributeRemoved(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexClientAttributeListener)iter.next()).attributeRemoved(event);
            }
        }
    }

    private void notifyAttributeReplaced(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexClientBindingEvent event = new FlexClientBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexClientAttributeListener)iter.next()).attributeReplaced(event);
            }
        }
    }

    private void notifyAttributeUnbound(String name, Object value) {
        if (value != null && value instanceof FlexClientBindingListener) {
            FlexClientBindingEvent bindingEvent = new FlexClientBindingEvent(this, name);
            ((FlexClientBindingListener)value).valueUnbound(bindingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                MessageException e10 = new MessageException();
                e10.setMessage(10027);
                throw e10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownQueue(EndpointQueue queue) {
        if (queue.messageClientRefCount == 0 && queue.messages.isEmpty()) {
            this.outboundQueues.remove(queue.endpointId);
            EndpointQueue endpointQueue = queue;
            synchronized (endpointQueue) {
                queue.notifyAll();
            }
            return true;
        }
        return false;
    }

    private void throwNotSubscribedException(String endpointId) {
        List<FlexClient> flexClients = FlexContext.getFlexSession().getFlexClients();
        for (FlexClient otherClient : flexClients) {
            if (otherClient.equals(this)) continue;
            List otherSubs = otherClient.getMessageClients();
            for (MessageClient otherSub : otherSubs) {
                if (!otherSub.getEndpointId().equals(endpointId)) continue;
                FlexClientNotSubscribedException e10 = new FlexClientNotSubscribedException();
                e10.setMessage(10036, new Object[]{endpointId});
                e10.setCode("Server.Processing.NotSubscribed");
                throw e10;
            }
        }
        FlexClientNotSubscribedException e11 = new FlexClientNotSubscribedException();
        e11.setMessage(10028, new Object[]{endpointId});
        e11.setCode("Server.Processing.NotSubscribed");
        throw e11;
    }

    public static class EndpointQueue {
        public FlexClient flexClient;
        public String endpointId;
        public List messages;
        public FlexClientOutboundQueueProcessor processor;
        public AsyncPollWithTimeout asyncPoll;
        public FlexSession pushSession;
        public TimerTask flushTask;
        public int messageClientRefCount;
        public boolean avoidBusyPolling;
    }

    class FlexClientFlushTask
    extends TimerTask {
        private final EndpointQueue queue;

        public FlexClientFlushTask(EndpointQueue queue) {
            this.queue = queue;
        }

        public synchronized void run() {
            FlexContext.setThreadLocalFlexClient(FlexClient.this);
            FlexClient.this.directFlush(this.queue);
            FlexContext.setThreadLocalFlexClient(null);
        }
    }

    public class AsyncPollWithTimeout
    extends TimeoutAbstractObject {
        private final FlexClient flexClient;
        private final FlexSession session;
        private final EndpointQueue queue;
        private final AsyncPollHandler handler;
        private final String endpointId;

        public AsyncPollWithTimeout(FlexClient flexClient2, FlexSession session, EndpointQueue queue, AsyncPollHandler handler, long waitIntervalMillis, String endpointId) {
            this.flexClient = flexClient2;
            this.session = session;
            this.queue = queue;
            this.handler = handler;
            this.setTimeoutPeriod(waitIntervalMillis);
            FlexClient.this.flexClientManager.monitorAsyncPollTimeout(this);
            this.endpointId = endpointId;
        }

        public FlexClient getFlexClient() {
            return this.flexClient;
        }

        public FlexSession getFlexSession() {
            return this.session;
        }

        public EndpointQueue getEndpointQueue() {
            return this.queue;
        }

        public AsyncPollHandler getHandler() {
            return this.handler;
        }

        public String getEndpointId() {
            return this.endpointId;
        }

        public void timeout() {
            FlexClient.this.completeAsyncPoll(this, null);
        }
    }
}

