/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class ClusterNode {
    private final String host;
    private final Map destKeyToChannelMap;

    ClusterNode(Address address) {
        IpAddress addr = (IpAddress)address;
        this.host = addr.getIpAddress().getCanonicalHostName();
        this.destKeyToChannelMap = new HashMap();
    }

    String getHost() {
        return this.host;
    }

    Map getDestKeyToChannelMap() {
        return this.destKeyToChannelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getEndpoints(String serviceType, String destName) {
        String destKey = serviceType + ":" + destName;
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            HashMap channelEndpoints = (HashMap)this.destKeyToChannelMap.get(destKey);
            if (channelEndpoints == null) {
                channelEndpoints = new HashMap();
                this.destKeyToChannelMap.put(destKey, channelEndpoints);
            }
            return channelEndpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            Map channelEndpoints = this.getEndpoints(serviceType, destName);
            channelEndpoints.put(channelId, endpointUrl);
        }
    }

    boolean containsEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        Map channelEndpoints = this.getEndpoints(serviceType, destName);
        return channelEndpoints.containsKey(channelId) && channelEndpoints.get(channelId).equals(endpointUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb2 = new StringBuffer("ClusterNode[");
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            Iterator iter = this.destKeyToChannelMap.keySet().iterator();
            while (iter.hasNext()) {
                String destKey = (String)iter.next();
                sb2.append(" channels for ");
                sb2.append(destKey);
                sb2.append("(");
                Map channelEndpoints = (Map)this.destKeyToChannelMap.get(destKey);
                Iterator dit = channelEndpoints.keySet().iterator();
                while (dit.hasNext()) {
                    String channelId = (String)dit.next();
                    String endpointUrl = (String)channelEndpoints.get(channelId);
                    sb2.append(channelId);
                    sb2.append("=");
                    sb2.append(endpointUrl);
                    if (!dit.hasNext()) continue;
                    sb2.append(", ");
                }
                sb2.append(")");
            }
        }
        sb2.append(" ]");
        return sb2.toString();
    }
}

