/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.Server;
import flex.messaging.client.FlexClientManager;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FactorySettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.PropertiesSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import flex.messaging.config.SharedServerSettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.config.TargetSettings;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.log.Log;
import flex.messaging.log.Target;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import flex.messaging.services.AuthenticationService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.RedeployManager;
import flex.messaging.util.StringUtils;
import flex.messaging.util.ToStringPrettyPrinter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessagingConfiguration
implements ServicesConfiguration {
    private final Map channelSettings = new HashMap();
    private final List defaultChannels = new ArrayList(4);
    private final SecuritySettings securitySettings;
    private final List serviceSettings;
    private final List sharedServerSettings;
    private LoggingSettings loggingSettings;
    private SystemSettings systemSettings;
    private FlexClientSettings flexClientSettings;
    private final Map clusterSettings = new HashMap();
    private final Map factorySettings = new HashMap();

    public MessagingConfiguration() {
        this.serviceSettings = new ArrayList();
        this.sharedServerSettings = new ArrayList();
        this.securitySettings = new SecuritySettings();
    }

    public void configureBroker(MessageBroker broker) {
        broker.setChannelSettings(this.channelSettings);
        broker.setSecuritySettings(this.securitySettings);
        broker.setSystemSettings(this.systemSettings);
        broker.setFlexClientSettings(this.flexClientSettings);
        this.createAuthorizationManager(broker);
        this.createFlexClientManager(broker);
        this.createRedeployManager(broker);
        this.createFactories(broker);
        this.createSharedServers(broker);
        this.createEndpoints(broker);
        broker.setDefaultChannels(this.defaultChannels);
        this.prepareClusters(broker);
        this.createServices(broker);
    }

    public MessageBroker createBroker(String id2, ClassLoader loader) {
        return new MessageBroker(this.systemSettings.isManageable(), id2, loader);
    }

    private void createFactories(MessageBroker broker) {
        for (Map.Entry entry : this.factorySettings.entrySet()) {
            String id2 = (String)entry.getKey();
            FactorySettings factorySetting = (FactorySettings)entry.getValue();
            broker.addFactory(id2, factorySetting.createFactory());
        }
    }

    private void createFlexClientManager(MessageBroker broker) {
        FlexClientManager flexClientManager = new FlexClientManager(broker.isManaged(), broker);
        broker.setFlexClientManager(flexClientManager);
    }

    private void createRedeployManager(MessageBroker broker) {
        RedeployManager redeployManager = new RedeployManager();
        redeployManager.setEnabled(this.systemSettings.getRedeployEnabled());
        redeployManager.setWatchInterval(this.systemSettings.getWatchInterval());
        redeployManager.setTouchFiles(this.systemSettings.getTouchFiles());
        redeployManager.setWatchFiles(this.systemSettings.getWatchFiles());
        broker.setRedeployManager(redeployManager);
    }

    private void createAuthorizationManager(MessageBroker broker) {
        LoginManager loginManager = new LoginManager();
        LoginCommand loginCommand = null;
        Map loginCommands = this.securitySettings.getLoginCommands();
        LoginCommandSettings loginCommandSettings = (LoginCommandSettings)loginCommands.get("all");
        if (loginCommandSettings != null) {
            loginCommand = this.initLoginCommand(loginCommandSettings);
        } else {
            String serverInfo = this.securitySettings.getServerInfo();
            loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverInfo);
            if (loginCommandSettings != null) {
                loginCommand = this.initLoginCommand(loginCommandSettings);
            } else {
                serverInfo = serverInfo.toLowerCase();
                for (String serverMatch : loginCommands.keySet()) {
                    loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverMatch);
                    if (serverInfo.indexOf(serverMatch.toLowerCase()) == -1) continue;
                    loginCommands.put(serverInfo, loginCommandSettings);
                    loginCommand = this.initLoginCommand(loginCommandSettings);
                    break;
                }
            }
        }
        if (loginCommand == null) {
            if (Log.isWarn()) {
                Log.getLogger("Configuration").warn("No login command was found for '" + this.securitySettings.getServerInfo() + "'. Please ensure that the login-command tag has the correct server attribute value" + ", or use 'all' to use the login command regardless of the server.");
            }
        } else {
            loginManager.setLoginCommand(loginCommand);
        }
        if (loginCommandSettings != null) {
            loginManager.setPerClientAuthentication(loginCommandSettings.isPerClientAuthentication());
        }
        broker.setLoginManager(loginManager);
    }

    private LoginCommand initLoginCommand(LoginCommandSettings loginCommandSettings) {
        String loginClass = loginCommandSettings.getClassName();
        Class c10 = ClassUtil.createClass(loginClass, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        LoginCommand loginCommand = (LoginCommand)ClassUtil.createDefaultInstance(c10, LoginCommand.class);
        return loginCommand;
    }

    private void createSharedServers(MessageBroker broker) {
        int n10 = this.sharedServerSettings.size();
        for (int i10 = 0; i10 < n10; ++i10) {
            SharedServerSettings settings = (SharedServerSettings)this.sharedServerSettings.get(i10);
            String id2 = settings.getId();
            String className = settings.getClassName();
            Class serverClass = ClassUtil.createClass(className, broker.getClassLoader());
            Server server = (Server)ClassUtil.createDefaultInstance(serverClass, Server.class);
            server.initialize(id2, settings.getProperties());
            if (broker.isManaged() && server instanceof ManageableComponent) {
                ManageableComponent manageableServer = (ManageableComponent)((Object)server);
                manageableServer.setManaged(true);
                manageableServer.setParent(broker);
            }
            broker.addServer(server);
            if (!Log.isInfo()) continue;
            Log.getLogger("Configuration").info("Server " + id2 + " of type " + className + " created.");
        }
    }

    private void createEndpoints(MessageBroker broker) {
        for (String id2 : this.channelSettings.keySet()) {
            ChannelSettings chanSettings = (ChannelSettings)this.channelSettings.get(id2);
            String url = chanSettings.getUri();
            String endpointClassName = chanSettings.getEndpointType();
            if (chanSettings.isRemote()) continue;
            Endpoint endpoint = broker.createEndpoint(id2, url, endpointClassName);
            endpoint.setSecurityConstraint(chanSettings.getConstraint());
            endpoint.setClientType(chanSettings.getClientType());
            String referencedServerId = chanSettings.getServerId();
            if (referencedServerId != null && endpoint instanceof Endpoint2) {
                Server server = broker.getServer(referencedServerId);
                if (server == null) {
                    ConfigurationException ce2 = new ConfigurationException();
                    ce2.setMessage(11128, new Object[]{chanSettings.getId(), referencedServerId});
                    throw ce2;
                }
                ((Endpoint2)endpoint).setServer(broker.getServer(referencedServerId));
            }
            endpoint.initialize(id2, chanSettings.getProperties());
            if (!Log.isInfo()) continue;
            String endpointURL = endpoint.getUrl();
            String endpointSecurity = EndpointControl.getSecurityConstraintOf(endpoint);
            if (StringUtils.isEmpty(endpointSecurity)) {
                endpointSecurity = "None";
            }
            Log.getLogger("Configuration").info("Endpoint " + id2 + " created with security: " + endpointSecurity + StringUtils.NEWLINE + "at URL: " + endpointURL);
        }
    }

    private void createServices(MessageBroker broker) {
        AuthenticationService authService = new AuthenticationService();
        authService.setMessageBroker(broker);
        for (ServiceSettings svcSettings : this.serviceSettings) {
            String svcId = svcSettings.getId();
            String svcClassName = svcSettings.getClassName();
            Service service = broker.createService(svcId, svcClassName);
            service.initialize(svcId, svcSettings.getProperties());
            for (ChannelSettings chanSettings : svcSettings.getDefaultChannels()) {
                service.addDefaultChannel(chanSettings.getId());
            }
            Map svcAdapterSettings = svcSettings.getAllAdapterSettings();
            for (AdapterSettings as2 : svcAdapterSettings.values()) {
                service.registerAdapter(as2.getId(), as2.getClassName());
                if (!as2.isDefault()) continue;
                service.setDefaultAdapter(as2.getId());
            }
            Map destinationSettings = svcSettings.getDestinationSettings();
            for (String destName : destinationSettings.keySet()) {
                DestinationSettings destSettings = (DestinationSettings)destinationSettings.get(destName);
                this.createDestination(destSettings, service, svcSettings);
            }
        }
    }

    private void createDestination(DestinationSettings destSettings, Service service, ServiceSettings svcSettings) {
        String destId = destSettings.getId();
        Destination destination = service.createDestination(destId);
        List chanSettings = destSettings.getChannelSettings();
        if (chanSettings.size() > 0) {
            ArrayList<String> channelIds = new ArrayList<String>(2);
            for (ChannelSettings cs2 : chanSettings) {
                channelIds.add(cs2.getId());
            }
            destination.setChannels(channelIds);
        }
        SecurityConstraint constraint = destSettings.getConstraint();
        destination.setSecurityConstraint(constraint);
        destination.initialize(destId, svcSettings.getProperties());
        destination.initialize(destId, destSettings.getAdapterSettings().getProperties());
        destination.initialize(destId, destSettings.getProperties());
        this.createAdapter(destination, destSettings, svcSettings);
    }

    private void createAdapter(Destination destination, DestinationSettings destSettings, ServiceSettings svcSettings) {
        AdapterSettings adapterSettings = destSettings.getAdapterSettings();
        String adapterId = adapterSettings.getId();
        ServiceAdapter adapter = destination.createAdapter(adapterId);
        adapter.initialize(adapterId, svcSettings.getProperties());
        adapter.initialize(adapterId, adapterSettings.getProperties());
        adapter.initialize(adapterId, destSettings.getProperties());
    }

    public void createLogAndTargets() {
        if (this.loggingSettings == null) {
            Log.setPrettyPrinterClass(ToStringPrettyPrinter.class.getName());
            return;
        }
        Log.createLog();
        ConfigMap properties = this.loggingSettings.getProperties();
        if (properties.getPropertyAsString("pretty-printer", null) == null) {
            Log.setPrettyPrinterClass(ToStringPrettyPrinter.class.getName());
        }
        Log.initialize(null, properties);
        List targets = this.loggingSettings.getTargets();
        for (TargetSettings targetSettings : targets) {
            String className = targetSettings.getClassName();
            Class c10 = ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
            try {
                Target target = (Target)c10.newInstance();
                target.setLevel(Log.readLevel(targetSettings.getLevel()));
                target.setFilters(targetSettings.getFilters());
                target.initialize(null, targetSettings.getProperties());
                Log.addTarget(target);
            }
            catch (Throwable t10) {
                if (t10 instanceof InvocationTargetException) {
                    t10 = ((InvocationTargetException)t10).getCause();
                }
                System.err.println("*** Error setting up logging system");
                t10.printStackTrace();
                ConfigurationException cx2 = new ConfigurationException();
                cx2.setMessage(10126, new Object[]{className});
                cx2.setRootCause(t10);
                throw cx2;
            }
        }
    }

    private void prepareClusters(MessageBroker broker) {
        ClusterManager clusterManager = broker.getClusterManager();
        for (String clusterId : this.clusterSettings.keySet()) {
            ClusterSettings cs2 = (ClusterSettings)this.clusterSettings.get(clusterId);
            clusterManager.prepareCluster(cs2);
        }
    }

    public void addSharedServerSettings(SharedServerSettings settings) {
        this.sharedServerSettings.add(settings);
    }

    public void addChannelSettings(String id2, ChannelSettings settings) {
        this.channelSettings.put(id2, settings);
    }

    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void addDefaultChannel(String id2) {
        this.defaultChannels.add(id2);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    public ServiceSettings getServiceSettings(String id2) {
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            if (!serviceSettings.getId().equals(id2)) continue;
            return serviceSettings;
        }
        return null;
    }

    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void setLoggingSettings(LoggingSettings loggingSettings) {
        this.loggingSettings = loggingSettings;
    }

    public void setSystemSettings(SystemSettings ss2) {
        this.systemSettings = ss2;
    }

    public SystemSettings getSystemSettings() {
        return this.systemSettings;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            for (ClusterSettings cs2 : this.clusterSettings.values()) {
                if (!cs2.isDefault()) continue;
                ConfigurationException cx2 = new ConfigurationException();
                cx2.setMessage(10214, new Object[]{settings.getClusterName(), cs2.getClusterName()});
                throw cx2;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx3 = new ConfigurationException();
            cx3.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx3;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    public ClusterSettings getClusterSettings(String clusterId) {
        for (ClusterSettings cs2 : this.clusterSettings.values()) {
            if (cs2.getClusterName() == clusterId) {
                return cs2;
            }
            if (cs2.getClusterName() == null || !cs2.getClusterName().equals(clusterId)) continue;
            return cs2;
        }
        return null;
    }

    public ClusterSettings getDefaultCluster() {
        for (ClusterSettings cs2 : this.clusterSettings.values()) {
            if (!cs2.isDefault()) continue;
            return cs2;
        }
        return null;
    }

    public void addFactorySettings(String id2, FactorySettings settings) {
        this.factorySettings.put(id2, settings);
    }

    public void reportUnusedProperties() {
        ArrayList findings = new ArrayList();
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            this.gatherUnusedProperties(serviceSettings.getId(), serviceSettings.getSourceFile(), "service", serviceSettings, findings);
            for (DestinationSettings destinationSettings : serviceSettings.getDestinationSettings().values()) {
                this.gatherUnusedProperties(destinationSettings.getId(), destinationSettings.getSourceFile(), "destination", destinationSettings, findings);
                AdapterSettings adapterSettings = destinationSettings.getAdapterSettings();
                if (adapterSettings == null) continue;
                this.gatherUnusedProperties(adapterSettings.getId(), adapterSettings.getSourceFile(), "adapter", adapterSettings, findings);
            }
        }
        for (ChannelSettings channelSettings : this.channelSettings.values()) {
            if (channelSettings.isRemote()) continue;
            this.gatherUnusedProperties(channelSettings.getId(), channelSettings.getSourceFile(), "channel", channelSettings, findings);
        }
        for (SharedServerSettings serverSettings : this.sharedServerSettings) {
            this.gatherUnusedProperties(serverSettings.getId(), serverSettings.getSourceFile(), "server", serverSettings, findings);
        }
        if (!findings.isEmpty()) {
            int errorNumber = 10149;
            ConfigurationException exception = new ConfigurationException();
            StringBuffer allDetails = new StringBuffer();
            for (int i10 = 0; i10 < findings.size(); ++i10) {
                allDetails.append(StringUtils.NEWLINE);
                allDetails.append("  ");
                exception.setDetails(errorNumber, "pattern", (Object[])findings.get(i10));
                allDetails.append(exception.getDetails());
                exception.setDetails(null);
            }
            exception.setMessage(errorNumber, new Object[]{allDetails});
            throw exception;
        }
    }

    private void gatherUnusedProperties(String settingsId, String settingsSource, String settingsType, PropertiesSettings settings, Collection result) {
        List unusedProperties = settings.getProperties().findAllUnusedProperties();
        int size = unusedProperties.size();
        if (size > 0) {
            for (int i10 = 0; i10 < size; ++i10) {
                String path = (String)unusedProperties.get(i10);
                result.add(new Object[]{path, settingsType, settingsId, settingsSource});
            }
        }
    }
}

