/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.servlet.ServletContext;

public class ServletResourceResolver
implements ConfigurationFileResolver {
    private ServletContext context;
    private Stack configurationPathStack = new Stack();

    public ServletResourceResolver(ServletContext context) {
        this.context = context;
    }

    public boolean isAvailable(String path, boolean throwError) throws ConfigurationException {
        boolean available = false;
        InputStream is2 = this.context.getResourceAsStream(path);
        if (is2 != null) {
            try {
                is2.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.pushConfigurationFile(path);
            available = true;
        } else if (throwError) {
            ConfigurationException e10 = new ConfigurationException();
            e10.setMessage(11108, new Object[]{path});
            throw e10;
        }
        return available;
    }

    public InputStream getConfigurationFile(String path) {
        InputStream is2 = this.context.getResourceAsStream(path);
        if (is2 != null) {
            this.pushConfigurationFile(path);
            return is2;
        }
        ConfigurationException e10 = new ConfigurationException();
        e10.setMessage(11108, new Object[]{path});
        throw e10;
    }

    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + "/" + src;
        InputStream is2 = this.context.getResourceAsStream(path);
        if (is2 != null) {
            this.pushConfigurationFile(path);
            return is2;
        }
        ConfigurationException e10 = new ConfigurationException();
        e10.setMessage(11107, new Object[]{path});
        throw e10;
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    private void pushConfigurationFile(String path) {
        String topLevelPath = path.substring(0, path.lastIndexOf("/"));
        this.configurationPathStack.push(topLevelPath);
    }
}

